/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.util.MutableDouble;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0003'()B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016Jt\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u001d2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0012\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0\u001dH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/base/stat/Bin2dStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "binCountX", "", "binCountY", "binWidthX", "", "binWidthY", "drop", "", "(IILjava/lang/Double;Ljava/lang/Double;Z)V", "binOptionsX", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "binOptionsY", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "computeBins", "Ljetbrains/datalore/plot/base/stat/Bin2dStat$Bins2dData;", "xValues", "", "yValues", "xStart", "yStart", "binWidth", "binHeight", "weightAtIndex", "densityNormalizingFactor", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "Bins2dData", "Bins2dWeightedCounts", "Companion", "plot-base-portable"})
public final class Bin2dStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean drop;
    @NotNull
    private final BinStatUtil.BinOptions binOptionsX;
    @NotNull
    private final BinStatUtil.BinOptions binOptionsY;
    public static final int DEF_BINS = 30;
    @Nullable
    private static final Double DEF_BINWIDTH;
    public static final boolean DEF_DROP = true;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public Bin2dStat(int binCountX, int binCountY, @Nullable Double binWidthX, @Nullable Double binWidthY, boolean drop) {
        super(DEF_MAPPING);
        this.drop = drop;
        this.binOptionsX = new BinStatUtil.BinOptions(binCountX, binWidthX);
        this.binOptionsY = new BinStatUtil.BinOptions(binCountY, binWidthY);
    }

    public /* synthetic */ Bin2dStat(int n, int n2, Double d, Double d2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 30;
        }
        if ((n3 & 2) != 0) {
            n2 = 30;
        }
        if ((n3 & 4) != 0) {
            d = DEF_BINWIDTH;
        }
        if ((n3 & 8) != 0) {
            d2 = DEF_BINWIDTH;
        }
        if ((n3 & 0x10) != 0) {
            bl = true;
        }
        this(n, n2, d, d2, bl);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        ClosedRange<Double> xRange = statCtx.overallXRange();
        ClosedRange<Double> yRange = statCtx.overallYRange();
        if (xRange == null || yRange == null) {
            return this.withEmptyStatValues();
        }
        ClosedRange xRangeInit = Bin2dStat.Companion.adjustRangeInitial(xRange);
        ClosedRange yRangeInit = Bin2dStat.Companion.adjustRangeInitial(yRange);
        BinStatUtil.CountAndWidth xCountAndWidthInit = BinStatUtil.INSTANCE.binCountAndWidth(SeriesUtil.INSTANCE.span(xRangeInit), this.binOptionsX);
        BinStatUtil.CountAndWidth yCountAndWidthInit = BinStatUtil.INSTANCE.binCountAndWidth(SeriesUtil.INSTANCE.span(yRangeInit), this.binOptionsY);
        ClosedRange xRangeFinal = Bin2dStat.Companion.adjustRangeFinal(xRange, xCountAndWidthInit.getWidth());
        ClosedRange yRangeFinal = Bin2dStat.Companion.adjustRangeFinal(yRange, yCountAndWidthInit.getWidth());
        BinStatUtil.CountAndWidth xCountAndWidthFinal = BinStatUtil.INSTANCE.binCountAndWidth(SeriesUtil.INSTANCE.span(xRangeFinal), this.binOptionsX);
        BinStatUtil.CountAndWidth yCountAndWidthFinal = BinStatUtil.INSTANCE.binCountAndWidth(SeriesUtil.INSTANCE.span(yRangeFinal), this.binOptionsY);
        int countTotal = xCountAndWidthFinal.getCount() * yCountAndWidthFinal.getCount();
        double densityNormalizingFactor = Bin2dStat.Companion.densityNormalizingFactor(SeriesUtil.INSTANCE.span(xRangeFinal), SeriesUtil.INSTANCE.span(yRangeFinal), countTotal);
        Bins2dData binsData = this.computeBins(data.getNumeric(TransformVar.INSTANCE.getX()), data.getNumeric(TransformVar.INSTANCE.getY()), ((Number)xRangeFinal.getLowerEnd()).doubleValue(), ((Number)yRangeFinal.getLowerEnd()).doubleValue(), xCountAndWidthFinal.getCount(), yCountAndWidthFinal.getCount(), xCountAndWidthFinal.getWidth(), yCountAndWidthFinal.getWidth(), BinStatUtil.INSTANCE.weightAtIndex(data), densityNormalizingFactor);
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), binsData.getX$plot_base_portable()).putNumeric(Stats.INSTANCE.getY(), binsData.getY$plot_base_portable()).putNumeric(Stats.INSTANCE.getCOUNT(), binsData.getCount$plot_base_portable()).putNumeric(Stats.INSTANCE.getDENSITY(), binsData.getDensity$plot_base_portable()).build();
    }

    private final Bins2dData computeBins(List<Double> xValues, List<Double> yValues, double xStart, double yStart, int binCountX, int binCountY, double binWidth, double binHeight, Function1<? super Integer, Double> weightAtIndex2, double densityNormalizingFactor) {
        int n;
        double totalCount = 0.0;
        HashMap countByBinIndexKey = new HashMap();
        int n2 = 0;
        int n3 = xValues.size() + -1;
        if (n2 <= n3) {
            do {
                Double y2;
                int dataIndex;
                Double x2;
                if (!SeriesUtil.INSTANCE.allFinite(x2 = xValues.get(dataIndex = n2++), y2 = yValues.get(dataIndex))) continue;
                double weight = ((Number)weightAtIndex2.invoke((Object)dataIndex)).doubleValue();
                totalCount += weight;
                Double d = x2;
                Intrinsics.checkNotNull((Object)d);
                double d2 = (d - xStart) / binWidth;
                n = 0;
                int binIndexX = (int)Math.floor(d2);
                Double d3 = y2;
                Intrinsics.checkNotNull((Object)d3);
                double d4 = (d3 - yStart) / binHeight;
                boolean bl = false;
                int binIndexY = (int)Math.floor(d4);
                Pair binIndexKey = new Pair((Object)binIndexX, (Object)binIndexY);
                if (!countByBinIndexKey.containsKey(binIndexKey)) {
                    Map map2 = countByBinIndexKey;
                    MutableDouble mutableDouble = new MutableDouble(0.0);
                    boolean bl2 = false;
                    map2.put(binIndexKey, mutableDouble);
                }
                Object v = countByBinIndexKey.get(binIndexKey);
                Intrinsics.checkNotNull(v);
                ((MutableDouble)v).getAndAdd(weight);
            } while (n2 <= n3);
        }
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> densities = new ArrayList<Double>();
        double x0 = xStart + binWidth / (double)2;
        double y0 = yStart + binHeight / (double)2;
        int n4 = 0;
        if (n4 < binCountX) {
            do {
                int xIndex = n4++;
                n = 0;
                if (n >= binCountY) continue;
                do {
                    int yIndex = n++;
                    Pair binIndexKey = new Pair((Object)xIndex, (Object)yIndex);
                    double count2 = 0.0;
                    if (countByBinIndexKey.containsKey(binIndexKey)) {
                        Object v = countByBinIndexKey.get(binIndexKey);
                        Intrinsics.checkNotNull(v);
                        count2 = ((MutableDouble)v).get();
                    }
                    if (this.drop && count2 == 0.0) continue;
                    xs.add(x0 + (double)xIndex * binWidth);
                    ys.add(y0 + (double)yIndex * binHeight);
                    counts.add(count2);
                    double density2 = count2 / totalCount * densityNormalizingFactor;
                    densities.add(density2);
                } while (n < binCountY);
            } while (n4 < binCountX);
        }
        return new Bins2dData((List<Double>)xs, (List<Double>)ys, (List<Double>)counts, (List<Double>)densities);
    }

    public Bin2dStat() {
        this(0, 0, null, null, false, 31, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getFILL(), (Object)Stats.INSTANCE.getCOUNT())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/stat/Bin2dStat$Companion;", "", "()V", "DEF_BINS", "", "DEF_BINWIDTH", "", "getDEF_BINWIDTH", "()Ljava/lang/Double;", "Ljava/lang/Double;", "DEF_DROP", "", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "adjustRangeFinal", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "r", "binWidth", "adjustRangeInitial", "densityNormalizingFactor", "xSpan", "ySpan", "count", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Double getDEF_BINWIDTH() {
            return DEF_BINWIDTH;
        }

        private final ClosedRange<Double> adjustRangeInitial(ClosedRange<Double> r) {
            return SeriesUtil.INSTANCE.ensureApplicableRange(r);
        }

        private final ClosedRange<Double> adjustRangeFinal(ClosedRange<Double> r, double binWidth) {
            ClosedRange<Double> closedRange;
            if (SeriesUtil.INSTANCE.isSubTiny(r)) {
                closedRange = SeriesUtil.INSTANCE.expand(r, 0.5, 0.5);
            } else {
                double exp = binWidth / 2.0;
                closedRange = SeriesUtil.INSTANCE.expand(r, exp, exp);
            }
            return closedRange;
        }

        private final double densityNormalizingFactor(double xSpan, double ySpan, int count2) {
            double area2 = xSpan * ySpan;
            double binArea = area2 / (double)count2;
            return 1.0 / binArea;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/stat/Bin2dStat$Bins2dData;", "", "x", "", "", "y", "count", "density", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCount$plot_base_portable", "()Ljava/util/List;", "getDensity$plot_base_portable", "getX$plot_base_portable", "getY$plot_base_portable", "plot-base-portable"})
    public static final class Bins2dData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> y;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;

        public Bins2dData(@NotNull List<Double> x2, @NotNull List<Double> y2, @NotNull List<Double> count2, @NotNull List<Double> density2) {
            Intrinsics.checkNotNullParameter(x2, (String)"x");
            Intrinsics.checkNotNullParameter(y2, (String)"y");
            Intrinsics.checkNotNullParameter(count2, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            this.x = x2;
            this.y = y2;
            this.count = count2;
            this.density = density2;
        }

        @NotNull
        public final List<Double> getX$plot_base_portable() {
            return this.x;
        }

        @NotNull
        public final List<Double> getY$plot_base_portable() {
            return this.y;
        }

        @NotNull
        public final List<Double> getCount$plot_base_portable() {
            return this.count;
        }

        @NotNull
        public final List<Double> getDensity$plot_base_portable() {
            return this.density;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R,\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0004\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/stat/Bin2dStat$Bins2dWeightedCounts;", "", "total", "", "countByBinXY", "", "Lkotlin/Pair;", "(DLjava/util/Map;)V", "getCountByBinXY$plot_base_portable", "()Ljava/util/Map;", "getTotal$plot_base_portable", "()D", "plot-base-portable"})
    public static final class Bins2dWeightedCounts {
        private final double total;
        @NotNull
        private final Map<Pair<Double, Double>, Double> countByBinXY;

        public Bins2dWeightedCounts(double total, @NotNull Map<Pair<Double, Double>, Double> countByBinXY) {
            Intrinsics.checkNotNullParameter(countByBinXY, (String)"countByBinXY");
            this.total = total;
            this.countByBinXY = countByBinXY;
        }

        public final double getTotal$plot_base_portable() {
            return this.total;
        }

        @NotNull
        public final Map<Pair<Double, Double>, Double> getCountByBinXY$plot_base_portable() {
            return this.countByBinXY;
        }
    }
}

