/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.transform.DateTimeBreaksGen;
import jetbrains.datalore.plot.base.scale.transform.Transforms;
import jetbrains.datalore.plot.builder.scale.DefaultMapperProviderUtil;
import jetbrains.datalore.plot.builder.scale.DefaultNaValue;
import jetbrains.datalore.plot.builder.scale.MapperProvider;
import jetbrains.datalore.plot.builder.scale.ScaleProvider;
import jetbrains.datalore.plot.builder.scale.ScaleProviderBuilder;
import jetbrains.datalore.plot.builder.scale.mapper.ShapeMapper;
import jetbrains.datalore.plot.builder.scale.provider.AlphaMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.ColorBrewerMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.ColorGradient2MapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.ColorGradientMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.ColorHueMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.GreyscaleLightnessMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.IdentityDiscreteMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.IdentityMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.SizeAreaMapperProvider;
import jetbrains.datalore.plot.builder.scale.provider.SizeMapperProvider;
import jetbrains.datalore.plot.config.GuideConfig;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.ScaleTransformConfig;
import jetbrains.datalore.plot.config.aes.AesOptionConversion;
import jetbrains.datalore.plot.config.aes.TypedContinuousIdentityMappers;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0016B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/config/ScaleConfig;", "T", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "options", "", "(Ljava/util/Map;)V", "aes", "Ljetbrains/datalore/plot/base/Aes;", "getAes$annotations", "()V", "getAes", "()Ljetbrains/datalore/plot/base/Aes;", "applyCommons", "Ljetbrains/datalore/plot/builder/scale/ScaleProviderBuilder;", "b", "createScaleProvider", "Ljetbrains/datalore/plot/builder/scale/ScaleProvider;", "createScaleProviderBuilder", "gerGuideOptions", "Ljetbrains/datalore/plot/config/GuideConfig;", "hasGuideOptions", "", "Companion", "plot-config-portable"})
public final class ScaleConfig<T>
extends OptionsAccessor {
    @NotNull
    private final Aes<T> aes;
    private static final String IDENTITY = "identity";
    private static final String COLOR_GRADIENT = "color_gradient";
    private static final String COLOR_GRADIENT2 = "color_gradient2";
    private static final String COLOR_HUE = "color_hue";
    private static final String COLOR_GREY = "color_grey";
    private static final String COLOR_BREWER = "color_brewer";
    private static final String SIZE_AREA = "size_area";
    public static final Companion Companion = new Companion(null);

    public static /* synthetic */ void getAes$annotations() {
    }

    @NotNull
    public final Aes<T> getAes() {
        return this.aes;
    }

    @NotNull
    public final ScaleProvider<T> createScaleProvider() {
        return this.createScaleProviderBuilder().build();
    }

    private final ScaleProviderBuilder<T> createScaleProviderBuilder() {
        String scaleMapperKind;
        T naValue;
        T t;
        MapperProvider mapperProvider = null;
        if (this.has("na_value")) {
            T t2 = this.getValue(this.aes, "na_value");
            t = t2;
            Intrinsics.checkNotNull(t2);
        } else {
            t = naValue = DefaultNaValue.INSTANCE.get(this.aes);
        }
        if (this.has("values")) {
            List<?> outputValues = this.getList("values");
            List<T> mapperOutputValues = AesOptionConversion.INSTANCE.applyToList(this.aes, outputValues);
            mapperProvider = DefaultMapperProviderUtil.INSTANCE.createWithDiscreteOutput(mapperOutputValues, naValue);
        }
        if (Intrinsics.areEqual(this.aes, Aes.Companion.getSHAPE())) {
            Object solid = this.get("solid");
            if (solid instanceof Boolean && Intrinsics.areEqual((Object)solid, (Object)false)) {
                mapperProvider = DefaultMapperProviderUtil.INSTANCE.createWithDiscreteOutput(ShapeMapper.INSTANCE.hollowShapes(), ShapeMapper.INSTANCE.getNA_VALUE());
            }
        } else if (Intrinsics.areEqual(this.aes, Aes.Companion.getALPHA()) && this.has("range")) {
            T t3 = naValue;
            if (t3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            mapperProvider = new AlphaMapperProvider(this.getRange$plot_config_portable("range"), (Double)t3);
        } else if (Intrinsics.areEqual(this.aes, Aes.Companion.getSIZE()) && this.has("range")) {
            T t4 = naValue;
            if (t4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            mapperProvider = new SizeMapperProvider(this.getRange$plot_config_portable("range"), (Double)t4);
        }
        boolean discreteDomain = OptionsAccessor.getBoolean$default(this, "discrete", false, 2, null);
        boolean reverse = OptionsAccessor.getBoolean$default(this, "reverse", false, 2, null);
        String string = this.getString("scale_mapper_kind");
        if (string == null) {
            string = !this.has("values") && discreteDomain && SetsKt.setOf((Object[])new Aes[]{Aes.Companion.getFILL(), Aes.Companion.getCOLOR()}).contains(this.aes) ? COLOR_BREWER : null;
        }
        String string2 = scaleMapperKind = string;
        if (string2 != null) {
            switch (string2) {
                case "identity": {
                    mapperProvider = Companion.createIdentityMapperProvider(this.aes, naValue);
                    break;
                }
                case "color_gradient": {
                    T t5 = naValue;
                    if (t5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.base.values.Color");
                    }
                    mapperProvider = new ColorGradientMapperProvider(this.getColor("low"), this.getColor("high"), (Color)t5);
                    break;
                }
                case "color_gradient2": {
                    T t6 = naValue;
                    if (t6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.base.values.Color");
                    }
                    mapperProvider = new ColorGradient2MapperProvider(this.getColor("low"), this.getColor("mid"), this.getColor("high"), this.getDouble("midpoint"), (Color)t6);
                    break;
                }
                case "color_hue": {
                    T t7 = naValue;
                    if (t7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.base.values.Color");
                    }
                    mapperProvider = new ColorHueMapperProvider(this.getDoubleList("h"), this.getDouble("c"), this.getDouble("l"), this.getDouble("h_start"), this.getDouble("direction"), (Color)t7);
                    break;
                }
                case "color_grey": {
                    T t8 = naValue;
                    if (t8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.base.values.Color");
                    }
                    mapperProvider = new GreyscaleLightnessMapperProvider(this.getDouble("start"), this.getDouble("end"), (Color)t8);
                    break;
                }
                case "color_brewer": {
                    T t9 = naValue;
                    if (t9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.base.values.Color");
                    }
                    mapperProvider = new ColorBrewerMapperProvider(this.getString("type"), this.get("palette"), this.getDouble("direction"), (Color)t9);
                    break;
                }
                case "size_area": {
                    T t10 = naValue;
                    if (t10 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    mapperProvider = new SizeAreaMapperProvider(this.getDouble("max_size"), (double)((Double)t10));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Aes '" + this.aes.getName() + "' - unexpected scale mapper kind: '" + scaleMapperKind + "'");
                }
            }
        }
        ScaleProviderBuilder<T> b = new ScaleProviderBuilder<T>(this.aes);
        if (mapperProvider != null) {
            b.mapperProvider(mapperProvider);
        }
        b.discreteDomain(discreteDomain);
        b.discreteDomainReverse(reverse);
        if (OptionsAccessor.getBoolean$default(this, "datetime", false, 2, null)) {
            b.transform(Transforms.INSTANCE.identityWithBreaksGen(new DateTimeBreaksGen()));
        } else if (!discreteDomain && this.has("trans")) {
            Object object = this.get("trans");
            Intrinsics.checkNotNull((Object)object);
            ScaleTransformConfig transformConfig = ScaleTransformConfig.Companion.create(object);
            b.transform(transformConfig.getTransform());
        }
        return this.applyCommons(b);
    }

    private final ScaleProviderBuilder<T> applyCommons(ScaleProviderBuilder<T> b) {
        if (this.has("name")) {
            String string = this.getString("name");
            Intrinsics.checkNotNull((Object)string);
            b.name(string);
        }
        if (this.has("breaks")) {
            b.breaks(this.getList("breaks"));
        }
        if (this.has("labels")) {
            b.labels(this.getStringList("labels"));
        }
        if (this.has("expand")) {
            List<?> list2 = this.getList("expand");
            Collection collection2 = list2;
            boolean bl = false;
            if (!collection2.isEmpty()) {
                Object obj = list2.get(0);
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                Number multiplicativeExpand = (Number)obj;
                b.multiplicativeExpand(multiplicativeExpand.doubleValue());
                if (list2.size() > 1) {
                    Object obj2 = list2.get(1);
                    if (obj2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    Number additiveExpand = (Number)obj2;
                    b.additiveExpand(additiveExpand.doubleValue());
                }
            }
        }
        if (this.has("limits")) {
            b.limits(this.getList("limits"));
        }
        return b;
    }

    public final boolean hasGuideOptions() {
        return this.has("guide");
    }

    @NotNull
    public final GuideConfig gerGuideOptions() {
        Object object = this.get("guide");
        Intrinsics.checkNotNull((Object)object);
        return GuideConfig.Companion.create(object);
    }

    public ScaleConfig(@NotNull Map<?, ?> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        super(options);
        Aes<?> aes = Companion.aesOrFail(options);
        if (aes == null) {
            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Aes<T>");
        }
        this.aes = aes;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eJ-\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0001\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\f2\u0006\u0010\u0013\u001a\u0002H\u0011\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/config/ScaleConfig$Companion;", "", "()V", "COLOR_BREWER", "", "COLOR_GRADIENT", "COLOR_GRADIENT2", "COLOR_GREY", "COLOR_HUE", "IDENTITY", "SIZE_AREA", "aesOrFail", "Ljetbrains/datalore/plot/base/Aes;", "options", "", "createIdentityMapperProvider", "Ljetbrains/datalore/plot/builder/scale/MapperProvider;", "T", "aes", "naValue", "(Ljetbrains/datalore/plot/base/Aes;Ljava/lang/Object;)Ljetbrains/datalore/plot/builder/scale/MapperProvider;", "plot-config-portable"})
    public static final class Companion {
        @NotNull
        public final Aes<?> aesOrFail(@NotNull Map<?, ?> options) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            OptionsAccessor accessor = new OptionsAccessor(options);
            Preconditions.INSTANCE.checkArgument(accessor.has("aesthetic"), "Required parameter 'aesthetic' is missing");
            String string = accessor.getString("aesthetic");
            Intrinsics.checkNotNull((Object)string);
            return Option.Mapping.INSTANCE.toAes(string);
        }

        @NotNull
        public final <T> MapperProvider<T> createIdentityMapperProvider(@NotNull Aes<T> aes, T naValue) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Function1<Object, T> cvt = AesOptionConversion.INSTANCE.getConverter(aes);
            IdentityDiscreteMapperProvider<T> discreteMapperProvider = new IdentityDiscreteMapperProvider<T>(cvt, naValue);
            if (TypedContinuousIdentityMappers.INSTANCE.contain(aes)) {
                Function1<Double, T> continuousMapper2 = TypedContinuousIdentityMappers.INSTANCE.get(aes);
                return new IdentityMapperProvider<T>(discreteMapperProvider, Mappers.INSTANCE.nullable(continuousMapper2, naValue));
            }
            return discreteMapperProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

