/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Map;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.builder.sampling.Samplings;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/config/SamplingProto;", "", "()V", "createSampling", "Ljetbrains/datalore/plot/builder/sampling/Sampling;", "name", "", "options", "", "plot-config-portable"})
public final class SamplingProto {
    public static final SamplingProto INSTANCE;

    @NotNull
    public final Sampling createSampling(@NotNull String name, @NotNull Map<?, ?> options) {
        Sampling sampling;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        OptionsAccessor opts = OptionsAccessor.Companion.over(options);
        switch (name) {
            case "random": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.random(n, opts.getLong("seed"));
                break;
            }
            case "pick": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.pick(n);
                break;
            }
            case "systematic": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.systematic(n);
                break;
            }
            case "group_random": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.randomGroup(n, opts.getLong("seed"));
                break;
            }
            case "group_systematic": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.systematicGroup(n);
                break;
            }
            case "random_stratified": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.randomStratified(n, opts.getLong("seed"), opts.getInteger("min_subsample"));
                break;
            }
            case "vertex_vw": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.vertexVw(n);
                break;
            }
            case "vertex_dp": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.vertexDp(n);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown sampling method: '" + name + '\'');
            }
        }
        return sampling;
    }

    private SamplingProto() {
    }

    static {
        SamplingProto samplingProto;
        INSTANCE = samplingProto = new SamplingProto();
    }
}

