/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.PosProvider;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PosConfig;
import jetbrains.datalore.plot.config.SamplingConfig;
import jetbrains.datalore.plot.config.aes.AesOptionConversion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/config/LayerConfigUtil;", "", "()V", "createBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "mapping", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "consumedAesSet", "", "clientSide", "", "initConstants", "layerConfig", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "initPositionAdjustments", "Ljetbrains/datalore/plot/builder/assemble/PosProvider;", "opts", "defaultPos", "initSampling", "Ljetbrains/datalore/plot/builder/sampling/Sampling;", "defaultSampling", "plot-config-portable"})
public final class LayerConfigUtil {
    public static final LayerConfigUtil INSTANCE;

    @NotNull
    public final PosProvider initPositionAdjustments(@NotNull OptionsAccessor opts, @NotNull PosProvider defaultPos) {
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)defaultPos, (String)"defaultPos");
        if (opts.has("position")) {
            Object object = opts.get("position");
            Intrinsics.checkNotNull((Object)object);
            PosConfig posConfig = PosConfig.Companion.create(object);
            return posConfig.getPos();
        }
        return defaultPos;
    }

    @NotNull
    public final Map<Aes<?>, Object> initConstants(@NotNull OptionsAccessor layerConfig) {
        Intrinsics.checkNotNullParameter((Object)layerConfig, (String)"layerConfig");
        HashMap result = new HashMap();
        for (String option : Option.Mapping.INSTANCE.getREAL_AES_OPTION_NAMES()) {
            Object optionValue = layerConfig.get(option);
            if (optionValue == null) continue;
            Aes<?> aes = Option.Mapping.INSTANCE.toAes(option);
            Object variable = AesOptionConversion.INSTANCE.apply(aes, optionValue);
            Map map2 = result;
            Object obj = variable;
            Intrinsics.checkNotNull(obj);
            map2.put(aes, obj);
        }
        return result;
    }

    @NotNull
    public final List<VarBinding> createBindings(@NotNull DataFrame data, @Nullable Map<Aes<?>, DataFrame.Variable> mapping, @NotNull Set<? extends Aes<?>> consumedAesSet, boolean clientSide) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(consumedAesSet, (String)"consumedAesSet");
        ArrayList<VarBinding> result = new ArrayList<VarBinding>();
        if (mapping != null) {
            HashSet aesSet = new HashSet(consumedAesSet);
            aesSet.retainAll((Collection)mapping.keySet());
            for (Aes aes : aesSet) {
                VarBinding varBinding;
                DataFrame.Variable variable;
                Intrinsics.checkNotNull((Object)mapping.get(aes));
                if (data.has(variable)) {
                    Aes aes2 = aes;
                    Intrinsics.checkNotNullExpressionValue((Object)aes2, (String)"aes");
                    varBinding = new VarBinding(variable, aes2);
                } else if (variable.isStat() && !clientSide) {
                    Aes aes3 = aes;
                    Intrinsics.checkNotNullExpressionValue((Object)aes3, (String)"aes");
                    varBinding = new VarBinding(variable, aes3);
                } else {
                    throw (Throwable)new IllegalArgumentException("Undefined variable: '" + variable.getName() + "'. Variables in data frame: " + data.variables());
                }
                VarBinding binding = varBinding;
                result.add(binding);
            }
        }
        return result;
    }

    @NotNull
    public final List<Sampling> initSampling(@NotNull OptionsAccessor opts, @NotNull Sampling defaultSampling) {
        List<Sampling> list2;
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        Intrinsics.checkNotNullParameter((Object)defaultSampling, (String)"defaultSampling");
        if (opts.has("sampling")) {
            Object object = opts.get("sampling");
            Intrinsics.checkNotNull((Object)object);
            list2 = SamplingConfig.INSTANCE.create(object);
        } else {
            list2 = CollectionsKt.listOf((Object)defaultSampling);
        }
        return list2;
    }

    private LayerConfigUtil() {
    }

    static {
        LayerConfigUtil layerConfigUtil;
        INSTANCE = layerConfigUtil = new LayerConfigUtil();
    }
}

