/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Map;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.plot.base.geom.util.ArrowSpec;
import jetbrains.datalore.plot.config.ConfigUtil;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0017\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/config/ArrowSpecConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "options", "", "(Ljava/util/Map;)V", "createArrowSpec", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;", "Companion", "plot-config-portable"})
public final class ArrowSpecConfig
extends OptionsAccessor {
    private static final double DEF_ANGLE = 30.0;
    private static final double DEF_LENGTH = 10.0;
    private static final ArrowSpec.End DEF_END;
    private static final ArrowSpec.Type DEF_TYPE;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ArrowSpec createArrowSpec() {
        String s2;
        double angle = 30.0;
        double length = 10.0;
        ArrowSpec.End end = DEF_END;
        ArrowSpec.Type type = DEF_TYPE;
        if (this.has("angle")) {
            Double d = this.getDouble("angle");
            Intrinsics.checkNotNull((Object)d);
            angle = d;
        }
        if (this.has("length")) {
            Double d = this.getDouble("length");
            Intrinsics.checkNotNull((Object)d);
            length = d;
        }
        if (this.has("ends")) {
            String string = s2 = this.getString("ends");
            if (string == null) throw (Throwable)new IllegalArgumentException("Expected: first|last|both");
            switch (string) {
                case "last": {
                    end = ArrowSpec.End.LAST;
                    break;
                }
                case "first": {
                    end = ArrowSpec.End.FIRST;
                    break;
                }
                case "both": {
                    end = ArrowSpec.End.BOTH;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Expected: first|last|both");
                }
            }
        }
        if (!this.has("type")) return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
        String string = s2 = this.getString("type");
        if (string == null) throw (Throwable)new IllegalArgumentException("Expected: open|closed");
        String string2 = string;
        switch (string2.hashCode()) {
            case -1357520532: {
                if (!string2.equals("closed")) throw (Throwable)new IllegalArgumentException("Expected: open|closed");
                break;
            }
            case 3417674: {
                if (!string2.equals("open")) throw (Throwable)new IllegalArgumentException("Expected: open|closed");
                type = ArrowSpec.Type.OPEN;
                return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
            }
        }
        type = ArrowSpec.Type.CLOSED;
        return new ArrowSpec(MathKt.toRadians(angle), length, end, type);
        throw (Throwable)new IllegalArgumentException("Expected: open|closed");
    }

    private ArrowSpecConfig(Map<?, ?> options) {
        super(options, MapsKt.emptyMap());
    }

    static {
        Companion = new Companion(null);
        DEF_END = ArrowSpec.End.LAST;
        DEF_TYPE = ArrowSpec.Type.OPEN;
    }

    public /* synthetic */ ArrowSpecConfig(Map options, DefaultConstructorMarker $constructor_marker) {
        this(options);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/config/ArrowSpecConfig$Companion;", "", "()V", "DEF_ANGLE", "", "DEF_END", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$End;", "DEF_LENGTH", "DEF_TYPE", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;", "create", "Ljetbrains/datalore/plot/config/ArrowSpecConfig;", "options", "plot-config-portable"})
    public static final class Companion {
        @NotNull
        public final ArrowSpecConfig create(@NotNull Object options) {
            String name;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (options instanceof Map && Intrinsics.areEqual((Object)"arrow", (Object)(name = ConfigUtil.INSTANCE.featureName((Map)options)))) {
                return new ArrowSpecConfig((Map)options, null);
            }
            throw (Throwable)new IllegalArgumentException("Expected: 'arrow = arrow(...)'");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

