/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.common.color.ColorPalette;
import jetbrains.datalore.plot.common.color.ColorScheme;
import jetbrains.datalore.plot.common.color.ColorUtil;
import jetbrains.datalore.plot.common.color.PaletteUtil$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\fJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/common/color/PaletteUtil;", "", "()V", "EXTENSIBLE_COLOR_SCHEMES", "", "Ljetbrains/datalore/plot/common/color/ColorScheme;", "NULL_COLOR", "Ljetbrains/datalore/base/values/Color;", "getNULL_COLOR", "()Ljetbrains/datalore/base/values/Color;", "PAL_TYPE_BY_PAL_NAME", "", "", "Ljetbrains/datalore/plot/common/color/ColorPalette$Type;", "colorSchemeByIndex", "paletteType", "index", "", "fromColorsHex", "", "hexColors", "", "([Ljava/lang/String;)Ljava/util/List;", "isExtensibleScheme", "", "colorScheme", "paletteTypeByPaletteName", "paletteName", "schemeColors", "colorCount", "plot-common-portable"})
public final class PaletteUtil {
    @NotNull
    private static final Color NULL_COLOR;
    private static final Set<ColorScheme> EXTENSIBLE_COLOR_SCHEMES;
    private static final Map<String, ColorPalette.Type> PAL_TYPE_BY_PAL_NAME;
    public static final PaletteUtil INSTANCE;

    @NotNull
    public final Color getNULL_COLOR() {
        return NULL_COLOR;
    }

    private final boolean isExtensibleScheme(ColorScheme colorScheme) {
        return EXTENSIBLE_COLOR_SCHEMES.contains(colorScheme);
    }

    @NotNull
    public final List<Color> schemeColors(@NotNull ColorScheme colorScheme, int colorCount) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        String[] colorsHex = colorScheme.getColors(colorCount);
        List<Color> colors = this.fromColorsHex(colorsHex);
        if (colorsHex.length < colorCount && this.isExtensibleScheme(colorScheme)) {
            List<Color> addColors = ColorUtil.INSTANCE.genColors(colorCount - colorsHex.length, colors);
            return Iterables.INSTANCE.toList(Iterables.INSTANCE.concat((Iterable)colors, (Iterable)addColors));
        }
        return colors;
    }

    private final List<Color> fromColorsHex(String[] hexColors) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String hexColor : hexColors) {
            try {
                colors.add(Color.Companion.parseHex(hexColor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return colors;
    }

    @Nullable
    public final ColorPalette.Type paletteTypeByPaletteName(@NotNull String paletteName) {
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        return PAL_TYPE_BY_PAL_NAME.get(paletteName);
    }

    @NotNull
    public final ColorScheme colorSchemeByIndex(@NotNull ColorPalette.Type paletteType, int index) {
        ColorScheme[] colorSchemeArray;
        Intrinsics.checkNotNullParameter((Object)((Object)paletteType), (String)"paletteType");
        switch (PaletteUtil$WhenMappings.$EnumSwitchMapping$0[paletteType.ordinal()]) {
            case 1: {
                ColorPalette.Sequential[] sequentialArray = ColorPalette.Sequential.values();
                if (sequentialArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<jetbrains.datalore.plot.common.color.ColorScheme>");
                }
                colorSchemeArray = sequentialArray;
                break;
            }
            case 2: {
                ColorPalette.Diverging[] divergingArray = ColorPalette.Diverging.values();
                if (divergingArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<jetbrains.datalore.plot.common.color.ColorScheme>");
                }
                colorSchemeArray = divergingArray;
                break;
            }
            case 3: {
                ColorPalette.Qualitative[] qualitativeArray = ColorPalette.Qualitative.values();
                if (qualitativeArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<jetbrains.datalore.plot.common.color.ColorScheme>");
                }
                colorSchemeArray = qualitativeArray;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ColorScheme[] values2 = colorSchemeArray;
        return values2[index % values2.length];
    }

    private PaletteUtil() {
    }

    static {
        int n;
        String string;
        Object it;
        Collection collection2;
        Object item$iv$iv2;
        Object $this$mapTo$iv$iv;
        PaletteUtil paletteUtil;
        INSTANCE = paletteUtil = new PaletteUtil();
        NULL_COLOR = Color.Companion.getLIGHT_GRAY();
        EXTENSIBLE_COLOR_SCHEMES = SetsKt.setOf((Object[])new ColorPalette.Qualitative[]{ColorPalette.Qualitative.Accent, ColorPalette.Qualitative.Dark2, ColorPalette.Qualitative.Pastel1, ColorPalette.Qualitative.Pastel2, ColorPalette.Qualitative.Set1, ColorPalette.Qualitative.Set2, ColorPalette.Qualitative.Set3});
        HashMap map2 = new HashMap();
        Enum[] $this$map$iv = ColorPalette.Sequential.values();
        boolean $i$f$map = false;
        Enum[] enumArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void var11_17 = item$iv$iv2;
            collection2 = destination$iv$iv;
            boolean bl = false;
            string = ((Enum)it).name();
            collection2.add(string);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            ((Map)map2).put(it2, ColorPalette.Type.SEQUENTIAL);
        }
        $this$map$iv = ColorPalette.Diverging.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        Enum[] bl = $this$mapTo$iv$iv;
        int n2 = bl.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = bl[n];
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            string = ((Enum)it).name();
            collection2.add(string);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            boolean bl3 = false;
            ((Map)map2).put(it3, ColorPalette.Type.DIVERGING);
        }
        $this$map$iv = ColorPalette.Qualitative.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        Object bl3 = $this$mapTo$iv$iv;
        n2 = ((Object)bl3).length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = bl3[n];
            collection2 = destination$iv$iv;
            boolean bl4 = false;
            string = ((Enum)it).name();
            collection2.add(string);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it4 = (String)element$iv;
            boolean bl5 = false;
            ((Map)map2).put(it4, ColorPalette.Type.QUALITATIVE);
        }
        PAL_TYPE_BY_PAL_NAME = map2;
    }
}

