/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.base64;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import jetbrains.datalore.plot.common.base64.JavaBase64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00072\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/common/base64/BinaryUtil;", "", "()V", "decodeList", "", "", "s", "", "encodeList", "l", "fromBytes", "data", "", "pos", "", "toBytes", "d", "plot-common"})
public final class BinaryUtil {
    public static final BinaryUtil INSTANCE;

    @NotNull
    public final String encodeList(@NotNull List<Double> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        byte[] bytes = this.toBytes(l);
        String string = Base64.getEncoder().encodeToString(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.getEncoder().encodeToString(bytes)");
        return string;
    }

    @NotNull
    public final List<Double> decodeList(@NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        byte[] bytes = JavaBase64.INSTANCE.decode(s2);
        return this.fromBytes(bytes);
    }

    private final byte[] toBytes(List<Double> l) {
        byte[] data = new byte[l.size() * 8];
        int pos = 0;
        for (Double d : l) {
            block4: {
                Object object;
                block3: {
                    object = d;
                    if (object == null) break block3;
                    Double d2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    double it = ((Number)d2).doubleValue();
                    boolean bl3 = false;
                    byte[] byArray = INSTANCE.toBytes(it, data, pos);
                    object = byArray;
                    if (byArray != null) break block4;
                }
                object = this.toBytes(Double.NaN, data, pos);
            }
            pos += 8;
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> fromBytes(byte[] data) {
        int length = data.length / 8;
        ArrayList<Double> l = new ArrayList<Double>(length);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            double v = this.fromBytes(data, (int)(i * 8));
            l.add(v);
            ++i;
        }
        return l;
    }

    private final byte[] toBytes(double d, byte[] data, int pos) {
        long v = Double.doubleToLongBits(d);
        data[pos + 7] = (byte)v;
        data[pos + 6] = (byte)(v >>> 8);
        data[pos + 5] = (byte)(v >>> 16);
        data[pos + 4] = (byte)(v >>> 24);
        data[pos + 3] = (byte)(v >>> 32);
        data[pos + 2] = (byte)(v >>> 40);
        data[pos + 1] = (byte)(v >>> 48);
        data[pos] = (byte)(v >>> 56);
        return data;
    }

    private final double fromBytes(byte[] data, int pos) {
        long v = data[pos];
        v = (v << 8) + (long)(data[pos + 1] & 0xFF);
        v = (v << 8) + (long)(data[pos + 2] & 0xFF);
        v = (v << 8) + (long)(data[pos + 3] & 0xFF);
        v = (v << 8) + (long)(data[pos + 4] & 0xFF);
        v = (v << 8) + (long)(data[pos + 5] & 0xFF);
        v = (v << 8) + (long)(data[pos + 6] & 0xFF);
        v = (v << 8) + (long)(data[pos + 7] & 0xFF);
        return Double.longBitsToDouble(v);
    }

    private BinaryUtil() {
    }

    static {
        BinaryUtil binaryUtil;
        INSTANCE = binaryUtil = new BinaryUtil();
    }
}

