/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander;", "", "verticalSpace", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "horizontalSpace", "(Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;)V", "findValidCandidate", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "candidates", "", "restrictions", "fixOverlapping", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltips", "getCandidates", "positionedTooltip", "intersectsAny", "", "rect", "Companion", "TooltipRotationHelper", "plot-builder"})
public final class VerticalTooltipRotatingExpander {
    private final MathUtil.DoubleRange verticalSpace;
    private final MathUtil.DoubleRange horizontalSpace;
    private static final MathUtil.DoubleRange STEM_TO_LEFT_SIDE_ANGLE_RANGE;
    private static final MathUtil.DoubleRange STEM_TO_BOTTOM_SIDE_ANGLE_RANGE;
    private static final MathUtil.DoubleRange STEM_TO_RIGHT_SIDE_ANGLE_RANGE;
    private static final MathUtil.DoubleRange STEM_TO_TOP_SIDE_ANGLE_RANGE;
    private static final int SECTOR_COUNT = 36;
    private static final double SECTOR_ANGLE = 0.17453292519943295;
    private static final DoubleVector POINT_RESTRICTION_SIZE;
    public static final Companion Companion;

    @NotNull
    public final List<LayoutManager.PositionedTooltip> fixOverlapping(@NotNull List<LayoutManager.PositionedTooltip> tooltips, @NotNull List<DoubleRectangle> restrictions) {
        Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        ArrayList<Pair<Integer, DoubleVector>> expandedPositions = new ArrayList<Pair<Integer, DoubleVector>>();
        int n = tooltips.size();
        for (int i = 0; i < n; ++i) {
            LayoutManager.PositionedTooltip tooltip = tooltips.get(i);
            if (this.intersectsAny(tooltip.rect$plot_builder(), restrictions)) {
                ArrayList<DoubleRectangle> arrayList = new ArrayList<DoubleRectangle>((Collection)restrictions);
                arrayList.add(new DoubleRectangle(tooltip.getStemCoord(), POINT_RESTRICTION_SIZE));
                DoubleRectangle newPlacement = this.findValidCandidate(this.getCandidates(tooltip), (List<DoubleRectangle>)arrayList);
                if (newPlacement == null) {
                    expandedPositions.add(new Pair<Integer, DoubleVector>(i, tooltip.getTooltipCoord()));
                    continue;
                }
                expandedPositions.add(new Pair<Integer, DoubleVector>(i, newPlacement.getOrigin()));
                continue;
            }
            expandedPositions.add(new Pair<Integer, DoubleVector>(i, tooltip.getTooltipCoord()));
        }
        ArrayList<LayoutManager.PositionedTooltip> separatedTooltips = new ArrayList<LayoutManager.PositionedTooltip>();
        for (Pair pair2 : expandedPositions) {
            LayoutManager.PositionedTooltip positionedTooltip = tooltips.get(((Number)pair2.getFirst()).intValue());
            separatedTooltips.add(positionedTooltip.moveTo$plot_builder((DoubleVector)pair2.getSecond()));
        }
        return separatedTooltips;
    }

    private final List<DoubleRectangle> getCandidates(LayoutManager.PositionedTooltip positionedTooltip) {
        TooltipRotationHelper tooltipRotationHelper = new TooltipRotationHelper(positionedTooltip);
        ArrayList<DoubleRectangle> candidates = new ArrayList<DoubleRectangle>();
        candidates.add(tooltipRotationHelper.rotate(1.5707963267948966));
        candidates.add(tooltipRotationHelper.rotate(4.71238898038469));
        candidates.add(tooltipRotationHelper.rotate(0.0));
        candidates.add(tooltipRotationHelper.rotate(Math.PI));
        double alpha = 1.5707963267948966;
        int i = 0;
        while (i < 36) {
            if (alpha > Math.PI) {
                alpha -= Math.PI;
            }
            candidates.add(tooltipRotationHelper.rotate(alpha));
            ++i;
            alpha += 0.17453292519943295;
        }
        return candidates;
    }

    private final boolean intersectsAny(DoubleRectangle rect2, List<DoubleRectangle> restrictions) {
        for (DoubleRectangle restriction : restrictions) {
            if (!rect2.intersects(restriction)) continue;
            return true;
        }
        return false;
    }

    private final DoubleRectangle findValidCandidate(List<DoubleRectangle> candidates, List<DoubleRectangle> restrictions) {
        for (DoubleRectangle candidate : candidates) {
            if (this.intersectsAny(candidate, restrictions) || !MathUtil.DoubleRange.Companion.withStartAndLength(candidate.getOrigin().getY(), candidate.getDimension().getY()).inside(this.verticalSpace) || !MathUtil.DoubleRange.Companion.withStartAndLength(candidate.getOrigin().getX(), candidate.getDimension().getX()).inside(this.horizontalSpace)) continue;
            return candidate;
        }
        return null;
    }

    public VerticalTooltipRotatingExpander(@NotNull MathUtil.DoubleRange verticalSpace, @NotNull MathUtil.DoubleRange horizontalSpace) {
        Intrinsics.checkNotNullParameter((Object)verticalSpace, (String)"verticalSpace");
        Intrinsics.checkNotNullParameter((Object)horizontalSpace, (String)"horizontalSpace");
        this.verticalSpace = verticalSpace;
        this.horizontalSpace = horizontalSpace;
    }

    static {
        Companion = new Companion(null);
        STEM_TO_LEFT_SIDE_ANGLE_RANGE = MathUtil.DoubleRange.Companion.withStartAndEnd(-0.7853981633974483, 0.7853981633974483);
        STEM_TO_BOTTOM_SIDE_ANGLE_RANGE = MathUtil.DoubleRange.Companion.withStartAndEnd(0.7853981633974483, 2.356194490192345);
        STEM_TO_RIGHT_SIDE_ANGLE_RANGE = MathUtil.DoubleRange.Companion.withStartAndEnd(2.356194490192345, 3.9269908169872414);
        STEM_TO_TOP_SIDE_ANGLE_RANGE = MathUtil.DoubleRange.Companion.withStartAndEnd(3.9269908169872414, 5.497787143782138);
        POINT_RESTRICTION_SIZE = new DoubleVector(1.0, 1.0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander$TooltipRotationHelper;", "", "positionedTooltip", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "(Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;)V", "myAttachToTooltipsBottomOffset", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myAttachToTooltipsLeftOffset", "myAttachToTooltipsRightOffset", "myAttachToTooltipsTopOffset", "myTargetCoord", "myTooltipSize", "rotate", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "alpha", "", "plot-builder"})
    public static final class TooltipRotationHelper {
        private final DoubleVector myAttachToTooltipsTopOffset;
        private final DoubleVector myAttachToTooltipsBottomOffset;
        private final DoubleVector myAttachToTooltipsLeftOffset;
        private final DoubleVector myAttachToTooltipsRightOffset;
        private final DoubleVector myTooltipSize;
        private final DoubleVector myTargetCoord;

        @NotNull
        public final DoubleRectangle rotate(double alpha) {
            DoubleVector doubleVector;
            double r = TipLayoutHint.StemLength.NORMAL.getValue();
            boolean bl = false;
            bl = false;
            DoubleVector newAttachmentCoord = new DoubleVector(r * Math.cos(alpha), r * Math.sin(alpha)).add(this.myTargetCoord);
            if (STEM_TO_BOTTOM_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsBottomOffset);
            } else if (STEM_TO_TOP_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsTopOffset);
            } else if (STEM_TO_LEFT_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsLeftOffset);
            } else if (STEM_TO_RIGHT_SIDE_ANGLE_RANGE.contains(alpha)) {
                doubleVector = newAttachmentCoord.add(this.myAttachToTooltipsRightOffset);
            } else {
                throw (Throwable)new IllegalStateException();
            }
            DoubleVector newTooltipCoord = doubleVector;
            return new DoubleRectangle(newTooltipCoord, this.myTooltipSize);
        }

        public TooltipRotationHelper(@NotNull LayoutManager.PositionedTooltip positionedTooltip) {
            Intrinsics.checkNotNullParameter((Object)positionedTooltip, (String)"positionedTooltip");
            this.myTooltipSize = positionedTooltip.getTooltipSize$plot_builder();
            this.myTargetCoord = positionedTooltip.getStemCoord();
            double middleX = this.myTooltipSize.getX() / (double)2;
            double middleY = this.myTooltipSize.getY() / (double)2;
            this.myAttachToTooltipsTopOffset = new DoubleVector(-middleX, 0.0);
            this.myAttachToTooltipsBottomOffset = new DoubleVector(-middleX, -this.myTooltipSize.getY());
            this.myAttachToTooltipsLeftOffset = new DoubleVector(0.0, middleY);
            this.myAttachToTooltipsRightOffset = new DoubleVector(-this.myTooltipSize.getX(), middleY);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/layout/VerticalTooltipRotatingExpander$Companion;", "", "()V", "POINT_RESTRICTION_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "SECTOR_ANGLE", "", "SECTOR_COUNT", "", "STEM_TO_BOTTOM_SIDE_ANGLE_RANGE", "Ljetbrains/datalore/plot/builder/interact/MathUtil$DoubleRange;", "STEM_TO_LEFT_SIDE_ANGLE_RANGE", "STEM_TO_RIGHT_SIDE_ANGLE_RANGE", "STEM_TO_TOP_SIDE_ANGLE_RANGE", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

