/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.breaks.QuantitativeTickFormatterFactory;
import jetbrains.datalore.plot.builder.scale.GuideBreak;
import jetbrains.datalore.plot.builder.scale.GuideMapper;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMapperAdapter;
import jetbrains.datalore.plot.builder.scale.mapper.GuideMapperWithGuideBreaks;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u0002H\u000b0\rJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0004\"\u0004\b\u0000\u0010\u000b2\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\rJ7\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0015J=\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0004\"\u0004\b\u0000\u0010\u00172\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u0014\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010\u001aJ.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0014\u001a\u00020\u0005J=\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0004\"\u0004\b\u0000\u0010\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u0014\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010$J9\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0004\"\u0004\b\u0000\u0010\u00172\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u0014\u001a\u0002H\u0017\u00a2\u0006\u0002\u0010%R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/builder/scale/mapper/GuideMappers;", "", "()V", "IDENTITY", "Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "", "getIDENTITY", "()Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "UNDEFINED", "getUNDEFINED", "adapt", "T", "mapperFun", "Lkotlin/Function1;", "adaptContinuous", "mapper", "continuousToContinuous", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "range", "naValue", "(Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/lang/Double;)Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "continuousToDiscrete", "TargetT", "outputValues", "", "(Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "discreteToContinuous", "domainValues", "", "outputRange", "discreteToDiscrete", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "(Ljetbrains/datalore/plot/base/DataFrame;Ljetbrains/datalore/plot/base/DataFrame$Variable;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "(Ljava/util/Collection;Ljava/util/List;Ljava/lang/Object;)Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "plot-builder-portable"})
public final class GuideMappers {
    @NotNull
    private static final GuideMapper<Double> IDENTITY;
    @NotNull
    private static final GuideMapper<Double> UNDEFINED;
    public static final GuideMappers INSTANCE;

    @NotNull
    public final GuideMapper<Double> getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final GuideMapper<Double> getUNDEFINED() {
        return UNDEFINED;
    }

    @NotNull
    public final <TargetT> GuideMapper<TargetT> discreteToDiscrete(@NotNull DataFrame data, @NotNull DataFrame.Variable variable, @NotNull List<? extends TargetT> outputValues, TargetT naValue) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        Collection<Object> domainValues = DataFrameUtil.INSTANCE.distinctValues(data, variable);
        return this.discreteToDiscrete(domainValues, outputValues, naValue);
    }

    @NotNull
    public final <TargetT> GuideMapper<TargetT> discreteToDiscrete(@NotNull Collection<?> domainValues, @NotNull List<? extends TargetT> outputValues, TargetT naValue) {
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        Function1<Double, ? extends TargetT> mapper2 = Mappers.INSTANCE.discrete(outputValues, naValue);
        ArrayList breaks = new ArrayList();
        for (Object domainValue : domainValues) {
            Object obj = domainValue;
            if (obj == null || (obj = obj.toString()) == null) {
                obj = "n/a";
            }
            breaks.add(new GuideBreak(domainValue, (String)obj));
        }
        return new GuideMapperWithGuideBreaks<TargetT>(mapper2, breaks);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <TargetT> GuideMapper<TargetT> continuousToDiscrete(@Nullable ClosedRange<Double> domain, @NotNull List<? extends TargetT> outputValues, TargetT naValue) {
        Intrinsics.checkNotNullParameter(outputValues, (String)"outputValues");
        Function1<Double, TargetT> f = Mappers.INSTANCE.quantized(domain, (Collection)outputValues, naValue);
        int breakCount = outputValues.size();
        ArrayList<Double> breakValues = new ArrayList<Double>();
        ArrayList<Object> breakLabels = new ArrayList<Object>();
        if (domain != null && breakCount != 0) {
            double span = SeriesUtil.INSTANCE.span(domain);
            double step = span / (double)breakCount;
            Function1<Object, String> formatter = QuantitativeTickFormatterFactory.Companion.forLinearScale$default(QuantitativeTickFormatterFactory.Companion, false, 1, null).getFormatter(domain, step);
            int n = 0;
            int n2 = breakCount;
            while (n < n2) {
                void i;
                double val = ((Number)domain.getLowerEnd()).doubleValue() + step / (double)2 + (double)i * step;
                breakValues.add(val);
                breakLabels.add(formatter.invoke((Object)val));
                ++i;
            }
        }
        ArrayList<GuideBreak<Double>> breaks = new ArrayList<GuideBreak<Double>>();
        Iterator iterator2 = breakLabels.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"breakLabels.iterator()");
        Iterator breakLabel = iterator2;
        for (Double breakValue : breakValues) {
            Object e = breakLabel.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"breakLabel.next()");
            breaks.add(new GuideBreak<Double>(breakValue, (String)e));
        }
        return new GuideMapperWithGuideBreaks<TargetT>(f, (List)breaks);
    }

    @NotNull
    public final GuideMapper<Double> discreteToContinuous(@NotNull Collection<?> domainValues, @NotNull ClosedRange<Double> outputRange, double naValue) {
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(outputRange, (String)"outputRange");
        Function1<Double, Double> mapper2 = Mappers.INSTANCE.discreteToContinuous(domainValues, outputRange, naValue);
        ArrayList breaks = new ArrayList();
        Iterator<?> iterator2 = domainValues.iterator();
        while (iterator2.hasNext()) {
            Object domainValue;
            Object obj = domainValue = iterator2.next();
            Intrinsics.checkNotNull(obj);
            breaks.add(new GuideBreak(obj, domainValue.toString()));
        }
        return new GuideMapperWithGuideBreaks<Double>(mapper2, breaks);
    }

    @NotNull
    public final GuideMapper<Double> continuousToContinuous(@NotNull ClosedRange<Double> domain, @NotNull ClosedRange<Double> range2, @Nullable Double naValue) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter(range2, (String)"range");
        Double d = naValue;
        Intrinsics.checkNotNull((Object)d);
        return this.adaptContinuous(Mappers.INSTANCE.linear(domain, range2, d));
    }

    @NotNull
    public final <T> GuideMapper<T> adapt(@NotNull Function1<? super Double, ? extends T> mapperFun2) {
        Intrinsics.checkNotNullParameter(mapperFun2, (String)"mapperFun");
        return new GuideMapperAdapter(mapperFun2, false, 2, null);
    }

    @NotNull
    public final <T> GuideMapper<T> adaptContinuous(@NotNull Function1<? super Double, ? extends T> mapper2) {
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        return new GuideMapperAdapter<T>(mapper2, true);
    }

    private GuideMappers() {
    }

    static {
        GuideMappers guideMappers;
        INSTANCE = guideMappers = new GuideMappers();
        IDENTITY = new GuideMapperAdapter(Mappers.INSTANCE.getIDENTITY(), false, 2, null);
        UNDEFINED = new GuideMapperAdapter(Mappers.INSTANCE.undefined(), false, 2, null);
    }
}

