/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.GeometryUtil;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalSimpleLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "axisMapper", "Lkotlin/Function1;", "maxLabelsBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBounds", "labelNormalSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "Companion", "plot-builder-portable"})
public final class HorizontalSimpleLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper, @Nullable DoubleRectangle maxLabelsBounds) {
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        if (this.getBreaks().isEmpty()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        if (!this.getTheme().showTickLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        DoubleRectangle bounds = null;
        boolean overlap = false;
        List<Double> ticks = this.mapToAxis$plot_builder_portable(this.getBreaks().getTransformedValues(), axisMapper);
        List<DoubleRectangle> boundsList = this.labelBoundsList(ticks, this.getBreaks().getLabels(), AbstractFixedBreaksLabelsLayout.Companion.getHORIZONTAL_TICK_LOCATION());
        for (DoubleRectangle labelBounds : boundsList) {
            overlap = overlap || bounds != null && bounds.xRange().isConnected(SeriesUtil.INSTANCE.expand(labelBounds.xRange(), AxisLabelsLayout.Companion.getMIN_TICK_LABEL_DISTANCE() / (double)2, AxisLabelsLayout.Companion.getMIN_TICK_LABEL_DISTANCE() / 2.0));
            bounds = GeometryUtil.INSTANCE.union(labelBounds, bounds);
        }
        AxisLabelsLayoutInfo.Builder builder = new AxisLabelsLayoutInfo.Builder().breaks(this.getBreaks());
        DoubleRectangle doubleRectangle = bounds;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return builder.bounds(this.applyLabelsOffset$plot_builder_portable(doubleRectangle)).smallFont(false).overlap(overlap).labelAdditionalOffsets(null).labelHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE).labelVerticalAnchor(TextLabel.VerticalAnchor.TOP).build();
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        return BreakLabelsLayoutUtil.INSTANCE.horizontalCenteredLabelBounds(labelNormalSize);
    }

    public HorizontalSimpleLabelsLayout(@NotNull Orientation orientation, @NotNull ClosedRange<Double> axisDomain, @NotNull PlotLabelSpec labelSpec, @NotNull GuideBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, labelSpec, breaks, theme);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalSimpleLabelsLayout$Companion;", "", "()V", "estimateBreakCount", "", "labelLength", "axisLength", "", "labels", "", "", "estimateBreakCountInitial", "plot-builder-portable"})
    public static final class Companion {
        public final int estimateBreakCountInitial(double axisLength) {
            return this.estimateBreakCount(AxisLabelsLayout.Companion.getINITIAL_TICK_LABEL_LENGTH(), axisLength);
        }

        public final int estimateBreakCount(@NotNull List<String> labels, double axisLength) {
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            int maxLength = BreakLabelsLayoutUtil.INSTANCE.maxLength(labels);
            return this.estimateBreakCount(maxLength, axisLength);
        }

        private final int estimateBreakCount(int labelLength, double axisLength) {
            double tickDistance = AxisLabelsLayout.Companion.getTICK_LABEL_SPEC().width(labelLength) + AxisLabelsLayout.Companion.getMIN_TICK_LABEL_DISTANCE();
            double d = 1.0;
            double d2 = axisLength / tickDistance;
            boolean bl = false;
            return (int)Math.max(d, d2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

