/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.base.Strings;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotLayoutUtil;", "", "()V", "AXIS_TITLE_INNER_MARGIN", "", "getAXIS_TITLE_INNER_MARGIN", "()D", "AXIS_TITLE_OUTER_MARGIN", "getAXIS_TITLE_OUTER_MARGIN", "LIVE_MAP_PLOT_MARGIN", "Ljetbrains/datalore/base/geometry/DoubleVector;", "LIVE_MAP_PLOT_PADDING", "TITLE_V_MARGIN", "absoluteGeomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "origin", "plotLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "axisTitleDimensions", "text", "", "liveMapBounds", "plotOrigin", "plotDimension", "titleBounds", "titleSize", "containerSize", "titleDimensions", "plot-builder-portable"})
public final class PlotLayoutUtil {
    private static final double AXIS_TITLE_OUTER_MARGIN;
    private static final double AXIS_TITLE_INNER_MARGIN;
    private static final double TITLE_V_MARGIN;
    private static final DoubleVector LIVE_MAP_PLOT_PADDING;
    private static final DoubleVector LIVE_MAP_PLOT_MARGIN;
    public static final PlotLayoutUtil INSTANCE;

    public final double getAXIS_TITLE_OUTER_MARGIN() {
        return AXIS_TITLE_OUTER_MARGIN;
    }

    public final double getAXIS_TITLE_INNER_MARGIN() {
        return AXIS_TITLE_INNER_MARGIN;
    }

    @NotNull
    public final DoubleVector titleDimensions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Strings.INSTANCE.isNullOrEmpty(text)) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.PLOT_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height() + (double)2 * TITLE_V_MARGIN);
    }

    @NotNull
    public final DoubleRectangle titleBounds(@NotNull DoubleVector titleSize, @NotNull DoubleVector containerSize) {
        Intrinsics.checkNotNullParameter((Object)titleSize, (String)"titleSize");
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        double d = 0.0;
        double d2 = (containerSize.getX() - titleSize.getX()) / (double)2;
        boolean bl = false;
        double titleBoxLeft = Math.max(d, d2);
        double titleBoxTop = 0.0;
        return new DoubleRectangle(titleBoxLeft, titleBoxTop, titleSize.getX(), titleSize.getY());
    }

    @NotNull
    public final DoubleVector axisTitleDimensions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Strings.INSTANCE.isNullOrEmpty(text)) {
            return DoubleVector.Companion.getZERO();
        }
        PlotLabelSpec labelSpec = PlotLabelSpec.AXIS_TITLE;
        return new DoubleVector(labelSpec.width(text.length()), labelSpec.height());
    }

    @NotNull
    public final DoubleRectangle absoluteGeomBounds(@NotNull DoubleVector origin, @NotNull PlotLayoutInfo plotLayoutInfo) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)plotLayoutInfo, (String)"plotLayoutInfo");
        Preconditions.INSTANCE.checkArgument(!plotLayoutInfo.getTiles().isEmpty(), "Plot is empty");
        DoubleRectangle result = null;
        for (TileLayoutInfo tile2 : plotLayoutInfo.getTiles()) {
            DoubleRectangle geomBounds = tile2.getAbsoluteGeomBounds(origin);
            DoubleRectangle doubleRectangle = result;
            if (doubleRectangle == null || (doubleRectangle = doubleRectangle.union(geomBounds)) == null) {
                doubleRectangle = geomBounds;
            }
            result = doubleRectangle;
        }
        DoubleRectangle doubleRectangle = result;
        Intrinsics.checkNotNull((Object)doubleRectangle);
        return doubleRectangle;
    }

    @NotNull
    public final DoubleRectangle liveMapBounds(@NotNull DoubleVector plotOrigin, @NotNull DoubleVector plotDimension) {
        Intrinsics.checkNotNullParameter((Object)plotOrigin, (String)"plotOrigin");
        Intrinsics.checkNotNullParameter((Object)plotDimension, (String)"plotDimension");
        return new DoubleRectangle(plotOrigin.add(LIVE_MAP_PLOT_PADDING), plotDimension.subtract(LIVE_MAP_PLOT_MARGIN));
    }

    private PlotLayoutUtil() {
    }

    static {
        PlotLayoutUtil plotLayoutUtil;
        INSTANCE = plotLayoutUtil = new PlotLayoutUtil();
        AXIS_TITLE_OUTER_MARGIN = 4.0;
        AXIS_TITLE_INNER_MARGIN = 4.0;
        TITLE_V_MARGIN = 4.0;
        LIVE_MAP_PLOT_PADDING = new DoubleVector(10.0, 0.0);
        LIVE_MAP_PLOT_MARGIN = new DoubleVector(10.0, 10.0);
    }
}

