/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayout;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksProvider;
import jetbrains.datalore.plot.builder.layout.axis.AxisBreaksUtil;
import jetbrains.datalore.plot.builder.layout.axis.AxisLayouter;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BI\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout;", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "myScale", "Ljetbrains/datalore/plot/base/Scale;", "", "myXDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "myYDomain", "myCoordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "myTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "myOrientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "(Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/guide/Orientation;)V", "createLayouter", "Ljetbrains/datalore/plot/builder/layout/axis/AxisLayouter;", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "doLayout", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "maxTickLabelsBoundsStretched", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "initialThickness", "Companion", "plot-builder-portable"})
public final class PlotAxisLayout
implements AxisLayout {
    private final Scale<Double> myScale;
    private final ClosedRange<Double> myXDomain;
    private final ClosedRange<Double> myYDomain;
    private final CoordProvider myCoordProvider;
    private final AxisTheme myTheme;
    private final Orientation myOrientation;
    private static final PlotLabelSpec TICK_LABEL_SPEC;
    public static final Companion Companion;

    @Override
    public double initialThickness() {
        if (this.myTheme.showTickMarks() || this.myTheme.showTickLabels()) {
            double v = this.myTheme.tickLabelDistance();
            return this.myTheme.showTickLabels() ? v + PlotAxisLayout.Companion.initialTickLabelSize(this.myOrientation) : v;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public AxisLayoutInfo doLayout(@NotNull DoubleVector displaySize, @Nullable DoubleRectangle maxTickLabelsBoundsStretched) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        AxisLayouter layouter = this.createLayouter(displaySize);
        return layouter.doLayout(PlotAxisLayout.Companion.axisLength(displaySize, this.myOrientation), maxTickLabelsBoundsStretched);
    }

    private final AxisLayouter createLayouter(DoubleVector displaySize) {
        Pair<ClosedRange<Double>, ClosedRange<Double>> domains = this.myCoordProvider.adjustDomains(this.myXDomain, this.myYDomain, displaySize);
        ClosedRange axisDomain = PlotAxisLayout.Companion.axisDomain(domains, this.myOrientation);
        AxisBreaksProvider breaksProvider = AxisBreaksUtil.INSTANCE.createAxisBreaksProvider(this.myScale, axisDomain);
        return AxisLayouter.Companion.create(this.myOrientation, axisDomain, breaksProvider, this.myTheme);
    }

    private PlotAxisLayout(Scale<Double> myScale, ClosedRange<Double> myXDomain, ClosedRange<Double> myYDomain, CoordProvider myCoordProvider, AxisTheme myTheme, Orientation myOrientation) {
        this.myScale = myScale;
        this.myXDomain = myXDomain;
        this.myYDomain = myYDomain;
        this.myCoordProvider = myCoordProvider;
        this.myTheme = myTheme;
        this.myOrientation = myOrientation;
    }

    static {
        Companion = new Companion(null);
        TICK_LABEL_SPEC = PlotLabelSpec.AXIS_TICK;
    }

    public /* synthetic */ PlotAxisLayout(Scale myScale, ClosedRange myXDomain, ClosedRange myYDomain, CoordProvider myCoordProvider, AxisTheme myTheme, Orientation myOrientation, DefaultConstructorMarker $constructor_marker) {
        this(myScale, myXDomain, myYDomain, myCoordProvider, myTheme, myOrientation);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001e\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u001a\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/layout/PlotAxisLayout$Companion;", "", "()V", "TICK_LABEL_SPEC", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "xyDomains", "Ljetbrains/datalore/base/values/Pair;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisLength", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bottom", "Ljetbrains/datalore/plot/builder/layout/AxisLayout;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "xDomain", "yDomain", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "initialTickLabelSize", "left", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final AxisLayout bottom(@NotNull Scale<Double> scale, @NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull CoordProvider coordProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
            Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new PlotAxisLayout(scale, xDomain, yDomain, coordProvider, theme, Orientation.BOTTOM, null);
        }

        @NotNull
        public final AxisLayout left(@NotNull Scale<Double> scale, @NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull CoordProvider coordProvider, @NotNull AxisTheme theme) {
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
            Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new PlotAxisLayout(scale, xDomain, yDomain, coordProvider, theme, Orientation.LEFT, null);
        }

        private final double initialTickLabelSize(Orientation orientation) {
            return orientation.isHorizontal() ? TICK_LABEL_SPEC.height() : TICK_LABEL_SPEC.width(1);
        }

        private final double axisLength(DoubleVector displaySize, Orientation orientation) {
            return orientation.isHorizontal() ? displaySize.getX() : displaySize.getY();
        }

        private final ClosedRange<Double> axisDomain(Pair<ClosedRange<Double>, ClosedRange<Double>> xyDomains, Orientation orientation) {
            return orientation.isHorizontal() ? xyDomains.getFirst() : xyDomains.getSecond();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

