/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.layout.FacetGridPlotLayout$WhenMappings;
import jetbrains.datalore.plot.builder.layout.PlotLayoutBase;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutBase;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001b\u001c\u001dB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout;", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutBase;", "myColLabels", "", "", "myRowLabels", "myTileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "(Ljava/util/List;Ljava/util/List;Ljetbrains/datalore/plot/builder/layout/TileLayout;)V", "myColCount", "", "myFaceting", "Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$Faceting;", "myRowCount", "myTotalPanelHorizontalPadding", "", "myTotalPanelVerticalPadding", "doLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "layoutTile", "Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$MyTileInfo;", "tileWidth", "tileHeight", "tilesAreaSize", "tileInfo", "Companion", "Faceting", "MyTileInfo", "plot-builder-portable"})
public final class FacetGridPlotLayout
extends PlotLayoutBase {
    private final int myColCount;
    private final int myRowCount;
    private final Faceting myFaceting;
    private final double myTotalPanelHorizontalPadding;
    private final double myTotalPanelVerticalPadding;
    private final List<String> myColLabels;
    private final List<String> myRowLabels;
    private final TileLayout myTileLayout;
    private static final double FACET_TAB_HEIGHT = 30.0;
    private static final double PANEL_PADDING = 10.0;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        DoubleVector tilesAreaSize = new DoubleVector(preferredSize.getX() - (this.getPaddingLeft() + this.getPaddingRight()), preferredSize.getY() - (this.getPaddingTop() + this.getPaddingBottom()));
        switch (FacetGridPlotLayout$WhenMappings.$EnumSwitchMapping$0[this.myFaceting.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(0.0, 30.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(30.0, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(30.0, 30.0);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DoubleVector facetTabs = doubleVector;
        tilesAreaSize = tilesAreaSize.subtract(facetTabs);
        double tileWidth = (tilesAreaSize.getX() - this.myTotalPanelHorizontalPadding) / (double)this.myColCount;
        double tileHeight = (tilesAreaSize.getY() - this.myTotalPanelVerticalPadding) / (double)this.myRowCount;
        MyTileInfo tileInfo = this.layoutTile(tileWidth, tileHeight);
        boolean bl = false;
        boolean bl2 = true;
        while (bl <= bl2) {
            void i;
            DoubleVector tilesAreaSizeNew = this.tilesAreaSize(tileInfo);
            double widthDiff = tilesAreaSize.getX() - tilesAreaSizeNew.getX();
            double heightDiff = tilesAreaSize.getY() - tilesAreaSizeNew.getY();
            boolean bl3 = false;
            if (Math.abs(widthDiff) <= (double)this.myColCount) {
                bl3 = false;
                if (Math.abs(heightDiff) <= (double)this.myRowCount) break;
            }
            double geomWidth = tileInfo.geomWidth$plot_builder_portable() + widthDiff / (double)this.myColCount;
            double newPanelWidth = geomWidth + tileInfo.axisThicknessY$plot_builder_portable();
            double geomHeight = tileInfo.geomHeight$plot_builder_portable() + heightDiff / (double)this.myRowCount;
            double newPanelHeight = geomHeight + tileInfo.axisThicknessX$plot_builder_portable();
            tileInfo = this.layoutTile(newPanelWidth, newPanelHeight);
            ++i;
        }
        double axisThicknessX = tileInfo.axisThicknessX$plot_builder_portable();
        double axisThicknessY = tileInfo.axisThicknessY$plot_builder_portable();
        double geomWidth = tileInfo.geomWidth$plot_builder_portable();
        double geomHeight = tileInfo.geomHeight$plot_builder_portable();
        DoubleRectangle tilesAreaBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        DoubleVector tilesAreaOffset = new DoubleVector(this.getPaddingLeft(), this.getPaddingTop());
        ArrayList<TileLayoutInfo> tileInfos = new ArrayList<TileLayoutInfo>();
        double offsetY = 0.0;
        int newPanelHeight = 0;
        int n = this.myRowCount;
        while (newPanelHeight < n) {
            void row;
            double height = geomHeight;
            double geomY = 0.0;
            if (row == false) {
                height += facetTabs.getY();
                geomY = facetTabs.getY();
            }
            if (row == this.myRowCount - 1) {
                height += axisThicknessX;
            }
            double offsetX = 0.0;
            int n2 = 0;
            int n3 = this.myColCount;
            while (n2 < n3) {
                void col;
                String xFacetLabel = row == false && this.myColLabels.size() > col ? this.myColLabels.get((int)col) : "";
                String yFacetLabel = col == this.myColCount - 1 && this.myRowLabels.size() > row ? this.myRowLabels.get((int)row) : "";
                double width2 = geomWidth;
                double geomX = 0.0;
                if (col == false) {
                    width2 += axisThicknessY;
                    geomX = axisThicknessY;
                }
                if (col == this.myColCount - 1) {
                    width2 += facetTabs.getX();
                }
                DoubleRectangle bounds = new DoubleRectangle(0.0, 0.0, width2, height);
                DoubleRectangle geomBounds = new DoubleRectangle(geomX, geomY, geomWidth, geomHeight);
                DoubleVector offset2 = new DoubleVector(offsetX, offsetY);
                TileLayoutInfo info = new TileLayoutInfo(bounds, geomBounds, TileLayoutBase.Companion.clipBounds(geomBounds), tileInfo.getLayoutInfo$plot_builder_portable().getXAxisInfo(), tileInfo.getLayoutInfo$plot_builder_portable().getYAxisInfo(), row == this.myRowCount - 1, col == false).withOffset(tilesAreaOffset.add(offset2)).withFacetLabels(xFacetLabel, yFacetLabel);
                tileInfos.add(info);
                tilesAreaBounds = tilesAreaBounds.union(info.getAbsoluteBounds(tilesAreaOffset));
                offsetX += width2 + 10.0;
                ++col;
            }
            offsetY += height + 10.0;
            ++row;
        }
        DoubleVector plotSize = new DoubleVector(tilesAreaBounds.getRight() + this.getPaddingRight(), tilesAreaBounds.getHeight() + this.getPaddingBottom());
        return new PlotLayoutInfo((List<TileLayoutInfo>)tileInfos, plotSize);
    }

    private final MyTileInfo layoutTile(double tileWidth, double tileHeight) {
        TileLayoutInfo layoutInfo = this.myTileLayout.doLayout(new DoubleVector(tileWidth, tileHeight));
        return new MyTileInfo(layoutInfo);
    }

    private final DoubleVector tilesAreaSize(MyTileInfo tileInfo) {
        double w = tileInfo.geomWidth$plot_builder_portable() * (double)this.myColCount + this.myTotalPanelHorizontalPadding + tileInfo.axisThicknessY$plot_builder_portable();
        double h = tileInfo.geomHeight$plot_builder_portable() * (double)this.myRowCount + this.myTotalPanelVerticalPadding + tileInfo.axisThicknessX$plot_builder_portable();
        return new DoubleVector(w, h);
    }

    public FacetGridPlotLayout(@NotNull List<String> myColLabels, @NotNull List<String> myRowLabels, @NotNull TileLayout myTileLayout) {
        Intrinsics.checkNotNullParameter(myColLabels, (String)"myColLabels");
        Intrinsics.checkNotNullParameter(myRowLabels, (String)"myRowLabels");
        Intrinsics.checkNotNullParameter((Object)myTileLayout, (String)"myTileLayout");
        this.myColLabels = myColLabels;
        this.myRowLabels = myRowLabels;
        this.myTileLayout = myTileLayout;
        this.setPadding(10.0, 10.0, 0.0, 0.0);
        Preconditions.INSTANCE.checkArgument(!this.myColLabels.isEmpty() || !this.myRowLabels.isEmpty(), "No col/row labels");
        this.myFaceting = this.myColLabels.isEmpty() ? Faceting.ROW : (this.myRowLabels.isEmpty() ? Faceting.COL : Faceting.BOTH);
        this.myColCount = this.myColLabels.isEmpty() ? 1 : this.myColLabels.size();
        this.myRowCount = this.myRowLabels.isEmpty() ? 1 : this.myRowLabels.size();
        this.myTotalPanelHorizontalPadding = 10.0 * (double)(this.myColCount - 1);
        this.myTotalPanelVerticalPadding = 10.0 * (double)(this.myRowCount - 1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$Faceting;", "", "(Ljava/lang/String;I)V", "COL", "ROW", "BOTH", "plot-builder-portable"})
    public static final class Faceting
    extends Enum<Faceting> {
        public static final /* enum */ Faceting COL;
        public static final /* enum */ Faceting ROW;
        public static final /* enum */ Faceting BOTH;
        private static final /* synthetic */ Faceting[] $VALUES;

        static {
            Faceting[] facetingArray = new Faceting[3];
            Faceting[] facetingArray2 = facetingArray;
            facetingArray[0] = COL = new Faceting();
            facetingArray[1] = ROW = new Faceting();
            facetingArray[2] = BOTH = new Faceting();
            $VALUES = facetingArray;
        }

        public static Faceting[] values() {
            return (Faceting[])$VALUES.clone();
        }

        public static Faceting valueOf(String string) {
            return Enum.valueOf(Faceting.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$MyTileInfo;", "", "layoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "(Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;)V", "getLayoutInfo$plot_builder_portable", "()Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "axisThicknessX", "", "axisThicknessX$plot_builder_portable", "axisThicknessY", "axisThicknessY$plot_builder_portable", "geomHeight", "geomHeight$plot_builder_portable", "geomWidth", "geomWidth$plot_builder_portable", "plot-builder-portable"})
    private static final class MyTileInfo {
        @NotNull
        private final TileLayoutInfo layoutInfo;

        public final double axisThicknessX$plot_builder_portable() {
            return this.layoutInfo.getBounds().getBottom() - this.layoutInfo.getGeomBounds().getBottom();
        }

        public final double axisThicknessY$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getLeft() - this.layoutInfo.getBounds().getLeft();
        }

        public final double geomWidth$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getWidth();
        }

        public final double geomHeight$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getHeight();
        }

        @NotNull
        public final TileLayoutInfo getLayoutInfo$plot_builder_portable() {
            return this.layoutInfo;
        }

        public MyTileInfo(@NotNull TileLayoutInfo layoutInfo) {
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            this.layoutInfo = layoutInfo;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$Companion;", "", "()V", "FACET_TAB_HEIGHT", "", "PANEL_PADDING", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

