/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.coord.Projection;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.coord.CoordProviderBase;
import jetbrains.datalore.plot.builder.coord.FixedRatioCoordProvider;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJD\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J:\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/builder/coord/ProjectionCoordProvider;", "Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "projectionX", "Ljetbrains/datalore/plot/base/coord/Projection;", "projectionY", "xLim", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "yLim", "(Ljetbrains/datalore/plot/base/coord/Projection;Ljetbrains/datalore/plot/base/coord/Projection;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;)V", "adjustDomains", "Ljetbrains/datalore/base/values/Pair;", "xDomain", "yDomain", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "buildAxisScaleX", "Ljetbrains/datalore/plot/base/Scale;", "scaleProto", "domain", "axisLength", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "buildAxisScaleY", "Companion", "plot-builder-portable"})
public final class ProjectionCoordProvider
extends CoordProviderBase {
    private final Projection projectionX;
    private final Projection projectionY;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Pair<ClosedRange<Double>, ClosedRange<Double>> adjustDomains(@NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull DoubleVector displaySize) {
        Pair<ClosedRange<Comparable>, ClosedRange<Double>> pair2;
        double halfSpan;
        double center;
        Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
        Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        Pair<ClosedRange<Double>, ClosedRange<Double>> adjusted = super.adjustDomains(xDomain, yDomain, displaySize);
        ClosedRange<Double> xDomain2 = this.projectionX.toValidDomain(adjusted.getFirst());
        ClosedRange<Double> yDomain2 = this.projectionY.toValidDomain(adjusted.getSecond());
        double spanX = SeriesUtil.INSTANCE.span(xDomain2);
        double spanY = SeriesUtil.INSTANCE.span(yDomain2);
        if (spanX > spanY) {
            center = ((Number)xDomain2.getLowerEnd()).doubleValue() + spanX / (double)2;
            halfSpan = spanY / (double)2;
            pair2 = new Pair<ClosedRange<Comparable>, ClosedRange<Double>>(new ClosedRange<Comparable>(Double.valueOf(center - halfSpan), Double.valueOf(center + halfSpan)), yDomain2);
        } else {
            center = ((Number)yDomain2.getLowerEnd()).doubleValue() + spanY / (double)2;
            halfSpan = spanX / (double)2;
            pair2 = new Pair<ClosedRange<Double>, ClosedRange<Comparable>>(xDomain2, new ClosedRange<Comparable>(Double.valueOf(center - halfSpan), Double.valueOf(center + halfSpan)));
        }
        Pair<ClosedRange<Comparable>, ClosedRange<Double>> domainSquare = pair2;
        double projectedXMin = this.projectionX.apply(((Number)((Object)domainSquare.getFirst().getLowerEnd())).doubleValue());
        double projectedXMax = this.projectionX.apply(((Number)((Object)domainSquare.getFirst().getUpperEnd())).doubleValue());
        double projectedYMin = this.projectionY.apply(((Number)domainSquare.getSecond().getLowerEnd()).doubleValue());
        double projectedYMax = this.projectionY.apply(((Number)domainSquare.getSecond().getUpperEnd()).doubleValue());
        double ratio = (projectedYMax - projectedYMin) / (projectedXMax - projectedXMin);
        FixedRatioCoordProvider fixedCoord = new FixedRatioCoordProvider(ratio, null, null);
        return fixedCoord.adjustDomains(xDomain2, yDomain2, displaySize);
    }

    @Override
    @NotNull
    public Scale<Double> buildAxisScaleX(@NotNull Scale<Double> scaleProto, @NotNull ClosedRange<Double> domain, double axisLength, @NotNull GuideBreaks breaks) {
        Intrinsics.checkNotNullParameter(scaleProto, (String)"scaleProto");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        return this.projectionX.getNonlinear() ? ProjectionCoordProvider.Companion.buildAxisScaleWithProjection(this.projectionX, scaleProto, domain, axisLength, breaks) : super.buildAxisScaleX(scaleProto, domain, axisLength, breaks);
    }

    @Override
    @NotNull
    public Scale<Double> buildAxisScaleY(@NotNull Scale<Double> scaleProto, @NotNull ClosedRange<Double> domain, double axisLength, @NotNull GuideBreaks breaks) {
        Intrinsics.checkNotNullParameter(scaleProto, (String)"scaleProto");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        return this.projectionY.getNonlinear() ? ProjectionCoordProvider.Companion.buildAxisScaleWithProjection(this.projectionY, scaleProto, domain, axisLength, breaks) : super.buildAxisScaleY(scaleProto, domain, axisLength, breaks);
    }

    public ProjectionCoordProvider(@NotNull Projection projectionX, @NotNull Projection projectionY, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim) {
        Intrinsics.checkNotNullParameter((Object)projectionX, (String)"projectionX");
        Intrinsics.checkNotNullParameter((Object)projectionY, (String)"projectionY");
        super(xLim, yLim);
        this.projectionX = projectionX;
        this.projectionY = projectionY;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002JL\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/coord/ProjectionCoordProvider$Companion;", "", "()V", "buildAxisScaleWithProjection", "Ljetbrains/datalore/plot/base/Scale;", "", "projection", "Ljetbrains/datalore/plot/base/coord/Projection;", "scaleProto", "domain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "axisLength", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "twistScaleMapper", "Lkotlin/Function1;", "projectionInverse", "scaleMapper", "validateBreaks", "validDomain", "plot-builder-portable"})
    public static final class Companion {
        private final Scale<Double> buildAxisScaleWithProjection(Projection projection, Scale<Double> scaleProto, ClosedRange<Double> domain, double axisLength, GuideBreaks breaks) {
            ClosedRange<Double> validDomain = projection.toValidDomain(domain);
            ClosedRange<Comparable> validDomainProjected = new ClosedRange<Comparable>(Double.valueOf(projection.apply(((Number)validDomain.getLowerEnd()).doubleValue())), Double.valueOf(projection.apply(((Number)validDomain.getUpperEnd()).doubleValue())));
            Function1<Double, Double> projectionInverse = Mappers.INSTANCE.linear(validDomainProjected, validDomain);
            Function1<Double, Double> linearMapper = CoordProviderBase.Companion.linearMapper(domain, axisLength);
            Function1<Double, Double> scaleMapper = this.twistScaleMapper(projection, projectionInverse, linearMapper);
            GuideBreaks validBreaks = this.validateBreaks(validDomain, breaks);
            return CoordProviderBase.Companion.buildAxisScaleDefault(scaleProto, scaleMapper, validBreaks);
        }

        private final GuideBreaks validateBreaks(ClosedRange<Double> validDomain, GuideBreaks breaks) {
            ArrayList<Integer> validIndices = new ArrayList<Integer>();
            int i = 0;
            for (Object v : breaks.getDomainValues()) {
                if (v instanceof Double && validDomain.contains((Double)((Comparable)v))) {
                    validIndices.add(i);
                }
                ++i;
            }
            if (validIndices.size() == breaks.getDomainValues().size()) {
                return breaks;
            }
            List<?> validDomainValues = SeriesUtil.INSTANCE.pickAtIndices(breaks.getDomainValues(), (List<Integer>)validIndices);
            List<String> validLabels = SeriesUtil.INSTANCE.pickAtIndices(breaks.getLabels(), (List<Integer>)validIndices);
            List<Double> validTransformedValues = SeriesUtil.INSTANCE.pickAtIndices(breaks.getTransformedValues(), (List<Integer>)validIndices);
            return new GuideBreaks(validDomainValues, validTransformedValues, validLabels);
        }

        private final Function1<Double, Double> twistScaleMapper(Projection projection, Function1<? super Double, Double> projectionInverse, Function1<? super Double, Double> scaleMapper) {
            return (Function1)new Function1<Double, Double>(projection, projectionInverse, scaleMapper){
                final /* synthetic */ Projection $projection;
                final /* synthetic */ Function1 $projectionInverse;
                final /* synthetic */ Function1 $scaleMapper;

                @Nullable
                public final Double invoke(@Nullable Double v) {
                    Double d;
                    Double d2 = v;
                    if (d2 != null) {
                        Double d3 = d2;
                        boolean bl = false;
                        boolean bl2 = false;
                        double $this$run = ((Number)d3).doubleValue();
                        boolean bl3 = false;
                        double projected = this.$projection.apply(v);
                        double unProjected = ((Number)this.$projectionInverse.invoke((Object)projected)).doubleValue();
                        d = (Double)this.$scaleMapper.invoke((Object)unProjected);
                    } else {
                        d = null;
                    }
                    return d;
                }
                {
                    this.$projection = projection;
                    this.$projectionInverse = function1;
                    this.$scaleMapper = function12;
                    super(1);
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

