/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssembler;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.LegendOptions;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendComponent;
import jetbrains.datalore.plot.builder.guide.LegendComponentLayout;
import jetbrains.datalore.plot.builder.guide.LegendComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJb\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0005J\u0006\u0010\u001e\u001a\u00020\u001fR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler;", "", "legendTitle", "", "guideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/Map;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "myLegendLayers", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "Lkotlin/collections/ArrayList;", "addLayer", "", "keyFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "varBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "constantByAes", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "dataRangeByAes", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "createLegend", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "Companion", "LegendLayer", "plot-builder-portable"})
public final class LegendAssembler {
    private final ArrayList<LegendLayer> myLegendLayers;
    private final String legendTitle;
    private final Map<Aes<?>, GuideOptions> guideOptionsMap;
    private final LegendTheme theme;
    private static final boolean DEBUG_DRAWING = false;
    public static final Companion Companion = new Companion(null);

    public final void addLayer(@NotNull LegendKeyElementFactory keyFactory, @NotNull List<VarBinding> varBindings, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull TypedScaleMap scaleByAes2, @NotNull Map<Aes<?>, ? extends ClosedRange<Double>> dataRangeByAes) {
        Intrinsics.checkNotNullParameter((Object)keyFactory, (String)"keyFactory");
        Intrinsics.checkNotNullParameter(varBindings, (String)"varBindings");
        Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
        Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
        Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
        Intrinsics.checkNotNullParameter(dataRangeByAes, (String)"dataRangeByAes");
        this.myLegendLayers.add(new LegendLayer(keyFactory, varBindings, constantByAes, aestheticsDefaults, scaleByAes2, dataRangeByAes));
    }

    @NotNull
    public final LegendBoxInfo createLegend() {
        LinkedHashMap legendBreaksByLabel = new LinkedHashMap();
        for (LegendLayer legendLayer : this.myLegendLayers) {
            LegendKeyElementFactory keyElementFactory = legendLayer.getKeyElementFactory$plot_builder_portable();
            Aesthetics aesthetics = legendLayer.getKeyAesthetics$plot_builder_portable();
            Intrinsics.checkNotNull((Object)aesthetics);
            Iterator<DataPointAesthetics> dataPoints2 = aesthetics.dataPoints().iterator();
            List<String> list2 = legendLayer.getKeyLabels$plot_builder_portable();
            Intrinsics.checkNotNull(list2);
            for (String label : list2) {
                if (!legendBreaksByLabel.containsKey(label)) {
                    ((Map)legendBreaksByLabel).put(label, new LegendBreak(label));
                }
                Object v = legendBreaksByLabel.get(label);
                Intrinsics.checkNotNull(v);
                ((LegendBreak)v).addLayer(dataPoints2.next(), keyElementFactory);
            }
        }
        ArrayList<LegendBreak> legendBreaks = new ArrayList<LegendBreak>();
        for (LegendBreak legendBreak : legendBreaksByLabel.values()) {
            if (legendBreak.isEmpty()) continue;
            legendBreaks.add(legendBreak);
        }
        if (legendBreaks.isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ArrayList<LegendOptions> legendOptionsList = new ArrayList<LegendOptions>();
        for (LegendLayer legendLayer : this.myLegendLayers) {
            List<Aes<?>> aesList = legendLayer.getAesList$plot_builder_portable();
            for (Aes<?> aes : aesList) {
                if (!(this.guideOptionsMap.get(aes) instanceof LegendOptions)) continue;
                GuideOptions guideOptions = this.guideOptionsMap.get(aes);
                if (guideOptions == null) {
                    throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.assemble.LegendOptions");
                }
                legendOptionsList.add((LegendOptions)guideOptions);
            }
        }
        LegendComponentSpec spec = Companion.createLegendSpec(this.legendTitle, (List<LegendBreak>)legendBreaks, this.theme, LegendOptions.Companion.combine((List<LegendOptions>)legendOptionsList));
        return new LegendBoxInfo(spec, spec.getSize()){
            final /* synthetic */ LegendComponentSpec $spec;

            @NotNull
            public LegendBox createLegendBox() {
                LegendComponent c = new LegendComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
            {
                this.$spec = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    public LegendAssembler(@NotNull String legendTitle, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.guideOptionsMap = guideOptionsMap;
        this.theme = theme;
        this.myLegendLayers = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u001c\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\b\u00a2\u0006\u0002\u0010\u0011J&\u0010\"\u001a\u00020#2\u001c\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\bH\u0002R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010!R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "", "keyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "varBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "constantByAes", "", "Ljetbrains/datalore/plot/base/Aes;", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "scaleMap", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "dataRangeByAes", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "(Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;Ljava/util/List;Ljava/util/Map;Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;Ljava/util/Map;)V", "aesList", "getAesList$plot_builder_portable", "()Ljava/util/List;", "keyAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "getKeyAesthetics$plot_builder_portable", "()Ljetbrains/datalore/plot/base/Aesthetics;", "setKeyAesthetics$plot_builder_portable", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "getKeyElementFactory$plot_builder_portable", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "keyLabels", "", "getKeyLabels$plot_builder_portable", "setKeyLabels$plot_builder_portable", "(Ljava/util/List;)V", "init", "", "plot-builder-portable"})
    private static final class LegendLayer {
        @Nullable
        private Aesthetics keyAesthetics;
        @Nullable
        private List<String> keyLabels;
        @NotNull
        private final LegendKeyElementFactory keyElementFactory;
        private final List<VarBinding> varBindings;
        private final Map<Aes<?>, Object> constantByAes;
        private final AestheticsDefaults aestheticsDefaults;
        private final TypedScaleMap scaleMap;

        @Nullable
        public final Aesthetics getKeyAesthetics$plot_builder_portable() {
            return this.keyAesthetics;
        }

        public final void setKeyAesthetics$plot_builder_portable(@Nullable Aesthetics aesthetics) {
            this.keyAesthetics = aesthetics;
        }

        @Nullable
        public final List<String> getKeyLabels$plot_builder_portable() {
            return this.keyLabels;
        }

        public final void setKeyLabels$plot_builder_portable(@Nullable List<String> list2) {
            this.keyLabels = list2;
        }

        @NotNull
        public final List<Aes<?>> getAesList$plot_builder_portable() {
            ArrayList result = new ArrayList();
            for (VarBinding binding : this.varBindings) {
                result.add(binding.getAes());
            }
            return result;
        }

        private final void init(Map<Aes<?>, ? extends ClosedRange<Double>> dataRangeByAes) {
            LinkedHashMap aesValuesByLabel = new LinkedHashMap();
            for (VarBinding varBinding : this.varBindings) {
                Aes<?> aes = varBinding.getAes();
                Scale<?> scale = this.scaleMap.get(aes);
                if (!scale.hasBreaks()) {
                    if (!dataRangeByAes.containsKey(aes)) continue;
                    ClosedRange<Double> closedRange = dataRangeByAes.get(aes);
                    Intrinsics.checkNotNull(closedRange);
                    scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, closedRange, 5);
                }
                Preconditions.INSTANCE.checkState(scale.hasBreaks(), "No breaks were defined for scale " + aes);
                Iterator<?> values2 = ScaleUtil.INSTANCE.breaksAesthetics(scale).iterator();
                List<String> labels = ScaleUtil.INSTANCE.labels(scale);
                for (String label : labels) {
                    if (!aesValuesByLabel.containsKey(label)) {
                        ((Map)aesValuesByLabel).put(label, new HashMap());
                    }
                    Object value = values2.next();
                    Object v = aesValuesByLabel.get(label);
                    Intrinsics.checkNotNull(v);
                    Map map2 = (Map)v;
                    Object obj = value;
                    Intrinsics.checkNotNull(obj);
                    map2.put(aes, obj);
                }
            }
            Collection collection2 = aesValuesByLabel.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"aesValuesByLabel.values");
            this.keyAesthetics = LegendAssemblerUtil.INSTANCE.mapToAesthetics(collection2, this.constantByAes, this.aestheticsDefaults);
            this.keyLabels = new ArrayList(aesValuesByLabel.keySet());
        }

        @NotNull
        public final LegendKeyElementFactory getKeyElementFactory$plot_builder_portable() {
            return this.keyElementFactory;
        }

        public LegendLayer(@NotNull LegendKeyElementFactory keyElementFactory, @NotNull List<VarBinding> varBindings, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull TypedScaleMap scaleMap, @NotNull Map<Aes<?>, ? extends ClosedRange<Double>> dataRangeByAes) {
            Intrinsics.checkNotNullParameter((Object)keyElementFactory, (String)"keyElementFactory");
            Intrinsics.checkNotNullParameter(varBindings, (String)"varBindings");
            Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
            Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
            Intrinsics.checkNotNullParameter((Object)scaleMap, (String)"scaleMap");
            Intrinsics.checkNotNullParameter(dataRangeByAes, (String)"dataRangeByAes");
            this.keyElementFactory = keyElementFactory;
            this.varBindings = varBindings;
            this.constantByAes = constantByAes;
            this.aestheticsDefaults = aestheticsDefaults;
            this.scaleMap = scaleMap;
            this.init(dataRangeByAes);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createLegendSpec", "Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/LegendOptions;", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final LegendComponentSpec createLegendSpec(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull LegendTheme theme, @NotNull LegendOptions options) {
            double d;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            createLegendSpec.1 $fun$pretty$1 = createLegendSpec.1.INSTANCE;
            DoubleVector keySize = new DoubleVector(theme.keySize(), theme.keySize());
            for (LegendBreak br : breaks) {
                DoubleVector minimumKeySize = br.getMinimumKeySize();
                keySize = keySize.max($fun$pretty$1.invoke(minimumKeySize));
            }
            int breakCount = breaks.size();
            int colCount = 0;
            int rowCount = 0;
            if (options.isByRow()) {
                boolean bl;
                int n;
                if (options.hasColCount()) {
                    int n2 = options.getColCount();
                    boolean bl2 = false;
                    n = Math.min(n2, breakCount);
                } else if (options.hasRowCount()) {
                    double d2 = (double)breakCount / (double)options.getRowCount();
                    bl = false;
                    n = (int)Math.ceil(d2);
                } else {
                    n = legendDirection == LegendDirection.HORIZONTAL ? breakCount : 1;
                }
                colCount = n;
                d = (double)breakCount / (double)colCount;
                bl = false;
                rowCount = (int)Math.ceil(d);
            } else {
                boolean bl;
                int n;
                if (options.hasRowCount()) {
                    int n3 = options.getRowCount();
                    boolean bl3 = false;
                    n = Math.min(n3, breakCount);
                } else if (options.hasColCount()) {
                    double d3 = (double)breakCount / (double)options.getColCount();
                    bl = false;
                    n = (int)Math.ceil(d3);
                } else {
                    n = legendDirection != LegendDirection.HORIZONTAL ? breakCount : 1;
                }
                rowCount = n;
                d = (double)breakCount / (double)rowCount;
                bl = false;
                colCount = (int)Math.ceil(d);
            }
            LegendComponentLayout layout = null;
            layout = legendDirection == LegendDirection.HORIZONTAL ? (options.hasRowCount() || options.hasColCount() && options.getColCount() < breakCount ? LegendComponentLayout.Companion.horizontalMultiRow(title, breaks, keySize) : LegendComponentLayout.Companion.horizontal(title, breaks, keySize)) : LegendComponentLayout.Companion.vertical(title, breaks, keySize);
            layout.setColCount(colCount);
            layout.setRowCount(rowCount);
            layout.setFillByRow(options.isByRow());
            return new LegendComponentSpec(title, breaks, theme, layout);
        }

        public static /* synthetic */ LegendComponentSpec createLegendSpec$default(Companion companion, String string, List list2, LegendTheme legendTheme, LegendOptions legendOptions, int n, Object object) {
            if ((n & 8) != 0) {
                legendOptions = new LegendOptions();
            }
            return companion.createLegendSpec(string, list2, legendTheme, legendOptions);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

