/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.interact.GeomTarget;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.interact.TooltipSpecFactory;
import jetbrains.datalore.plot.builder.interact.loc.LocatedTargetsPicker;
import jetbrains.datalore.plot.builder.interact.loc.TransformedTargetLocator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/PlotTooltipHelper;", "", "()V", "myTileInfos", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/PlotTooltipHelper$TileInfo;", "Lkotlin/collections/ArrayList;", "addTileInfo", "", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "hasTooltipAnchor", "", "createTooltipSpecs", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "plotCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "lookupResults", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupResult;", "axisOrigin", "findTileInfo", "getGeomBounds", "removeAllTileInfos", "TileInfo", "plot-builder-portable"})
public final class PlotTooltipHelper {
    private final ArrayList<TileInfo> myTileInfos = new ArrayList();

    public final void removeAllTileInfos() {
        this.myTileInfos.clear();
    }

    public final void addTileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, boolean hasTooltipAnchor) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        if (hasTooltipAnchor) {
            double d2 = geomBounds.getWidth();
            double d3 = geomBounds.getHeight();
            boolean bl = false;
            d = Math.max(d2, d3);
        } else {
            d = null;
        }
        TileInfo tileInfo = new TileInfo(geomBounds, targetLocators, d);
        this.myTileInfos.add(tileInfo);
    }

    @NotNull
    public final List<TooltipSpec> createTooltipSpecs(@NotNull DoubleVector plotCoord) {
        Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
        TileInfo tileInfo = this.findTileInfo(plotCoord);
        if (tileInfo == null) {
            return CollectionsKt.emptyList();
        }
        TileInfo tileInfo2 = tileInfo;
        List<GeomTargetLocator.LookupResult> lookupResults = tileInfo2.findTargets$plot_builder_portable(plotCoord);
        return this.createTooltipSpecs(lookupResults, tileInfo2.getAxisOrigin$plot_builder_portable());
    }

    @Nullable
    public final DoubleRectangle getGeomBounds(@NotNull DoubleVector plotCoord) {
        Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
        TileInfo tileInfo = this.findTileInfo(plotCoord);
        if (tileInfo == null) {
            return null;
        }
        TileInfo tileInfo2 = tileInfo;
        return tileInfo2.getGeomBounds$plot_builder_portable();
    }

    private final TileInfo findTileInfo(DoubleVector plotCoord) {
        for (TileInfo tileInfo : this.myTileInfos) {
            if (!tileInfo.contains$plot_builder_portable(plotCoord)) continue;
            return tileInfo;
        }
        return null;
    }

    private final List<TooltipSpec> createTooltipSpecs(List<? extends GeomTargetLocator.LookupResult> lookupResults, DoubleVector axisOrigin) {
        ArrayList tooltipSpecs = new ArrayList();
        Iterable $this$forEach$iv = lookupResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeomTargetLocator.LookupResult result = (GeomTargetLocator.LookupResult)element$iv;
            boolean bl = false;
            TooltipSpecFactory factory = new TooltipSpecFactory(result.getContextualMapping(), axisOrigin);
            Iterable $this$forEach$iv2 = result.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GeomTarget geomTarget = (GeomTarget)element$iv2;
                boolean bl2 = false;
                tooltipSpecs.addAll(factory.create(geomTarget));
            }
        }
        return tooltipSpecs;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0080\u0002\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010\u0015\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0019R\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/PlotTooltipHelper$TileInfo;", "", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "maxAllowedDistance", "", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljava/util/List;Ljava/lang/Double;)V", "axisOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getAxisOrigin$plot_builder_portable", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getGeomBounds$plot_builder_portable", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "Ljava/lang/Double;", "myTargetLocators", "Ljetbrains/datalore/plot/builder/PlotTooltipHelper$TileInfo$TileTargetLocator;", "contains", "", "plotCoord", "contains$plot_builder_portable", "findTargets", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupResult;", "findTargets$plot_builder_portable", "TileTargetLocator", "plot-builder-portable"})
    private static final class TileInfo {
        private final List<TileTargetLocator> myTargetLocators;
        @NotNull
        private final DoubleRectangle geomBounds;
        private final Double maxAllowedDistance;

        @NotNull
        public final DoubleVector getAxisOrigin$plot_builder_portable() {
            return new DoubleVector(this.geomBounds.getLeft(), this.geomBounds.getBottom());
        }

        @NotNull
        public final List<GeomTargetLocator.LookupResult> findTargets$plot_builder_portable(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            LocatedTargetsPicker locatedTargetsPicker = new LocatedTargetsPicker();
            boolean bl = false;
            boolean bl2 = false;
            LocatedTargetsPicker $this$apply = locatedTargetsPicker;
            boolean bl3 = false;
            Double d = this.maxAllowedDistance;
            if (d != null) {
                Double d2 = d;
                boolean bl4 = false;
                boolean bl5 = false;
                double p1 = ((Number)d2).doubleValue();
                boolean bl6 = false;
                $this$apply.updateMaxDistance(p1);
            }
            for (TileTargetLocator locator : this.myTargetLocators) {
                GeomTargetLocator.LookupResult result = locator.search(plotCoord);
                if (result == null) continue;
                $this$apply.addLookupResult(result);
            }
            LocatedTargetsPicker targetsPicker = locatedTargetsPicker;
            return targetsPicker.getPicked();
        }

        public final boolean contains$plot_builder_portable(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            return this.geomBounds.contains(plotCoord);
        }

        @NotNull
        public final DoubleRectangle getGeomBounds$plot_builder_portable() {
            return this.geomBounds;
        }

        /*
         * WARNING - void declaration
         */
        public TileInfo(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @Nullable Double maxAllowedDistance) {
            Collection<TileTargetLocator> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
            Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
            this.geomBounds = geomBounds;
            this.maxAllowedDistance = maxAllowedDistance;
            Iterable iterable = targetLocators;
            TileInfo tileInfo = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GeomTargetLocator geomTargetLocator = (GeomTargetLocator)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                TileTargetLocator tileTargetLocator = new TileTargetLocator((GeomTargetLocator)it);
                collection2.add(tileTargetLocator);
            }
            collection2 = (List)destination$iv$iv;
            tileInfo.myTargetLocators = collection2;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/PlotTooltipHelper$TileInfo$TileTargetLocator;", "Ljetbrains/datalore/plot/builder/interact/loc/TransformedTargetLocator;", "locator", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "(Ljetbrains/datalore/plot/builder/PlotTooltipHelper$TileInfo;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;)V", "convertToPlotCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder-portable"})
        private final class TileTargetLocator
        extends TransformedTargetLocator {
            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds$plot_builder_portable().getOrigin());
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.add(TileInfo.this.getGeomBounds$plot_builder_portable().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }

            public TileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }
        }
    }
}

