/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.event.Event;
import jetbrains.datalore.base.gcommon.base.Throwables;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.property.PropertyChangeEvent;
import jetbrains.datalore.base.observable.property.ReadableProperty;
import jetbrains.datalore.base.observable.property.ValueProperty;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.BogusCoordinateSystem;
import jetbrains.datalore.plot.builder.BogusScale;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.Plot;
import jetbrains.datalore.plot.builder.Plot$WhenMappings;
import jetbrains.datalore.plot.builder.PlotTile;
import jetbrains.datalore.plot.builder.PlotTooltipHelper;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.guide.TooltipAnchor;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.event.SvgEventHandler;
import jetbrains.datalore.vis.svg.event.SvgEventSpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 `2\u00020\u0001:\u0001`B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00108\u001a\u000209H\u0014J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J(\u0010<\u001a\u0002092\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J&\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u0014H\u0002J\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u00142\u0006\u0010L\u001a\u00020!J\u0010\u0010M\u001a\u0004\u0018\u00010A2\u0006\u0010L\u001a\u00020!J\b\u0010N\u001a\u00020\u0010H$J\b\u0010O\u001a\u00020\u0010H$J\b\u0010P\u001a\u00020\u0010H$J\b\u0010Q\u001a\u00020\u0010H$J\f\u0010R\u001a\b\u0012\u0004\u0012\u00020!0SJ\u0018\u0010T\u001a\u0002092\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u0006H\u0002J\b\u0010X\u001a\u00020YH$J\u0013\u0010Z\u001a\b\u0012\u0004\u0012\u00020!0[H\u0000\u00a2\u0006\u0002\b\\J\b\u0010]\u001a\u000209H\u0002J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00142\u0006\u0010^\u001a\u00020_H$R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00190#j\b\u0012\u0004\u0012\u00020\u0019`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0018\u0010-\u001a\b\u0012\u0004\u0012\u00020*0)X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0014\u00101\u001a\u0004\u0018\u000102X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0004\u0018\u00010*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006a"}, d2={"Ljetbrains/datalore/plot/builder/Plot;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/builder/theme/Theme;)V", "axisTitleBottom", "", "getAxisTitleBottom", "()Ljava/lang/String;", "axisTitleLeft", "getAxisTitleLeft", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "getCoordProvider", "()Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "isAxisEnabled", "", "()Z", "isInteractionsEnabled", "legendBoxInfos", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "getLegendBoxInfos", "()Ljava/util/List;", "liveMapFigures", "Ljetbrains/datalore/base/values/SomeFig;", "getLiveMapFigures$plot_builder_portable", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "getMouseEventPeer", "()Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "myLaidOutSize", "Ljetbrains/datalore/base/observable/property/ValueProperty;", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myLiveMapFigures", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myPreferredSize", "myTooltipHelper", "Ljetbrains/datalore/plot/builder/PlotTooltipHelper;", "scaleXProto", "Ljetbrains/datalore/plot/base/Scale;", "", "getScaleXProto", "()Ljetbrains/datalore/plot/base/Scale;", "scaleYProto", "getScaleYProto", "title", "getTitle", "tooltipAnchor", "Ljetbrains/datalore/plot/builder/guide/TooltipAnchor;", "getTooltipAnchor", "()Ljetbrains/datalore/plot/builder/guide/TooltipAnchor;", "tooltipMinWidth", "getTooltipMinWidth", "()Ljava/lang/Double;", "buildComponent", "", "buildPlot", "buildPlotComponents", "createAxisTitle", "text", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "plotBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomBounds", "createTile", "Ljetbrains/datalore/plot/builder/PlotTile;", "tilesOrigin", "tileInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "tileLayers", "Ljetbrains/datalore/plot/builder/GeomLayer;", "createTooltipSpecs", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "plotCoord", "getGeomBounds", "hasAxisTitleBottom", "hasAxisTitleLeft", "hasLiveMap", "hasTitle", "laidOutSize", "Ljetbrains/datalore/base/observable/property/ReadableProperty;", "onMouseMove", "e", "Ljetbrains/datalore/vis/svg/SvgElement;", "message", "plotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "preferredSize", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "preferredSize$plot_builder_portable", "rebuildPlot", "tileIndex", "", "Companion", "plot-builder-portable"})
public abstract class Plot
extends SvgComponent {
    private final ValueProperty<DoubleVector> myPreferredSize;
    private final ValueProperty<DoubleVector> myLaidOutSize;
    private final PlotTooltipHelper myTooltipHelper;
    private final ArrayList<SomeFig> myLiveMapFigures;
    @NotNull
    private final MouseEventPeer mouseEventPeer;
    private final Theme theme;
    private static final Logger LOG;
    private static final DoubleVector DEF_PLOT_SIZE;
    private static final boolean DEBUG_DRAWING = false;
    public static final Companion Companion;

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.mouseEventPeer;
    }

    @NotNull
    protected abstract Scale<Double> getScaleXProto();

    @NotNull
    protected abstract Scale<Double> getScaleYProto();

    @NotNull
    protected abstract String getTitle();

    @NotNull
    protected abstract String getAxisTitleLeft();

    @NotNull
    protected abstract String getAxisTitleBottom();

    @NotNull
    protected abstract CoordProvider getCoordProvider();

    @NotNull
    protected abstract List<LegendBoxInfo> getLegendBoxInfos();

    protected abstract boolean isAxisEnabled();

    @Nullable
    public abstract TooltipAnchor getTooltipAnchor();

    @Nullable
    public abstract Double getTooltipMinWidth();

    public abstract boolean isInteractionsEnabled();

    @NotNull
    public final List<SomeFig> getLiveMapFigures$plot_builder_portable() {
        return this.myLiveMapFigures;
    }

    @NotNull
    public final WritableProperty<DoubleVector> preferredSize$plot_builder_portable() {
        return this.myPreferredSize;
    }

    @NotNull
    public final ReadableProperty<DoubleVector> laidOutSize() {
        return this.myLaidOutSize;
    }

    protected abstract boolean hasTitle();

    protected abstract boolean hasAxisTitleLeft();

    protected abstract boolean hasAxisTitleBottom();

    protected abstract boolean hasLiveMap();

    @NotNull
    protected abstract List<GeomLayer> tileLayers(int var1);

    @NotNull
    protected abstract PlotLayout plotLayout();

    @Override
    protected void buildComponent() {
        try {
            this.buildPlot();
        }
        catch (RuntimeException e) {
            LOG.error(e, (Function0<String>)((Function0)buildComponent.1.INSTANCE));
            Throwable rootCause = Throwables.INSTANCE.getRootCause(e);
            String[] messages = new String[]{"Error building plot: " + Reflection.getOrCreateKotlinClass(rootCause.getClass()).getSimpleName(), rootCause.getMessage() != null ? "'" + rootCause.getMessage() + "'" : "<no message>"};
            double y2 = this.myPreferredSize.get().getY() / (double)2 - (double)8;
            for (String s2 : messages) {
                TextLabel errorLabel = new TextLabel(s2);
                errorLabel.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                errorLabel.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
                errorLabel.moveTo(this.myPreferredSize.get().getX() / (double)2, y2);
                this.getRootGroup().children().add(errorLabel.getRootGroup());
                y2 += 16.0;
            }
        }
    }

    private final void buildPlot() {
        this.getRootGroup().addClass("plt-plot");
        this.buildPlotComponents();
        this.reg(this.myPreferredSize.addHandler((EventHandler<PropertyChangeEvent<DoubleVector>>)new EventHandler<PropertyChangeEvent<? extends DoubleVector>>(this){
            final /* synthetic */ Plot this$0;

            public void onEvent(@NotNull PropertyChangeEvent<? extends DoubleVector> event) {
                DoubleVector newValue2;
                Intrinsics.checkNotNullParameter(event, (String)"event");
                DoubleVector doubleVector = newValue2 = event.getNewValue();
                Intrinsics.checkNotNull((Object)doubleVector);
                if (doubleVector.getX() > 0.0 && newValue2.getY() > 0.0) {
                    Plot.access$rebuildPlot(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
            }
        }));
        this.reg(new Registration(this){
            final /* synthetic */ Plot this$0;

            protected void doRemove() {
                Plot.access$getMyTooltipHelper$p(this.this$0).removeAllTileInfos();
                Plot.access$getMyLiveMapFigures$p(this.this$0).clear();
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void rebuildPlot() {
        this.clear();
        this.buildPlot();
    }

    private final PlotTile createTile(DoubleVector tilesOrigin, TileLayoutInfo tileInfo, List<? extends GeomLayer> tileLayers) {
        Scale<Double> xScale = null;
        Scale<Double> yScale = null;
        CoordinateSystem coord = null;
        if (tileInfo.getXAxisInfo() != null && tileInfo.getYAxisInfo() != null) {
            ClosedRange<Double> closedRange = tileInfo.getXAxisInfo().getAxisDomain();
            Intrinsics.checkNotNull(closedRange);
            ClosedRange<Double> xDomain = closedRange;
            double xAxisLength = tileInfo.getXAxisInfo().getAxisLength();
            ClosedRange<Double> closedRange2 = tileInfo.getYAxisInfo().getAxisDomain();
            Intrinsics.checkNotNull(closedRange2);
            ClosedRange<Double> yDomain = closedRange2;
            double yAxisLength = tileInfo.getYAxisInfo().getAxisLength();
            CoordProvider coordProvider = this.getCoordProvider();
            Scale<Double> scale = this.getScaleXProto();
            GuideBreaks guideBreaks = tileInfo.getXAxisInfo().getAxisBreaks();
            Intrinsics.checkNotNull((Object)guideBreaks);
            xScale = coordProvider.buildAxisScaleX(scale, xDomain, xAxisLength, guideBreaks);
            CoordProvider coordProvider2 = this.getCoordProvider();
            Scale<Double> scale2 = this.getScaleYProto();
            GuideBreaks guideBreaks2 = tileInfo.getYAxisInfo().getAxisBreaks();
            Intrinsics.checkNotNull((Object)guideBreaks2);
            yScale = coordProvider2.buildAxisScaleY(scale2, yDomain, yAxisLength, guideBreaks2);
            coord = this.getCoordProvider().createCoordinateSystem(xDomain, xAxisLength, yDomain, yAxisLength);
        } else {
            xScale = new BogusScale();
            yScale = new BogusScale();
            coord = new BogusCoordinateSystem();
        }
        PlotTile tile2 = new PlotTile(tileLayers, xScale, yScale, tilesOrigin, tileInfo, coord, this.theme);
        tile2.setShowAxis(this.isAxisEnabled());
        tile2.debugDrawing().set(false);
        return tile2;
    }

    private final void createAxisTitle(String text, Orientation orientation, DoubleRectangle plotBounds, DoubleRectangle geomBounds) {
        TextLabel.VerticalAnchor verticalAnchor;
        TextLabel.HorizontalAnchor horizontalAnchor = TextLabel.HorizontalAnchor.MIDDLE;
        switch (Plot$WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                verticalAnchor = TextLabel.VerticalAnchor.TOP;
                break;
            }
            case 4: {
                verticalAnchor = TextLabel.VerticalAnchor.BOTTOM;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextLabel.VerticalAnchor verticalAnchor2 = verticalAnchor;
        DoubleVector titleLocation = null;
        double rotation = 0.0;
        switch (Plot$WhenMappings.$EnumSwitchMapping$1[orientation.ordinal()]) {
            case 1: {
                titleLocation = new DoubleVector(plotBounds.getLeft() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN(), geomBounds.getCenter().getY());
                rotation = -90.0;
                break;
            }
            case 2: {
                titleLocation = new DoubleVector(plotBounds.getRight() - PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN(), geomBounds.getCenter().getY());
                rotation = 90.0;
                break;
            }
            case 3: {
                titleLocation = new DoubleVector(geomBounds.getCenter().getX(), plotBounds.getTop() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN());
                break;
            }
            case 4: {
                titleLocation = new DoubleVector(geomBounds.getCenter().getX(), plotBounds.getBottom() - PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        TextLabel titleLabel = new TextLabel(text);
        titleLabel.setHorizontalAnchor(horizontalAnchor);
        titleLabel.setVerticalAnchor(verticalAnchor2);
        titleLabel.moveTo(titleLocation);
        titleLabel.rotate(rotation);
        SvgGElement titleElement = titleLabel.getRootGroup();
        titleElement.addClass("plt-axis-title");
        SvgGElement parent = new SvgGElement();
        parent.addClass("plt-axis");
        parent.children().add(titleElement);
        this.add(parent);
    }

    private final void onMouseMove(SvgElement e, String message) {
        e.addEventHandler(SvgEventSpec.MOUSE_MOVE, new SvgEventHandler<Event>(message){
            final /* synthetic */ String $message;

            public void handle(@NotNull SvgNode node, @NotNull Event e) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$message;
                boolean bl = false;
                System.out.println((Object)string);
            }
            {
                this.$message = $captured_local_variable$0;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPlotComponents() {
        DoubleVector preferredSize = this.myPreferredSize.get();
        DoubleRectangle entirePlot = new DoubleRectangle(DoubleVector.Companion.getZERO(), preferredSize);
        if (this.hasLiveMap()) {
            entirePlot = PlotLayoutUtil.INSTANCE.liveMapBounds(entirePlot.getOrigin(), entirePlot.getDimension());
        }
        DoubleRectangle withoutTitle = entirePlot;
        if (this.hasTitle()) {
            DoubleVector titleSize = PlotLayoutUtil.INSTANCE.titleDimensions(this.getTitle());
            DoubleVector origin = entirePlot.getOrigin().add(new DoubleVector(0.0, titleSize.getY()));
            withoutTitle = new DoubleRectangle(origin, entirePlot.getDimension().subtract(new DoubleVector(0.0, titleSize.getY())));
            TextLabel titleLabel = new TextLabel(this.getTitle());
            titleLabel.addClassName("plt-plot-title");
            titleLabel.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
            titleLabel.setVerticalAnchor(TextLabel.VerticalAnchor.CENTER);
            DoubleRectangle titleBounds = PlotLayoutUtil.INSTANCE.titleBounds(titleSize, preferredSize);
            titleLabel.moveTo(titleBounds.getCenter());
            this.add(titleLabel);
        }
        LegendBoxesLayout.Result boxesLayoutResult = null;
        LegendTheme legendTheme = this.theme.legend();
        DoubleRectangle withoutTitleAndLegends = withoutTitle;
        if (legendTheme.position().isFixed()) {
            LegendBoxesLayout legendBoxesLayout = new LegendBoxesLayout(withoutTitle, legendTheme);
            boxesLayoutResult = legendBoxesLayout.doLayout(this.getLegendBoxInfos());
            withoutTitleAndLegends = boxesLayoutResult.getPlotInnerBoundsWithoutLegendBoxes();
        }
        DoubleRectangle geomAndAxis = withoutTitleAndLegends;
        if (this.isAxisEnabled()) {
            double thickness;
            DoubleVector titleSize;
            if (this.hasAxisTitleLeft()) {
                titleSize = PlotLayoutUtil.INSTANCE.axisTitleDimensions(this.getAxisTitleLeft());
                thickness = titleSize.getY() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_INNER_MARGIN();
                geomAndAxis = new DoubleRectangle(geomAndAxis.getLeft() + thickness, geomAndAxis.getTop(), geomAndAxis.getWidth() - thickness, geomAndAxis.getHeight());
            }
            if (this.hasAxisTitleBottom()) {
                titleSize = PlotLayoutUtil.INSTANCE.axisTitleDimensions(this.getAxisTitleBottom());
                thickness = titleSize.getY() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_OUTER_MARGIN() + PlotLayoutUtil.INSTANCE.getAXIS_TITLE_INNER_MARGIN();
                geomAndAxis = new DoubleRectangle(geomAndAxis.getLeft(), geomAndAxis.getTop(), geomAndAxis.getWidth(), geomAndAxis.getHeight() - thickness);
            }
        }
        PlotLayout plotLayout = this.plotLayout();
        PlotLayoutInfo plotInfo = plotLayout.doLayout(geomAndAxis.getDimension());
        this.myLaidOutSize.set(preferredSize);
        if (plotInfo.getTiles().isEmpty()) {
            return;
        }
        DoubleRectangle geomAreaBounds = PlotLayoutUtil.INSTANCE.absoluteGeomBounds(geomAndAxis.getOrigin(), plotInfo);
        if (legendTheme.position().isOverlay()) {
            LegendBoxesLayout legendBoxesLayout = new LegendBoxesLayout(geomAreaBounds, legendTheme);
            boxesLayoutResult = legendBoxesLayout.doLayout(this.getLegendBoxInfos());
        }
        DoubleVector tilesOrigin = geomAndAxis.getOrigin();
        int n = 0;
        int n2 = ((Collection)plotInfo.getTiles()).size();
        while (n < n2) {
            void i;
            TileLayoutInfo tileInfo = plotInfo.getTiles().get((int)i);
            PlotTile tile2 = this.createTile(tilesOrigin, tileInfo, this.tileLayers((int)i));
            tile2.moveTo(tilesOrigin.add(tileInfo.getPlotOffset()));
            this.add(tile2);
            if (tile2.getLiveMapFigure() != null) {
                SomeFig someFig;
                ArrayList<SomeFig> arrayList = this.myLiveMapFigures;
                boolean bl = false;
                boolean bl2 = false;
                SomeFig p1 = someFig;
                boolean bl3 = false;
                arrayList.add(p1);
            }
            DoubleRectangle realGeomBounds = tileInfo.getGeomBounds().add(tilesOrigin.add(tileInfo.getPlotOffset()));
            this.myTooltipHelper.addTileInfo(realGeomBounds, tile2.getTargetLocators(), this.getTooltipAnchor() != null);
            ++i;
        }
        if (this.isAxisEnabled()) {
            if (this.hasAxisTitleLeft()) {
                this.createAxisTitle(this.getAxisTitleLeft(), Orientation.LEFT, withoutTitleAndLegends, geomAreaBounds);
            }
            if (this.hasAxisTitleBottom()) {
                this.createAxisTitle(this.getAxisTitleBottom(), Orientation.BOTTOM, withoutTitleAndLegends, geomAreaBounds);
            }
        }
        if (boxesLayoutResult != null) {
            for (LegendBoxesLayout.BoxWithLocation boxWithLocation : boxesLayoutResult.getBoxWithLocationList()) {
                LegendBox legendBox = boxWithLocation.getLegendBox().createLegendBox();
                legendBox.moveTo(boxWithLocation.getLocation());
                this.add(legendBox);
            }
        }
    }

    @NotNull
    public final List<TooltipSpec> createTooltipSpecs(@NotNull DoubleVector plotCoord) {
        Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
        return this.myTooltipHelper.createTooltipSpecs(plotCoord);
    }

    @Nullable
    public final DoubleRectangle getGeomBounds(@NotNull DoubleVector plotCoord) {
        Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
        return this.myTooltipHelper.getGeomBounds(plotCoord);
    }

    public Plot(@NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.theme = theme;
        this.myPreferredSize = new ValueProperty<DoubleVector>(DEF_PLOT_SIZE);
        this.myLaidOutSize = new ValueProperty<DoubleVector>(DoubleVector.Companion.getZERO());
        this.myTooltipHelper = new PlotTooltipHelper();
        this.myLiveMapFigures = new ArrayList();
        this.mouseEventPeer = new MouseEventPeer();
    }

    static {
        Companion = new Companion(null);
        LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(Plot.class));
        DEF_PLOT_SIZE = new DoubleVector(600.0, 400.0);
    }

    public static final /* synthetic */ void access$rebuildPlot(Plot $this) {
        $this.rebuildPlot();
    }

    public static final /* synthetic */ PlotTooltipHelper access$getMyTooltipHelper$p(Plot $this) {
        return $this.myTooltipHelper;
    }

    public static final /* synthetic */ ArrayList access$getMyLiveMapFigures$p(Plot $this) {
        return $this.myLiveMapFigures;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/Plot$Companion;", "", "()V", "DEBUG_DRAWING", "", "DEF_PLOT_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

