/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.ContinuedFraction;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J,\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J,\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/Gamma;", "", "()V", "C_LIMIT", "", "DEFAULT_EPSILON", "GAMMA", "getGAMMA", "()D", "HALF_LOG_2_PI", "LANCZOS", "", "S_LIMIT", "digamma", "x", "logGamma", "regularizedGammaP", "a", "epsilon", "maxIterations", "", "regularizedGammaQ", "trigamma", "plot-base-portable"})
public final class Gamma {
    private static final double GAMMA;
    private static final double DEFAULT_EPSILON;
    private static final double[] LANCZOS;
    private static final double HALF_LOG_2_PI;
    private static final double C_LIMIT;
    private static final double S_LIMIT;
    public static final Gamma INSTANCE;

    public final double getGAMMA() {
        return GAMMA;
    }

    /*
     * WARNING - void declaration
     */
    public final double logGamma(double x2) {
        double ret = 0.0;
        double d = x2;
        boolean bl = false;
        if (Double.isNaN(d) || x2 <= 0.0) {
            ret = Double.NaN;
        } else {
            double g = 4.7421875;
            double sum = 0.0;
            int n = LANCZOS.length - 1;
            int n2 = 1;
            while (n >= n2) {
                void i;
                sum += LANCZOS[i] / (x2 + (double)i);
                --i;
            }
            double tmp = x2 + g + 0.5;
            boolean bl2 = false;
            double d2 = (sum += LANCZOS[0]) / x2;
            boolean bl3 = false;
            ret = (x2 + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log(d2);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final double regularizedGammaP(double a, double x2, double epsilon, int maxIterations) {
        boolean bl;
        double d;
        double an;
        double ret = 0.0;
        double d2 = a;
        boolean bl2 = false;
        if (Double.isNaN(d2)) return Double.NaN;
        d2 = x2;
        bl2 = false;
        if (Double.isNaN(d2)) return Double.NaN;
        if (a <= 0.0) return Double.NaN;
        if (x2 < 0.0) {
            return Double.NaN;
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 >= a + 1.0) {
            return 1.0 - this.regularizedGammaQ(a, x2, epsilon, maxIterations);
        }
        double n = 0.0;
        double sum = an = 1.0 / a;
        while (true) {
            d = an / sum;
            bl = false;
            if (!(Math.abs(d) > epsilon) || !(n < (double)maxIterations) || !(sum < Double.POSITIVE_INFINITY)) break;
            sum += (an *= x2 / (a + (n += 1.0)));
        }
        if (n >= (double)maxIterations) {
            String string = "MaxCountExceeded - maxIterations: " + maxIterations;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        d = sum;
        bl = false;
        if (Double.isInfinite(d)) {
            return 1.0;
        }
        boolean bl4 = false;
        double d3 = -x2 + a * Math.log(x2) - this.logGamma(a);
        bl = false;
        return Math.exp(d3) * sum;
    }

    public static /* synthetic */ double regularizedGammaP$default(Gamma gamma, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d3 = DEFAULT_EPSILON;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return gamma.regularizedGammaP(d, d2, d3, n);
    }

    @JvmOverloads
    public final double regularizedGammaP(double a, double x2, double epsilon) {
        return Gamma.regularizedGammaP$default(this, a, x2, epsilon, 0, 8, null);
    }

    @JvmOverloads
    public final double regularizedGammaP(double a, double x2) {
        return Gamma.regularizedGammaP$default(this, a, x2, 0.0, 0, 12, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final double regularizedGammaQ(double a, double x2, double epsilon, int maxIterations) {
        double ret = 0.0;
        double d = a;
        boolean bl = false;
        if (Double.isNaN(d)) return Double.NaN;
        d = x2;
        bl = false;
        if (Double.isNaN(d)) return Double.NaN;
        if (a <= 0.0) return Double.NaN;
        if (x2 < 0.0) {
            return Double.NaN;
        }
        if (x2 == 0.0) {
            return 1.0;
        }
        if (x2 < a + 1.0) {
            return 1.0 - this.regularizedGammaP(a, x2, epsilon, maxIterations);
        }
        ContinuedFraction cf2 = new ContinuedFraction(a){
            final /* synthetic */ double $a;

            protected double getA(int n, double x2) {
                return 2.0 * (double)n + 1.0 - this.$a + x2;
            }

            protected double getB(int n, double x2) {
                return (double)n * (this.$a - (double)n);
            }
            {
                this.$a = $captured_local_variable$0;
            }
        };
        ret = 1.0 / cf2.evaluate(x2, epsilon, maxIterations);
        boolean bl2 = false;
        double d2 = -x2 + a * Math.log(x2) - this.logGamma(a);
        boolean bl3 = false;
        return Math.exp(d2) * ret;
    }

    public static /* synthetic */ double regularizedGammaQ$default(Gamma gamma, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d3 = DEFAULT_EPSILON;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return gamma.regularizedGammaQ(d, d2, d3, n);
    }

    @JvmOverloads
    public final double regularizedGammaQ(double a, double x2, double epsilon) {
        return Gamma.regularizedGammaQ$default(this, a, x2, epsilon, 0, 8, null);
    }

    @JvmOverloads
    public final double regularizedGammaQ(double a, double x2) {
        return Gamma.regularizedGammaQ$default(this, a, x2, 0.0, 0, 12, null);
    }

    public final double digamma(double x2) {
        if (x2 > 0.0 && x2 <= S_LIMIT) {
            return -GAMMA - 1.0 / x2;
        }
        if (x2 >= C_LIMIT) {
            double inv = 1.0 / (x2 * x2);
            boolean bl = false;
            return Math.log(x2) - 0.5 / x2 - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / (double)252));
        }
        return this.digamma(x2 + 1.0) - 1.0 / x2;
    }

    public final double trigamma(double x2) {
        if (x2 > 0.0 && x2 <= S_LIMIT) {
            return 1.0 / (x2 * x2);
        }
        if (x2 >= C_LIMIT) {
            double inv = 1.0 / (x2 * x2);
            return 1.0 / x2 + inv / (double)2 + inv / x2 * (0.16666666666666666 - inv * (0.03333333333333333 + inv / (double)42));
        }
        return this.trigamma(x2 + 1.0) + 1.0 / (x2 * x2);
    }

    private Gamma() {
    }

    static {
        Gamma gamma;
        INSTANCE = gamma = new Gamma();
        GAMMA = 0.5772156649015329;
        DEFAULT_EPSILON = 1.0E-14;
        LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        double d = Math.PI * 2;
        boolean bl = false;
        HALF_LOG_2_PI = 0.5 * Math.log(d);
        C_LIMIT = 49.0;
        S_LIMIT = 1.0E-5;
    }
}

