/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0003%&'B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\nH\u0016J\u0012\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019H\u0016J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "()V", "myAdjust", "", "myBandWidth", "Ljava/lang/Double;", "myBandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "myKernel", "Lkotlin/Function1;", "myN", "", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "setAdjust", "adjust", "setBandWidth", "bw", "setBandWidthMethod", "setKernel", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "setN", "n", "BandWidthMethod", "Companion", "Kernel", "plot-base-portable"})
public final class DensityStat
extends BaseStat {
    private double myAdjust = 1.0;
    private int myN = 512;
    private BandWidthMethod myBandWidthMethod = BandWidthMethod.NRD0;
    private Double myBandWidth;
    private Function1<? super Double, Double> myKernel = DensityStatUtil.INSTANCE.kernel(Kernel.GAUSSIAN);
    @NotNull
    public static final String DEF_KERNEL = "gaussian";
    public static final double DEF_ADJUST = 1.0;
    public static final int DEF_N = 512;
    @NotNull
    public static final String DEF_BW = "nrd0";
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    private static final int MAX_N = 9999;
    public static final Companion Companion;

    public final void setKernel(@NotNull Kernel kernel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        this.myKernel = DensityStatUtil.INSTANCE.kernel(kernel2);
    }

    public final void setAdjust(double adjust) {
        this.myAdjust = adjust;
    }

    public final void setN(int n) {
        if (n > 9999) {
            throw (Throwable)new IllegalArgumentException("The input n " + n + " > " + 9999 + "is too large!");
        }
        this.myN = n;
    }

    public final void setBandWidthMethod(@NotNull BandWidthMethod bw) {
        Intrinsics.checkNotNullParameter((Object)((Object)bw), (String)"bw");
        this.myBandWidthMethod = bw;
        this.myBandWidth = null;
    }

    public final void setBandWidth(double bw) {
        this.myBandWidth = bw;
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf((Object[])new Aes[]{Aes.Companion.getX(), Aes.Companion.getWEIGHT()});
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!this.hasRequiredValues(data, Aes.Companion.getX())) {
            return this.withEmptyStatValues();
        }
        List<Double> valuesX = data.getNumeric(TransformVar.INSTANCE.getX());
        ClosedRange<Double> closedRange = statCtx.overallXRange();
        Intrinsics.checkNotNull(closedRange);
        List<Double> statX = DensityStatUtil.INSTANCE.createStepValues(closedRange, this.myN);
        ArrayList<Double> statDensity = new ArrayList<Double>();
        ArrayList<Double> statCount = new ArrayList<Double>();
        ArrayList<Double> statScaled = new ArrayList<Double>();
        List<Double> weight = BinStatUtil.INSTANCE.weightVector(valuesX.size(), data);
        double bandWidth = 0.0;
        Function1<Double, Double> densityFunction2 = null;
        Double d = this.myBandWidth;
        bandWidth = d != null ? d.doubleValue() : DensityStatUtil.INSTANCE.bandWidth(this.myBandWidthMethod, valuesX);
        densityFunction2 = DensityStatUtil.INSTANCE.densityFunction$plot_base_portable(valuesX, this.myKernel, bandWidth, this.myAdjust, weight);
        Iterator<Double> iterator2 = statX.iterator();
        while (iterator2.hasNext()) {
            double x2 = ((Number)iterator2.next()).doubleValue();
            double d2 = ((Number)densityFunction2.invoke((Object)x2)).doubleValue();
            statCount.add(d2);
            statDensity.add(d2 / SeriesUtil.INSTANCE.sum(weight));
        }
        Double d3 = CollectionsKt.max((Iterable)statCount);
        Intrinsics.checkNotNull((Object)d3);
        double maxm = d3;
        for (Double d4 : statCount) {
            statScaled.add(d4 / maxm);
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity).putNumeric(Stats.INSTANCE.getCOUNT(), (List<Double>)statCount).putNumeric(Stats.INSTANCE.getSCALED(), (List<Double>)statScaled).build();
    }

    public DensityStat() {
        super(DEF_MAPPING);
    }

    static {
        Companion = new Companion(null);
        DEF_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getDENSITY())});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "", "(Ljava/lang/String;I)V", "GAUSSIAN", "RECTANGULAR", "TRIANGULAR", "BIWEIGHT", "EPANECHNIKOV", "OPTCOSINE", "COSINE", "plot-base-portable"})
    public static final class Kernel
    extends Enum<Kernel> {
        public static final /* enum */ Kernel GAUSSIAN;
        public static final /* enum */ Kernel RECTANGULAR;
        public static final /* enum */ Kernel TRIANGULAR;
        public static final /* enum */ Kernel BIWEIGHT;
        public static final /* enum */ Kernel EPANECHNIKOV;
        public static final /* enum */ Kernel OPTCOSINE;
        public static final /* enum */ Kernel COSINE;
        private static final /* synthetic */ Kernel[] $VALUES;

        static {
            Kernel[] kernelArray = new Kernel[7];
            Kernel[] kernelArray2 = kernelArray;
            kernelArray[0] = GAUSSIAN = new Kernel();
            kernelArray[1] = RECTANGULAR = new Kernel();
            kernelArray[2] = TRIANGULAR = new Kernel();
            kernelArray[3] = BIWEIGHT = new Kernel();
            kernelArray[4] = EPANECHNIKOV = new Kernel();
            kernelArray[5] = OPTCOSINE = new Kernel();
            kernelArray[6] = COSINE = new Kernel();
            $VALUES = kernelArray;
        }

        public static Kernel[] values() {
            return (Kernel[])$VALUES.clone();
        }

        public static Kernel valueOf(String string) {
            return Enum.valueOf(Kernel.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "", "(Ljava/lang/String;I)V", "NRD0", "NRD", "plot-base-portable"})
    public static final class BandWidthMethod
    extends Enum<BandWidthMethod> {
        public static final /* enum */ BandWidthMethod NRD0;
        public static final /* enum */ BandWidthMethod NRD;
        private static final /* synthetic */ BandWidthMethod[] $VALUES;

        static {
            BandWidthMethod[] bandWidthMethodArray = new BandWidthMethod[2];
            BandWidthMethod[] bandWidthMethodArray2 = bandWidthMethodArray;
            bandWidthMethodArray[0] = NRD0 = new BandWidthMethod();
            bandWidthMethodArray[1] = NRD = new BandWidthMethod();
            $VALUES = bandWidthMethodArray;
        }

        public static BandWidthMethod[] values() {
            return (BandWidthMethod[])$VALUES.clone();
        }

        public static BandWidthMethod valueOf(String string) {
            return Enum.valueOf(BandWidthMethod.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Companion;", "", "()V", "DEF_ADJUST", "", "DEF_BW", "", "DEF_KERNEL", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_N", "", "MAX_N", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

