/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.stat.ContourFillHelper;
import jetbrains.datalore.plot.base.stat.ContourFillHelper$WhenMappings;
import jetbrains.datalore.plot.base.stat.ContourStatUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006JJ\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J6\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00112\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002JT\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u00112\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u000e0\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper;", "", "xRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "yRange", "(Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;)V", "myLowLeft", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myLowRight", "myUpLeft", "myUpRight", "createClosedPolygonLevels", "", "", "openLevels", "outerMap", "", "cornerPoints", "createOuterMap", "paths", "createPolygons", "pathByLevels", "levels", "fillLevels", "getKind", "Ljetbrains/datalore/plot/base/stat/ContourFillHelper$BorderKind;", "point", "BorderKind", "Companion", "plot-base-portable"})
public final class ContourFillHelper {
    private final DoubleVector myLowLeft;
    private final DoubleVector myLowRight;
    private final DoubleVector myUpLeft;
    private final DoubleVector myUpRight;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Double, List<DoubleVector>> createPolygons(@NotNull Map<Double, ? extends List<? extends List<DoubleVector>>> pathByLevels, @NotNull List<Double> levels, @NotNull List<Double> fillLevels) {
        Intrinsics.checkNotNullParameter(pathByLevels, (String)"pathByLevels");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter(fillLevels, (String)"fillLevels");
        HashMap result = new HashMap();
        ArrayList allPaths = new ArrayList();
        for (List<? extends List<DoubleVector>> list2 : pathByLevels.values()) {
            allPaths.addAll(list2);
        }
        ArrayList arrayList = new ArrayList();
        Map<DoubleVector, DoubleVector> outerMap = this.createOuterMap(allPaths, arrayList);
        int n = pathByLevels.keySet().size();
        int n2 = 0;
        int n3 = n + 1;
        while (n2 < n3) {
            void i;
            List<List<DoubleVector>> polygonPieces = new ArrayList();
            ArrayList value = new ArrayList();
            if (i > 0) {
                List<? extends List<DoubleVector>> list3 = pathByLevels.get(levels.get((int)(i - true)));
                Intrinsics.checkNotNull(list3);
                polygonPieces.addAll(ContourFillHelper.Companion.reverseAll(list3));
            }
            if (i < n) {
                List<? extends List<DoubleVector>> list4 = pathByLevels.get(levels.get((int)i));
                Intrinsics.checkNotNull(list4);
                polygonPieces.addAll((Collection<List<DoubleVector>>)list4);
            }
            polygonPieces = this.createClosedPolygonLevels((List<? extends List<DoubleVector>>)polygonPieces, outerMap, arrayList);
            for (List<DoubleVector> path2 : polygonPieces) {
                value.addAll(path2);
            }
            ((Map)result).put(fillLevels.get((int)i), value);
            ++i;
        }
        return result;
    }

    private final List<List<DoubleVector>> createClosedPolygonLevels(List<? extends List<DoubleVector>> openLevels, Map<DoubleVector, DoubleVector> outerMap, List<DoubleVector> cornerPoints) {
        DoubleVector p1;
        DoubleVector p0;
        ArrayList<List> result = new ArrayList<List>();
        HashSet donePath = new HashSet();
        for (List<DoubleVector> list2 : openLevels) {
            DoubleVector pi2;
            ArrayList<DoubleVector> levelCopy = new ArrayList<DoubleVector>((Collection)list2);
            p0 = (DoubleVector)levelCopy.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(p1 = (DoubleVector)levelCopy.get(levelCopy.size() - 1)))) {
                result.add(levelCopy);
                continue;
            }
            Intrinsics.checkNotNull((Object)outerMap.get(p1));
            levelCopy.add(pi2);
            p1 = pi2;
            while (cornerPoints.contains(p1)) {
                Intrinsics.checkNotNull((Object)outerMap.get(p1));
                levelCopy.add(pi2);
                p1 = pi2;
            }
            donePath.add(levelCopy);
        }
        HashMap hashMap = new HashMap();
        for (List list3 : donePath) {
            p0 = (DoubleVector)list3.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(p1 = (DoubleVector)list3.get(list3.size() - 1)))) {
                result.add(list3);
                continue;
            }
            if (hashMap.containsKey(p0) || hashMap.containsKey(p1)) {
                List path0 = (List)hashMap.get(p0);
                List path1 = (List)hashMap.get(p1);
                ContourStatUtil.INSTANCE.removePathByEndpoints$plot_base_portable(path0, hashMap);
                ContourStatUtil.INSTANCE.removePathByEndpoints$plot_base_portable(path1, hashMap);
                List longPath = null;
                if (path0 == path1) {
                    List list4 = path0;
                    Intrinsics.checkNotNull((Object)list4);
                    list4.addAll(list3.subList(1, list3.size()));
                    result.add(path0);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath = path0;
                    longPath.addAll(list3.subList(1, list3.size() - 1));
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list5 = path1;
                    Intrinsics.checkNotNull((Object)list5);
                    longPath = list5;
                    longPath.addAll(0, list3.subList(0, list3.size() - 1));
                } else {
                    longPath = path0;
                    longPath.addAll(list3.subList(1, list3.size()));
                }
                ((Map)hashMap).put(longPath.get(0), longPath);
                ((Map)hashMap).put(longPath.get(longPath.size() - 1), longPath);
                continue;
            }
            Map map2 = hashMap;
            Object e = list3.get(0);
            List list6 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"path");
            map2.put(e, list6);
            ((Map)hashMap).put(list3.get(list3.size() - 1), list3);
        }
        if (!hashMap.keySet().isEmpty()) {
            throw (Throwable)new IllegalArgumentException("Some paths are not cleared yet there is something wrong!" + hashMap.keySet().size());
        }
        for (List list7 : result) {
            if (!(Intrinsics.areEqual((Object)((DoubleVector)list7.get(0)), (Object)((DoubleVector)list7.get(list7.size() - 1))) ^ true)) continue;
            throw (Throwable)new IllegalArgumentException("The polygons are not entirely closed!");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DoubleVector, DoubleVector> createOuterMap(List<? extends List<DoubleVector>> paths, List<DoubleVector> cornerPoints) {
        ArrayList<DoubleVector> points2 = new ArrayList<DoubleVector>();
        for (List<DoubleVector> list2 : paths) {
            if (!(Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1)) ^ true)) continue;
            points2.add(list2.get(0));
            points2.add(list2.get(list2.size() - 1));
        }
        HashMap hashMap = new HashMap();
        ArrayList list2 = new ArrayList();
        int n = 0;
        int iterator2 = 3;
        while (n <= iterator2) {
            void i;
            list2.add(new ArrayList());
            ++i;
        }
        Iterator n3 = points2.iterator();
        while (n3.hasNext()) {
            DoubleVector point2;
            DoubleVector doubleVector = point2 = (DoubleVector)n3.next();
            Intrinsics.checkNotNullExpressionValue((Object)doubleVector, (String)"point");
            BorderKind kind = this.getKind(doubleVector);
            switch (ContourFillHelper$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    ((List)list2.get(0)).add(point2);
                    break;
                }
                case 2: {
                    ((List)list2.get(1)).add(point2);
                    break;
                }
                case 3: {
                    ((List)list2.get(2)).add(point2);
                    break;
                }
                case 4: {
                    ((List)list2.get(3)).add(point2);
                    break;
                }
            }
        }
        Object e = list2.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"list[0]");
        CollectionsKt.sortWith((List)((List)e), (Comparator)createOuterMap.1.INSTANCE);
        Object e2 = list2.get(1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"list[1]");
        CollectionsKt.sortWith((List)((List)e2), (Comparator)createOuterMap.2.INSTANCE);
        Object e3 = list2.get(2);
        Intrinsics.checkNotNullExpressionValue(e3, (String)"list[2]");
        CollectionsKt.sortWith((List)((List)e3), (Comparator)createOuterMap.3.INSTANCE);
        Object e4 = list2.get(3);
        Intrinsics.checkNotNullExpressionValue(e4, (String)"list[3]");
        CollectionsKt.sortWith((List)((List)e4), (Comparator)createOuterMap.4.INSTANCE);
        ArrayList<DoubleVector> prepareMap = new ArrayList<DoubleVector>();
        if (!((List)list2.get(0)).contains(this.myLowLeft)) {
            prepareMap.add(this.myLowLeft);
            cornerPoints.add(this.myLowLeft);
        }
        prepareMap.addAll((Collection)list2.get(0));
        if (!((List)list2.get(0)).contains(this.myLowRight)) {
            prepareMap.add(this.myLowRight);
            cornerPoints.add(this.myLowRight);
        }
        prepareMap.addAll((Collection)list2.get(1));
        if (!((List)list2.get(1)).contains(this.myUpRight)) {
            prepareMap.add(this.myUpRight);
            cornerPoints.add(this.myUpRight);
        }
        prepareMap.addAll((Collection)list2.get(2));
        if (!((List)list2.get(3)).contains(this.myUpLeft)) {
            prepareMap.add(this.myUpLeft);
            cornerPoints.add(this.myUpLeft);
        }
        prepareMap.addAll((Collection)list2.get(3));
        prepareMap.add((DoubleVector)prepareMap.get(0));
        int n2 = 0;
        int n4 = prepareMap.size() - 1;
        while (n2 < n4) {
            void i;
            Map map2 = hashMap;
            Object e5 = prepareMap.get((int)i);
            Intrinsics.checkNotNullExpressionValue(e5, (String)"prepareMap[i]");
            Object e6 = prepareMap.get((int)(i + true));
            Intrinsics.checkNotNullExpressionValue(e6, (String)"prepareMap[i + 1]");
            map2.put(e5, e6);
            ++i;
        }
        return hashMap;
    }

    private final BorderKind getKind(DoubleVector point2) {
        BorderKind borderKind;
        if (ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point2) && ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point2)) {
            borderKind = BorderKind.DOWN;
        } else if (ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point2) && !ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point2)) {
            borderKind = BorderKind.RIGHT;
        } else if (!ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point2) && !ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point2)) {
            borderKind = BorderKind.UP;
        } else if (!ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point2) && ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point2)) {
            borderKind = BorderKind.LEFT;
        } else {
            throw (Throwable)new IllegalArgumentException("The Contour Point is not on the border " + point2);
        }
        return borderKind;
    }

    public ContourFillHelper(@NotNull ClosedRange<Double> xRange, @NotNull ClosedRange<Double> yRange) {
        Intrinsics.checkNotNullParameter(xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter(yRange, (String)"yRange");
        double xMin = ((Number)xRange.getLowerEnd()).doubleValue();
        double xMax = ((Number)xRange.getUpperEnd()).doubleValue();
        double yMin = ((Number)yRange.getLowerEnd()).doubleValue();
        double yMax = ((Number)yRange.getUpperEnd()).doubleValue();
        this.myLowLeft = new DoubleVector(xMin, yMin);
        this.myLowRight = new DoubleVector(xMax, yMin);
        this.myUpLeft = new DoubleVector(xMin, yMax);
        this.myUpRight = new DoubleVector(xMax, yMax);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper$BorderKind;", "", "(Ljava/lang/String;I)V", "DOWN", "RIGHT", "UP", "LEFT", "plot-base-portable"})
    private static final class BorderKind
    extends Enum<BorderKind> {
        public static final /* enum */ BorderKind DOWN;
        public static final /* enum */ BorderKind RIGHT;
        public static final /* enum */ BorderKind UP;
        public static final /* enum */ BorderKind LEFT;
        private static final /* synthetic */ BorderKind[] $VALUES;

        static {
            BorderKind[] borderKindArray = new BorderKind[4];
            BorderKind[] borderKindArray2 = borderKindArray;
            borderKindArray[0] = DOWN = new BorderKind();
            borderKindArray[1] = RIGHT = new BorderKind();
            borderKindArray[2] = UP = new BorderKind();
            borderKindArray[3] = LEFT = new BorderKind();
            $VALUES = borderKindArray;
        }

        public static BorderKind[] values() {
            return (BorderKind[])$VALUES.clone();
        }

        public static BorderKind valueOf(String string) {
            return Enum.valueOf(BorderKind.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ.\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\n0\n\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\n0\nH\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper$Companion;", "", "()V", "belowOrOnLine", "", "a", "Ljetbrains/datalore/base/geometry/DoubleVector;", "b", "test", "computeFillLevels", "", "", "zRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "levels", "reverseAll", "E", "list", "plot-base-portable"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Double> computeFillLevels(@NotNull ClosedRange<Double> zRange, @NotNull List<Double> levels) {
            Intrinsics.checkNotNullParameter(zRange, (String)"zRange");
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            ArrayList<Double> fillLevels = new ArrayList<Double>();
            fillLevels.add(zRange.getLowerEnd());
            int n = 0;
            int n2 = levels.size() - 1;
            while (n < n2) {
                void i;
                fillLevels.add((((Number)levels.get((int)i)).doubleValue() + ((Number)levels.get((int)(i + true))).doubleValue()) / 2.0);
                ++i;
            }
            fillLevels.add(zRange.getUpperEnd());
            return fillLevels;
        }

        private final <E> List<List<E>> reverseAll(List<? extends List<? extends E>> list2) {
            ArrayList result = new ArrayList();
            for (List<E> list3 : list2) {
                ArrayList copy = new ArrayList(list3);
                CollectionsKt.reverse((List)copy);
                result.add(copy);
            }
            return result;
        }

        private final boolean belowOrOnLine(DoubleVector a, DoubleVector b, DoubleVector test) {
            DoubleVector value = test.subtract(a);
            DoubleVector standard = b.subtract(a);
            return standard.getY() * value.getX() - value.getY() * standard.getX() >= 0.0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

