/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.breaks.LinearBreaksHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ8\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/ScaleBreaksUtil;", "", "()V", "withBreaks", "Ljetbrains/datalore/plot/base/Scale;", "TargetT", "scale", "scaleDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "breakCount", "", "withLinearBreaks", "plot-base-portable"})
public final class ScaleBreaksUtil {
    public static final ScaleBreaksUtil INSTANCE;

    @NotNull
    public final <TargetT> Scale<TargetT> withBreaks(@NotNull Scale<TargetT> scale, @NotNull ClosedRange<Double> scaleDomain, int breakCount) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter(scaleDomain, (String)"scaleDomain");
        if (scale.hasBreaksGenerator()) {
            ScaleBreaks breaksHelper = scale.getBreaksGenerator().generateBreaks(scaleDomain, breakCount);
            List<Double> breaks = breaksHelper.getDomainValues();
            List<String> labels = breaksHelper.getLabels();
            return scale.with().breaks(breaks).labels(labels).build();
        }
        return this.withLinearBreaks(scale, scaleDomain, breakCount);
    }

    private final <TargetT> Scale<TargetT> withLinearBreaks(Scale<TargetT> scale, ClosedRange<Double> scaleDomain, int breakCount) {
        LinearBreaksHelper breaksHelper = new LinearBreaksHelper(((Number)scaleDomain.getLowerEnd()).doubleValue(), ((Number)scaleDomain.getUpperEnd()).doubleValue(), breakCount);
        List<Double> breaks = breaksHelper.getBreaks();
        ArrayList<Object> labels = new ArrayList<Object>();
        Iterator<Double> iterator2 = breaks.iterator();
        while (iterator2.hasNext()) {
            double br = ((Number)iterator2.next()).doubleValue();
            labels.add(breaksHelper.getLabelFormatter().invoke((Object)br));
        }
        return scale.with().breaks(breaks).labels((List<String>)labels).build();
    }

    private ScaleBreaksUtil() {
    }

    static {
        ScaleBreaksUtil scaleBreaksUtil;
        INSTANCE = scaleBreaksUtil = new ScaleBreaksUtil();
    }
}

