/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.scale.breaks.BreaksHelperBase;
import jetbrains.datalore.plot.base.scale.breaks.QuantitativeTickFormatterFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/LinearBreaksHelper;", "Ljetbrains/datalore/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "(DDI)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "labelFormatter", "Lkotlin/Function1;", "", "", "getLabelFormatter", "()Lkotlin/jvm/functions/Function1;", "plot-base-portable"})
public final class LinearBreaksHelper
extends BreaksHelperBase {
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> labelFormatter;

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @Override
    @NotNull
    public Function1<Object, String> getLabelFormatter() {
        return this.labelFormatter;
    }

    public LinearBreaksHelper(double rangeStart, double rangeEnd, int count2) {
        super(rangeStart, rangeEnd, count2);
        double step = this.getTargetStep();
        double start = this.getNormalStart();
        double end = this.getNormalEnd();
        List ticks = null;
        if (step > 0.0) {
            boolean bl = false;
            double d = Math.log10(step);
            boolean bl2 = false;
            double step10Power = Math.floor(d);
            d = 10.0;
            bl2 = false;
            step = Math.pow(d, step10Power);
            double error = step * (double)count2 / this.getSpan();
            if (error <= 0.15) {
                step *= 10.0;
            } else if (error <= 0.35) {
                step *= 5.0;
            } else if (error <= 0.75) {
                step *= 2.0;
            }
            double delta = step / (double)10000;
            double startE = start - delta;
            double endE = end + delta;
            ticks = new ArrayList();
            double d2 = startE / step;
            boolean bl3 = false;
            double tick = Math.ceil(d2) * step;
            if (start >= 0.0 && startE < 0.0) {
                tick = 0.0;
            }
            while (tick <= endE) {
                boolean bl4 = false;
                tick = Math.min(tick, end);
                ticks.add(tick);
                tick += step;
            }
        } else {
            ticks = CollectionsKt.mutableListOf((Object[])new Double[]{start});
        }
        ClosedRange<Comparable> range2 = new ClosedRange<Comparable>(Double.valueOf(start), Double.valueOf(end));
        this.labelFormatter = QuantitativeTickFormatterFactory.Companion.forLinearScale$default(QuantitativeTickFormatterFactory.Companion, false, 1, null).getFormatter(range2, step);
        if (this.isReversed()) {
            CollectionsKt.reverse((List)ticks);
        }
        this.breaks = ticks;
    }
}

