/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.data.Dummies;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J.\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u001e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00162\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\nJB\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00182\u001c\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u0002H\u0019`\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\u00042\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0004J(\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0013J\u0016\u0010(\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0013J\u001c\u0010)\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130+J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0.J\u001e\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180#2\u0006\u0010%\u001a\u00020\u0004J\u0012\u00100\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0#2\u0006\u0010%\u001a\u00020\u0004\u00a8\u00061"}, d2={"Ljetbrains/datalore/plot/base/data/DataFrameUtil;", "", "()V", "appendReplace", "Ljetbrains/datalore/plot/base/DataFrame;", "df0", "df1", "applyTransform", "data", "var", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "aes", "Ljetbrains/datalore/plot/base/Aes;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "variable", "transformVar", "createVariable", "name", "", "label", "distinctValues", "", "filterTransformSource", "", "T", "rawData", "retain", "Lkotlin/Function1;", "", "Ljetbrains/datalore/base/function/Predicate;", "findVariableOrFail", "varName", "fromMap", "map", "", "getSummaryText", "df", "getTransformSource", "hasVariable", "isNumeric", "removeAllExcept", "keepNames", "", "sortedCopy", "variables", "", "toMap", "transformVarFor", "plot-base-portable"})
public final class DataFrameUtil {
    public static final DataFrameUtil INSTANCE;

    @NotNull
    public final DataFrame.Variable transformVarFor(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return TransformVar.INSTANCE.forAes(aes);
    }

    @NotNull
    public final DataFrame applyTransform(@NotNull DataFrame data, @NotNull DataFrame.Variable var, @NotNull Aes<?> aes, @NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)var, (String)"var");
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        DataFrame.Variable transformVar = this.transformVarFor(aes);
        return this.applyTransform(data, var, transformVar, scale);
    }

    private final DataFrame applyTransform(DataFrame data, DataFrame.Variable variable, DataFrame.Variable transformVar, Scale<?> scale) {
        List<?> transformSource = this.getTransformSource(data, variable, scale);
        List<Double> transformResult = ScaleUtil.INSTANCE.transform(transformSource, scale);
        return data.builder().putNumeric(transformVar, transformResult).build();
    }

    private final List<?> getTransformSource(DataFrame data, DataFrame.Variable variable, Scale<?> scale) {
        if (!scale.hasDomainLimits()) {
            return data.get(variable);
        }
        return this.filterTransformSource(data.get(variable), (Function1)new Function1<Object, Boolean>(scale){
            final /* synthetic */ Scale $scale;

            public final boolean invoke(@Nullable Object input) {
                return input == null || this.$scale.isInDomainLimits(input);
            }
            {
                this.$scale = scale;
                super(1);
            }
        });
    }

    private final <T> List<T> filterTransformSource(List<? extends T> rawData, Function1<? super T, Boolean> retain) {
        ArrayList<T> result = new ArrayList<T>(rawData.size());
        for (T v : rawData) {
            if (((Boolean)retain.invoke(v)).booleanValue()) {
                result.add(v);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public final boolean hasVariable(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable var : data.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)var.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final DataFrame.Variable findVariableOrFail(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable var : data.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)var.getName())) continue;
            return var;
        }
        throw (Throwable)new IllegalArgumentException("Variable not found: '" + varName + '\'');
    }

    public final boolean isNumeric(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return data.isNumeric(this.findVariableOrFail(data, varName));
    }

    @NotNull
    public final Collection<Object> distinctValues(@NotNull DataFrame data, @NotNull DataFrame.Variable variable) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return data.distinctValues(variable);
    }

    @NotNull
    public final List<DataFrame.Variable> sortedCopy(@NotNull Iterable<DataFrame.Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Ordering ordering2 = Ordering.Companion.from(sortedCopy.ordering.1.INSTANCE);
        return ordering2.sortedCopy(variables);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DataFrame.Variable> variables(@NotNull DataFrame df) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Iterable $this$associateBy$iv = df.variables();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = ((DataFrame.Variable)receiver).getName();
            map2.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final DataFrame appendReplace(@NotNull DataFrame df0, @NotNull DataFrame df1) {
        boolean bl;
        Map<String, DataFrame.Variable> map2;
        boolean bl2;
        String string;
        Map<String, DataFrame.Variable> map3;
        DataFrame.Variable it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)df0, (String)"df0");
        Intrinsics.checkNotNullParameter((Object)df1, (String)"df1");
        appendReplace.1 $fun$put$1 = appendReplace.1.INSTANCE;
        Iterable iterable = df0.variables();
        Object object = new DataFrame.Builder();
        Object object2 = $fun$put$1;
        Object object3 = $fun$put$1;
        appendReplace.1 var18_8 = $fun$put$1;
        boolean $i$f$filter = false;
        void var6_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl3 = false;
            map3 = INSTANCE.variables(df1);
            string = it.getName();
            bl2 = false;
            map2 = map3;
            bl = false;
            if (!(!map2.containsKey(string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = df0.variables();
        object2 = object2.invoke((DataFrame.Builder)object, list2, df0);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl4 = false;
            map3 = INSTANCE.variables(df1);
            string = it.getName();
            bl2 = false;
            map2 = map3;
            bl = false;
            if (!map2.containsKey(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = df1.variables();
        object3 = object3.invoke((DataFrame.Builder)object2, (Collection)object, df1);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl5 = false;
            map3 = INSTANCE.variables(df0);
            string = it.getName();
            bl2 = false;
            map2 = map3;
            bl = false;
            if (!(!map2.containsKey(string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object2 = (List)destination$iv$iv;
        return var18_8.invoke((DataFrame.Builder)object3, (Collection)object2, df1).build();
    }

    @NotNull
    public final Map<String, List<?>> toMap(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        HashMap result = new HashMap();
        Set<DataFrame.Variable> variables = df.variables();
        for (DataFrame.Variable var : variables) {
            ((Map)result).put(var.getName(), df.get(var));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame fromMap(@NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        DataFrame.Builder frameBuilder = new DataFrame.Builder();
        Map<Object, Object> map3 = map2;
        boolean bl = false;
        Iterator<Map.Entry<?, ?>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            map3 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            boolean bl3 = key instanceof String;
            StringBuilder stringBuilder = new StringBuilder().append("Map to data-frame: key expected a String but was ");
            void v2 = key;
            Intrinsics.checkNotNull((Object)v2);
            Preconditions.INSTANCE.checkArgument(bl3, stringBuilder.append(Reflection.getOrCreateKotlinClass(v2.getClass()).getSimpleName()).append(" : ").append(key).toString());
            boolean bl4 = key instanceof String;
            StringBuilder stringBuilder2 = new StringBuilder().append("Map to data-frame: value expected a List but was ");
            Object obj = value;
            Intrinsics.checkNotNull(obj);
            Preconditions.INSTANCE.checkArgument(bl4, stringBuilder2.append(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName()).append(" : ").append(value).toString());
            frameBuilder.put(DataFrameUtil.createVariable$default(this, (String)key, null, 2, null), (List)value);
        }
        return frameBuilder.build();
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return TransformVar.INSTANCE.isTransformVar(name) ? TransformVar.INSTANCE.get(name) : (Stats.INSTANCE.isStatVar(name) ? Stats.INSTANCE.statVar(name) : (Dummies.INSTANCE.isDummyVar(name) ? Dummies.INSTANCE.newDummy(name) : new DataFrame.Variable(name, DataFrame.Variable.Source.ORIGIN, label)));
    }

    public static /* synthetic */ DataFrame.Variable createVariable$default(DataFrameUtil dataFrameUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return dataFrameUtil.createVariable(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name) {
        return DataFrameUtil.createVariable$default(this, name, null, 2, null);
    }

    @NotNull
    public final String getSummaryText(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        StringBuilder sb = new StringBuilder();
        for (DataFrame.Variable variable : df.variables()) {
            sb.append(variable.toSummaryString()).append(" numeric: " + df.isNumeric(variable)).append(" size: " + df.get(variable).size()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final DataFrame removeAllExcept(@NotNull DataFrame df, @NotNull Set<String> keepNames) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Intrinsics.checkNotNullParameter(keepNames, (String)"keepNames");
        DataFrame.Builder b = df.builder();
        for (DataFrame.Variable variable : df.variables()) {
            if (keepNames.contains(variable.getName())) continue;
            b.remove(variable);
        }
        return b.build();
    }

    private DataFrameUtil() {
    }

    static {
        DataFrameUtil dataFrameUtil;
        INSTANCE = dataFrameUtil = new DataFrameUtil();
    }
}

