/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002./B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\nH\u0002J$\u0010\u001b\u001a\u00020\u00002\u001a\u0010\u001c\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001dH\u0002J\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\nJ\u0014\u0010 \u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000bJ \u0010#\u001a\u00020$2\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013H\u0002J\u0015\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0019\u001a\u00020\nH\u0086\u0002J\u0016\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00142\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nJ\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\"J\u0014\u0010,\u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0014J\u0014\u0010,\u001a\u00020\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000bJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\u000bR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R2\u0010\b\u001a&\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tj\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a.\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\tj\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ljetbrains/datalore/plot/base/DataFrame;", "", "builder", "Ljetbrains/datalore/plot/base/DataFrame$Builder;", "(Ljetbrains/datalore/plot/base/DataFrame$Builder;)V", "isEmpty", "", "()Z", "myDistinctValues", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "myIsNumeric", "", "myRanges", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "myVectorByVar", "", "", "assertAllSeriesAreSameSize", "", "vectorByVar", "assertDefined", "variable", "assertNumeric", "buildModified", "serieFun", "Lkotlin/Function1;", "distinctValues", "", "dropIndices", "indices", "", "dumpSizes", "", "get", "getNumeric", "has", "hasNoOrEmpty", "isNumeric", "range", "rowCount", "selectIndices", "variables", "Builder", "Variable", "plot-base-portable"})
public final class DataFrame {
    private final Map<Variable, List<?>> myVectorByVar;
    private final Map<Variable, Boolean> myIsNumeric;
    private final HashMap<Variable, ClosedRange<Double>> myRanges = new HashMap();
    private final HashMap<Variable, Set<?>> myDistinctValues = new HashMap();

    public final boolean isEmpty() {
        return this.myVectorByVar.isEmpty();
    }

    private final void assertAllSeriesAreSameSize(Map<Variable, ? extends List<?>> vectorByVar) {
        if (vectorByVar.size() > 1) {
            Iterator<Map.Entry<Variable, List<?>>> entries = vectorByVar.entrySet().iterator();
            Map.Entry<Variable, List<?>> first2 = entries.next();
            int size2 = first2.getValue().size();
            while (entries.hasNext()) {
                Map.Entry<Variable, List<?>> next = entries.next();
                if (next.getValue().size() == size2) continue;
                throw (Throwable)new IllegalArgumentException("All data series in data frame must have equal size\n" + this.dumpSizes(vectorByVar));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String dumpSizes(Map<Variable, ? extends List<?>> vectorByVar) {
        StringBuilder sb = new StringBuilder();
        Object object = vectorByVar;
        boolean bl = false;
        Iterator<Map.Entry<Variable, List<?>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry<Variable, List<?>> entry;
            Map.Entry<Variable, List<?>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List<?> value = entry2.getValue();
            sb.append(key.getName()).append(" : ").append(value.size()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final int rowCount() {
        return this.myVectorByVar.isEmpty() ? 0 : this.myVectorByVar.entrySet().iterator().next().getValue().size();
    }

    public final boolean has(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.myVectorByVar.containsKey(variable);
    }

    public final boolean isEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.get(variable).isEmpty();
    }

    public final boolean hasNoOrEmpty(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return !this.has(variable) || this.isEmpty(variable);
    }

    @NotNull
    public final List<?> get(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        List<?> list2 = this.myVectorByVar.get(variable);
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @NotNull
    public final List<Double> getNumeric(@NotNull Variable variable) {
        List<Double> list2;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        List<Double> list3 = list2 = this.myVectorByVar.get(variable);
        Intrinsics.checkNotNull(list3);
        if (list3.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        this.assertNumeric(variable);
        return list2;
    }

    @NotNull
    public final Collection<Object> distinctValues(@NotNull Variable variable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        Map $this$getOrPut$iv = this.myDistinctValues;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(variable);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet(this.get(variable));
            $this$getOrPut$iv.put(variable, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Collection)object;
    }

    @NotNull
    public final Set<Variable> variables() {
        return this.myVectorByVar.keySet();
    }

    public final boolean isNumeric(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.assertDefined(variable);
        if (!this.myIsNumeric.containsKey(variable)) {
            SeriesUtil.CheckedDoubleList checkedDoubles = SeriesUtil.INSTANCE.checkedDoubles(this.get(variable));
            this.myIsNumeric.put(variable, checkedDoubles.notEmptyAndCanBeCast());
        }
        Boolean bl = this.myIsNumeric.get(variable);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @Nullable
    public final ClosedRange<Double> range(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.myRanges.containsKey(variable)) {
            List<Double> v = this.getNumeric(variable);
            ClosedRange<Double> r = SeriesUtil.INSTANCE.range((Iterable<Double>)v);
            ((Map)this.myRanges).put(variable, r);
        }
        return this.myRanges.get(variable);
    }

    @NotNull
    public final Builder builder() {
        return new Builder(this);
    }

    private final void assertDefined(Variable variable) {
        if (!this.has(variable)) {
            throw (Throwable)new IllegalArgumentException("Undefined variable: '" + variable + '\'');
        }
    }

    private final void assertNumeric(Variable variable) {
        if (!this.isNumeric(variable)) {
            throw (Throwable)new IllegalArgumentException("Not a numeric variable: '" + variable + '\'');
        }
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ List $indices;

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
            {
                this.$indices = list2;
                super(1);
            }
        });
    }

    @NotNull
    public final DataFrame selectIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set $indices;

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.pickAtIndices(serie, this.$indices);
            }
            {
                this.$indices = set2;
                super(1);
            }
        });
    }

    @NotNull
    public final DataFrame dropIndices(@NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return indices.isEmpty() ? this : this.buildModified((Function1)new Function1<List<?>, List<?>>(indices){
            final /* synthetic */ Set $indices;

            @NotNull
            public final List<?> invoke(@NotNull List<?> serie) {
                Intrinsics.checkNotNullParameter(serie, (String)"serie");
                return SeriesUtil.INSTANCE.skipAtIndices(serie, this.$indices);
            }
            {
                this.$indices = set2;
                super(1);
            }
        });
    }

    private final DataFrame buildModified(Function1<? super List<?>, ? extends List<?>> serieFun) {
        Builder builder = this.builder();
        for (Variable variable : this.myVectorByVar.keySet()) {
            List<?> serie;
            List<?> list2 = serie = this.myVectorByVar.get(variable);
            Intrinsics.checkNotNull(list2);
            List modifiedSerie = (List)serieFun.invoke(list2);
            builder.putIntern(variable, modifiedSerie);
        }
        return builder.build();
    }

    private DataFrame(Builder builder) {
        this.assertAllSeriesAreSameSize((Map)builder.getMyVectorByVar$plot_base_portable());
        this.myVectorByVar = new HashMap(builder.getMyVectorByVar$plot_base_portable());
        this.myIsNumeric = new HashMap(builder.getMyIsNumeric$plot_base_portable());
    }

    public /* synthetic */ DataFrame(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "name", "", "source", "Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "label", "(Ljava/lang/String;Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;Ljava/lang/String;)V", "isOrigin", "", "()Z", "isStat", "getLabel", "()Ljava/lang/String;", "getName", "getSource", "()Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "toString", "toSummaryString", "Companion", "Source", "plot-base-portable"})
    public static final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final Source source;
        @NotNull
        private final String label;
        public static final Companion Companion = new Companion(null);

        public final boolean isOrigin() {
            return this.source == Source.ORIGIN;
        }

        public final boolean isStat() {
            return this.source == Source.STAT;
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final String toSummaryString() {
            return this.name + ", '" + this.label + "' [" + (Object)((Object)this.source) + ']';
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Source getSource() {
            return this.source;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.name = name;
            this.source = source;
            this.label = label;
        }

        public /* synthetic */ Variable(String string, Source source, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                source = Source.ORIGIN;
            }
            if ((n & 4) != 0) {
                string2 = string;
            }
            this(string, source, string2);
        }

        @JvmOverloads
        public Variable(@NotNull String name, @NotNull Source source) {
            this(name, source, null, 4, null);
        }

        @JvmOverloads
        public Variable(@NotNull String name) {
            this(name, null, null, 6, null);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Source;", "", "(Ljava/lang/String;I)V", "ORIGIN", "TRANSFORM", "STAT", "plot-base-portable"})
        public static final class Source
        extends Enum<Source> {
            public static final /* enum */ Source ORIGIN;
            public static final /* enum */ Source TRANSFORM;
            public static final /* enum */ Source STAT;
            private static final /* synthetic */ Source[] $VALUES;

            static {
                Source[] sourceArray = new Source[3];
                Source[] sourceArray2 = sourceArray;
                sourceArray[0] = ORIGIN = new Source();
                sourceArray[1] = TRANSFORM = new Source();
                sourceArray[2] = STAT = new Source();
                $VALUES = sourceArray;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String string) {
                return Enum.valueOf(Source.class, string);
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Variable$Companion;", "", "()V", "createOriginal", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "name", "", "label", "plot-base-portable"})
        public static final class Companion {
            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name, @NotNull String label) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                return new Variable(name, Source.ORIGIN, label);
            }

            public static /* synthetic */ Variable createOriginal$default(Companion companion, String string, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = string;
                }
                return companion.createOriginal(string, string2);
            }

            @JvmOverloads
            @NotNull
            public final Variable createOriginal(@NotNull String name) {
                return jetbrains.datalore.plot.base.DataFrame$Variable$Companion.createOriginal$default(this, name, null, 2, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0004J\u001a\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u001a\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\b2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u001e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u000eJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bR0\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR8\u0010\r\u001a&\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0007j\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder;", "", "()V", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "(Ljetbrains/datalore/plot/base/DataFrame;)V", "myIsNumeric", "Ljava/util/HashMap;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "Lkotlin/collections/HashMap;", "getMyIsNumeric$plot_base_portable", "()Ljava/util/HashMap;", "myVectorByVar", "", "getMyVectorByVar$plot_base_portable", "build", "put", "variable", "v", "putDiscrete", "putIntern", "", "putNumeric", "", "remove", "Companion", "plot-base-portable"})
    public static final class Builder {
        @NotNull
        private final HashMap<Variable, List<?>> myVectorByVar;
        @NotNull
        private final HashMap<Variable, Boolean> myIsNumeric;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final HashMap<Variable, List<?>> getMyVectorByVar$plot_base_portable() {
            return this.myVectorByVar;
        }

        @NotNull
        public final HashMap<Variable, Boolean> getMyIsNumeric$plot_base_portable() {
            return this.myIsNumeric;
        }

        @NotNull
        public final Builder put(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern(variable, v);
            this.myIsNumeric.remove(variable);
            return this;
        }

        @NotNull
        public final Builder putNumeric(@NotNull Variable variable, @NotNull List<Double> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern(variable, v);
            ((Map)this.myIsNumeric).put(variable, true);
            return this;
        }

        @NotNull
        public final Builder putDiscrete(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.putIntern(variable, v);
            ((Map)this.myIsNumeric).put(variable, false);
            return this;
        }

        public final void putIntern(@NotNull Variable variable, @NotNull List<?> v) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter(v, (String)"v");
            ((Map)this.myVectorByVar).put(variable, new ArrayList(v));
        }

        @NotNull
        public final Builder remove(@NotNull Variable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.myVectorByVar.remove(variable);
            this.myIsNumeric.remove(variable);
            return this;
        }

        @NotNull
        public final DataFrame build() {
            return new DataFrame(this, null);
        }

        public Builder() {
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
        }

        public Builder(@NotNull DataFrame data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.myVectorByVar = new HashMap();
            this.myIsNumeric = new HashMap();
            this.myVectorByVar.putAll(data.myVectorByVar);
            this.myIsNumeric.putAll(data.myIsNumeric);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/DataFrame$Builder$Companion;", "", "()V", "emptyFrame", "Ljetbrains/datalore/plot/base/DataFrame;", "plot-base-portable"})
        public static final class Companion {
            @NotNull
            public final DataFrame emptyFrame() {
                return new Builder().build();
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

