/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.logging.Logger;
import jetbrains.datalore.base.logging.PortableLogging;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.PlotSvgExportPortable;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.vis.svgToString.SvgToString;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\n2\b\b\u0002\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J,\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/PlotSvgExportPortable;", "", "()V", "LOG", "Ljetbrains/datalore/base/logging/Logger;", "PORTABLE_SVG_STR_MAPPER", "Ljetbrains/datalore/vis/svgToString/SvgToString;", "buildSvgImageFromRawSpecs", "", "plotSpec", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "svgToString", "getBunchItemSvgStyle", "svg", "transformBunchItemSvg", "Lkotlin/Pair;", "x", "", "y", "plot-config-portable"})
public final class PlotSvgExportPortable {
    private static final Logger LOG;
    private static final SvgToString PORTABLE_SVG_STR_MAPPER;
    public static final PlotSvgExportPortable INSTANCE;

    @NotNull
    public final String buildSvgImageFromRawSpecs(@NotNull Map<String, Object> plotSpec, @NotNull SvgToString svgToString) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        return this.buildSvgImageFromRawSpecs(plotSpec, null, svgToString);
    }

    public static /* synthetic */ String buildSvgImageFromRawSpecs$default(PlotSvgExportPortable plotSvgExportPortable, Map map2, SvgToString svgToString, int n, Object object) {
        if ((n & 2) != 0) {
            svgToString = PORTABLE_SVG_STR_MAPPER;
        }
        return plotSvgExportPortable.buildSvgImageFromRawSpecs(map2, svgToString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildSvgImageFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize, @NotNull SvgToString svgToString) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        List<String> list2 = MonolithicCommon.INSTANCE.buildSvgImagesFromRawSpecs(plotSpec, plotSize, svgToString, (Function1<? super List<String>, Unit>)((Function1)buildSvgImageFromRawSpecs.list.1.INSTANCE));
        if (list2.isEmpty()) {
            throw (Throwable)new IllegalStateException("Nothing to save: the plot is empty.");
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        if (!PlotConfig.Companion.isGGBunchSpec(plotSpec)) {
            throw (Throwable)new IllegalStateException("Can't save multiple SVG images in one file.");
        }
        ArrayList<void> bunchItemSvgList = new ArrayList<void>();
        DoubleRectangle bunchBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        List<BunchConfig.BunchItem> bunchItems = new BunchConfig(plotSpec).getBunchItems();
        for (Pair pair2 : CollectionsKt.zip((Iterable)list2, (Iterable)bunchItems)) {
            void itemSvg;
            void plotSvg;
            String string = (String)pair2.component1();
            BunchConfig.BunchItem bunchItem = (BunchConfig.BunchItem)pair2.component2();
            Pair<String, DoubleVector> pair3 = this.transformBunchItemSvg((String)plotSvg, bunchItem.getX(), bunchItem.getY());
            String string2 = (String)pair3.component1();
            DoubleVector size2 = (DoubleVector)pair3.component2();
            bunchItemSvgList.add(itemSvg);
            bunchBounds = bunchBounds.union(new DoubleRectangle(bunchItem.getX(), bunchItem.getY(), size2.getX(), size2.getY()));
        }
        String svgStyle = this.getBunchItemSvgStyle(list2.get(0));
        return StringsKt.trimMargin$default((String)("<svg xmlns=\"http://www.w3.org/2000/svg\" class=\"plt-container\" width=\"" + bunchBounds.getWidth() + "\" height=\"" + bunchBounds.getHeight() + "\">\n            |" + svgStyle + "\n            |" + CollectionsKt.joinToString$default((Iterable)bunchItemSvgList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n            |</svg>\n        "), null, (int)1, null);
    }

    public static /* synthetic */ String buildSvgImageFromRawSpecs$default(PlotSvgExportPortable plotSvgExportPortable, Map map2, DoubleVector doubleVector, SvgToString svgToString, int n, Object object) {
        if ((n & 4) != 0) {
            svgToString = PORTABLE_SVG_STR_MAPPER;
        }
        return plotSvgExportPortable.buildSvgImageFromRawSpecs(map2, doubleVector, svgToString);
    }

    private final String getBunchItemSvgStyle(String svg) {
        List split = StringsKt.split$default((CharSequence)svg, (String[])new String[]{"<style type=\"text/css\">"}, (boolean)false, (int)0, (int)6, null);
        String styleAtTheTop = (String)split.get(1);
        String style = (String)StringsKt.split$default((CharSequence)styleAtTheTop, (String[])new String[]{"</style>"}, (boolean)false, (int)0, (int)6, null).get(0);
        return StringsKt.trimMargin$default((String)(" \n            |<style type=\"text/css\">\n            |" + style + "\n            |</style>"), null, (int)1, null);
    }

    private final Pair<String, DoubleVector> transformBunchItemSvg(String svg, double x2, double y2) {
        List split = StringsKt.split$default((CharSequence)svg, (String[])new String[]{"</style>"}, (boolean)false, (int)0, (int)6, null);
        String rootGroup = (String)StringsKt.split$default((CharSequence)((CharSequence)split.get(1)), (String[])new String[]{"</svg>"}, (boolean)false, (int)0, (int)6, null).get(0);
        StringBuilder stringBuilder = new StringBuilder().append("<g transform=\"translate(").append(x2).append(' ').append(y2).append(")\" ");
        String string = rootGroup;
        int n = StringsKt.indexOf$default((CharSequence)rootGroup, (String)"<g ", (int)0, (boolean)false, (int)6, null) + 3;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String rootGroupTranslated = stringBuilder.append(string3).toString();
        DoubleVector svgSize = PlotSizeHelper.INSTANCE.fetchPlotSizeFromSvg(svg);
        return new Pair((Object)rootGroupTranslated, (Object)svgSize);
    }

    private PlotSvgExportPortable() {
    }

    static {
        PlotSvgExportPortable plotSvgExportPortable;
        INSTANCE = plotSvgExportPortable = new PlotSvgExportPortable();
        LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotSvgExportPortable.class));
        PORTABLE_SVG_STR_MAPPER = new SvgToString(null);
    }

    public static final /* synthetic */ Logger access$getLOG$p(PlotSvgExportPortable $this) {
        PlotSvgExportPortable plotSvgExportPortable = $this;
        return LOG;
    }
}

