/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.event.awt.AwtEventUtil;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.AwtPlotFactory;
import jetbrains.datalore.plot.AwtPlotFactoryKt;
import jetbrains.datalore.plot.DisposableJPanel;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.plot.builder.PlotContainer;
import jetbrains.datalore.plot.config.FailureHandler;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.server.config.PlotConfigClientSideJvmJs;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001BB\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0013H&J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J>\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0012\u0012\u0004\u0012\u00020\u000b0\u0003J>\u0010\u001f\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u0012\u0012\u0004\u0012\u00020\u000b0\u0003J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0014\u0010\"\u001a\u00020\b2\n\u0010#\u001a\u00060$j\u0002`%H\u0002J0\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010'\u001a\u00020(H\u0002R#\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/AwtPlotFactory;", "", "svgComponentFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "Ljavax/swing/JComponent;", "executor", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getExecutor", "()Lkotlin/jvm/functions/Function1;", "getSvgComponentFactory", "buildGGBunchComponent", "plotInfos", "", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "buildPlotComponent", "plotBuildInfo", "plotContainer", "Ljetbrains/datalore/plot/builder/PlotContainer;", "buildPlotFromProcessedSpecs", "plotSpec", "", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "computationMessagesHandler", "buildPlotFromRawSpecs", "createErrorLabel", "s", "handleException", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "processSpecs", "frontendOnly", "", "plot-config"})
public abstract class AwtPlotFactory {
    @NotNull
    private final Function1<SvgSvgElement, JComponent> svgComponentFactory;
    @NotNull
    private final Function1<Function0<Unit>, Unit> executor;

    @NotNull
    public abstract JComponent buildPlotComponent(@NotNull MonolithicCommon.PlotBuildInfo var1);

    @NotNull
    public final JComponent buildPlotFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            Map<String, Object> plotSpec2 = this.processSpecs(plotSpec, false);
            jComponent = this.buildPlotFromProcessedSpecs(plotSpec2, plotSize, computationMessagesHandler);
        }
        catch (RuntimeException e) {
            jComponent = this.handleException(e);
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent buildPlotFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            void $this$flatMapTo$iv$iv;
            MonolithicCommon.PlotsBuildResult buildResult = MonolithicCommon.INSTANCE.buildPlotsFromProcessedSpecs(plotSpec, plotSize);
            if (buildResult.isError()) {
                MonolithicCommon.PlotsBuildResult plotsBuildResult = buildResult;
                if (plotsBuildResult == null) {
                    throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Error");
                }
                String errorMessage = ((MonolithicCommon.PlotsBuildResult.Error)plotsBuildResult).getError();
                return this.createErrorLabel(errorMessage);
            }
            MonolithicCommon.PlotsBuildResult plotsBuildResult = buildResult;
            if (plotsBuildResult == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.MonolithicCommon.PlotsBuildResult.Success");
            }
            MonolithicCommon.PlotsBuildResult.Success success2 = (MonolithicCommon.PlotsBuildResult.Success)plotsBuildResult;
            Iterable $this$flatMap$iv = success2.getBuildInfos();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MonolithicCommon.PlotBuildInfo it = (MonolithicCommon.PlotBuildInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getComputationMessages();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List computationMessages = (List)destination$iv$iv;
            computationMessagesHandler.invoke((Object)computationMessages);
            if (success2.getBuildInfos().size() == 1) {
                return this.buildPlotComponent(success2.getBuildInfos().get(0));
            }
            return this.buildGGBunchComponent(success2.getBuildInfos());
        }
        catch (RuntimeException e) {
            JComponent jComponent = this.handleException(e);
            return jComponent;
        }
    }

    @NotNull
    public final JComponent buildPlotComponent(@NotNull PlotContainer plotContainer) {
        Intrinsics.checkNotNullParameter((Object)plotContainer, (String)"plotContainer");
        plotContainer.ensureContentBuilt();
        SvgSvgElement svg = plotContainer.getSvg();
        if (plotContainer.isLiveMap()) {
            svg.addClass("plt-transparent");
        }
        JComponent plotComponent = (JComponent)this.svgComponentFactory.invoke((Object)svg);
        plotComponent.addMouseListener(new MouseAdapter(this, plotContainer){
            final /* synthetic */ AwtPlotFactory this$0;
            final /* synthetic */ PlotContainer $plotContainer;

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseExited(e);
                this.this$0.getExecutor().invoke((Object)new Function0<Unit>(this, e){
                    final /* synthetic */ buildPlotComponent.1 this$0;
                    final /* synthetic */ MouseEvent $e;

                    public final void invoke() {
                        this.this$0.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_LEFT, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$e = mouseEvent;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$plotContainer = $captured_local_variable$1;
            }
        });
        plotComponent.addMouseMotionListener(new MouseAdapter(this, plotContainer){
            final /* synthetic */ AwtPlotFactory this$0;
            final /* synthetic */ PlotContainer $plotContainer;

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseMoved(e);
                this.this$0.getExecutor().invoke((Object)new Function0<Unit>(this, e){
                    final /* synthetic */ buildPlotComponent.2 this$0;
                    final /* synthetic */ MouseEvent $e;

                    public final void invoke() {
                        this.this$0.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_MOVED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$e = mouseEvent;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$plotContainer = $captured_local_variable$1;
            }
        });
        return plotComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildGGBunchComponent(List<MonolithicCommon.PlotBuildInfo> plotInfos) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object bounds;
        void it;
        DisposableJPanel bunchComponent = new DisposableJPanel();
        bunchComponent.setBorder(null);
        jetbrains.datalore.base.values.Color color = Colors.INSTANCE.parseColor("white");
        boolean bl = false;
        boolean bl2 = false;
        jetbrains.datalore.base.values.Color color2 = color;
        Object object = bunchComponent;
        boolean bl3 = false;
        Object object2 = new Color(it.getRed(), it.getGreen(), it.getBlue(), it.getAlpha());
        ((JComponent)object).setBackground((Color)object2);
        for (MonolithicCommon.PlotBuildInfo plotInfo : plotInfos) {
            JComponent plotComponent = this.buildPlotComponent(plotInfo);
            bounds = plotInfo.bounds();
            plotComponent.setBounds(new Rectangle((int)((DoubleRectangle)bounds).getOrigin().getX(), (int)((DoubleRectangle)bounds).getOrigin().getY(), (int)((DoubleRectangle)bounds).getDimension().getX(), (int)((DoubleRectangle)bounds).getDimension().getY()));
            bunchComponent.add(plotComponent);
        }
        Iterable $this$map$iv = plotInfos;
        boolean $i$f$map = false;
        bounds = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MonolithicCommon.PlotBuildInfo plotBuildInfo = (MonolithicCommon.PlotBuildInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            object2 = it2.bounds();
            object.add(object2);
        }
        $this$map$iv = (List)destination$iv$iv;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bounds2;
            Object item$iv$iv;
            item$iv$iv = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl5 = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds2);
        }
        DoubleRectangle bunchBounds = accumulator$iv;
        Dimension bunchDimensions = new Dimension((int)bunchBounds.getWidth(), (int)bunchBounds.getHeight());
        bunchComponent.setPreferredSize(bunchDimensions);
        bunchComponent.setMinimumSize(bunchDimensions);
        bunchComponent.setMaximumSize(bunchDimensions);
        return bunchComponent;
    }

    private final JComponent handleException(RuntimeException e) {
        FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
        if (failureInfo.isInternalError()) {
            AwtPlotFactoryKt.access$getLOG$p().error((Throwable)e, (Function0)handleException.1.INSTANCE);
        }
        return this.createErrorLabel(failureInfo.getMessage());
    }

    private final JComponent createErrorLabel(String s2) {
        JLabel label = new JLabel(s2);
        label.setForeground(Color.RED);
        return label;
    }

    private final Map<String, Object> processSpecs(Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : PlotConfigServerSide.Companion.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigClientSideJvmJs.INSTANCE.processTransform(plotSpec2);
    }

    @NotNull
    public final Function1<SvgSvgElement, JComponent> getSvgComponentFactory() {
        return this.svgComponentFactory;
    }

    @NotNull
    public final Function1<Function0<Unit>, Unit> getExecutor() {
        return this.executor;
    }

    public AwtPlotFactory(@NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor) {
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.svgComponentFactory = svgComponentFactory;
        this.executor = executor;
    }
}

