/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.typedGeometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt$boundingBox$1;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt$boundingBox$2;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt$isClockwise$1;
import jetbrains.datalore.base.typedGeometry.AlgorithmsKt$isClockwise$2;
import jetbrains.datalore.base.typedGeometry.MultiPolygon;
import jetbrains.datalore.base.typedGeometry.Polygon;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Ring;
import jetbrains.datalore.base.typedGeometry.Vec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u0004\u001a \u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u0004\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00050\f\u00a8\u0006\r"}, d2={"createMultiPolygon", "Ljetbrains/datalore/base/typedGeometry/MultiPolygon;", "T", "points", "", "Ljetbrains/datalore/base/typedGeometry/Vec;", "isClockwise", "", "ring", "boundingBox", "Ljetbrains/datalore/base/typedGeometry/Rect;", "TypeT", "", "base-portable"})
public final class AlgorithmsKt {
    public static final <T> boolean isClockwise(@NotNull List<Vec<T>> ring) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        return GeometryKt.isClockwise(ring, (Function1)AlgorithmsKt$isClockwise$1.INSTANCE, (Function1)AlgorithmsKt$isClockwise$2.INSTANCE);
    }

    @NotNull
    public static final <T> MultiPolygon<T> createMultiPolygon(@NotNull List<Vec<T>> points2) {
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        if (points2.isEmpty()) {
            return new MultiPolygon(CollectionsKt.emptyList());
        }
        ArrayList polygons = new ArrayList();
        ArrayList rings = new ArrayList();
        for (List collection3 : GeometryKt.splitRings(points2)) {
            Collection collection2 = rings;
            boolean bl = false;
            if (!collection2.isEmpty() && AlgorithmsKt.isClockwise(collection3)) {
                polygons.add(new Polygon(rings));
                rings = new ArrayList();
            }
            rings.add(new Ring(collection3));
        }
        Collection collection3 = rings;
        boolean bl = false;
        if (!collection3.isEmpty()) {
            polygons.add(new Polygon(rings));
        }
        return new MultiPolygon(polygons);
    }

    @NotNull
    public static final <TypeT> Rect<TypeT> boundingBox(@NotNull Iterable<Vec<TypeT>> $this$boundingBox) {
        Intrinsics.checkNotNullParameter($this$boundingBox, (String)"$this$boundingBox");
        return (Rect)DoubleRectangles.INSTANCE.calculateBoundingBox($this$boundingBox, (Function1)AlgorithmsKt$boundingBox$1.INSTANCE, (Function1)AlgorithmsKt$boundingBox$2.INSTANCE, boundingBox.3.INSTANCE);
    }
}

