/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.property;

import jetbrains.datalore.base.observable.collections.CollectionAdapter;
import jetbrains.datalore.base.observable.collections.CollectionItemEvent;
import jetbrains.datalore.base.observable.collections.DataloreIndexOutOfBoundsException;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.event.ListenerCaller;
import jetbrains.datalore.base.observable.event.Listeners;
import jetbrains.datalore.base.observable.property.BaseReadableProperty;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.PropertyChangeEvent;
import jetbrains.datalore.base.observable.property.ValueProperty;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00020\u0004B\u001d\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0017\u001a\u00020\u00162\u0016\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u00140\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0017\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/datalore/base/observable/property/ListItemProperty;", "ValueT", "Ljetbrains/datalore/base/observable/property/BaseReadableProperty;", "Ljetbrains/datalore/base/observable/property/Property;", "Ljetbrains/datalore/base/registration/Disposable;", "myList", "Ljetbrains/datalore/base/observable/collections/list/ObservableList;", "index", "", "(Ljetbrains/datalore/base/observable/collections/list/ObservableList;I)V", "Ljetbrains/datalore/base/observable/property/ValueProperty;", "getIndex", "()Ljetbrains/datalore/base/observable/property/ValueProperty;", "isValid", "", "()Z", "myDisposed", "myHandlers", "Ljetbrains/datalore/base/observable/event/Listeners;", "Ljetbrains/datalore/base/observable/event/EventHandler;", "Ljetbrains/datalore/base/observable/property/PropertyChangeEvent;", "myReg", "Ljetbrains/datalore/base/registration/Registration;", "addHandler", "handler", "dispose", "", "get", "()Ljava/lang/Object;", "invalidate", "set", "value", "(Ljava/lang/Object;)V", "base"})
public final class ListItemProperty<ValueT>
extends BaseReadableProperty<ValueT>
implements Property<ValueT>,
Disposable {
    private final Listeners<EventHandler<PropertyChangeEvent<? extends ValueT>>> myHandlers;
    private final Registration myReg;
    private boolean myDisposed;
    @NotNull
    private final ValueProperty<Integer> index;
    private final ObservableList<ValueT> myList;

    @NotNull
    public final ValueProperty<Integer> getIndex() {
        return this.index;
    }

    public final boolean isValid() {
        return this.index.get() != null;
    }

    @Override
    @NotNull
    public Registration addHandler(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.myHandlers.add(handler2);
    }

    @Override
    @Nullable
    public ValueT get() {
        ValueT ValueT;
        if (this.isValid()) {
            Integer n = this.index.get();
            Intrinsics.checkNotNull((Object)n);
            ValueT = (ValueT)this.myList.get(((Number)n).intValue());
        } else {
            ValueT = null;
        }
        return ValueT;
    }

    @Override
    public void set(@Nullable ValueT value) {
        if (!this.isValid()) {
            throw (Throwable)new IllegalStateException("Property points to an invalid item, can\u2019t set");
        }
        Integer n = this.index.get();
        Intrinsics.checkNotNull((Object)n);
        this.myList.set(((Number)n).intValue(), value);
    }

    private final void invalidate() {
        this.index.set(null);
        this.myReg.dispose();
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            throw (Throwable)new IllegalStateException("Double dispose");
        }
        if (this.isValid()) {
            this.myReg.dispose();
        }
        this.myDisposed = true;
    }

    public ListItemProperty(@NotNull ObservableList<ValueT> myList, int index) {
        Intrinsics.checkNotNullParameter(myList, (String)"myList");
        this.myList = myList;
        this.myHandlers = new Listeners();
        this.index = new ValueProperty<Integer>(index);
        if (index < 0 || index >= this.myList.size()) {
            throw (Throwable)new DataloreIndexOutOfBoundsException("Can\u2019t point to a non-existent item");
        }
        this.myReg = this.myList.addListener(new CollectionAdapter<ValueT>(){

            @Override
            public void onItemAdded(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer index = this.getIndex().get();
                if (index != null && event.getIndex() <= index) {
                    this.getIndex().set(index + 1);
                }
            }

            @Override
            public void onItemSet(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer n = this.getIndex().get();
                if (n != null && event.getIndex() == n.intValue()) {
                    PropertyChangeEvent e = new PropertyChangeEvent(event.getOldItem(), event.getNewItem());
                    myHandlers.fire(new ListenerCaller<EventHandler<? super PropertyChangeEvent<? extends ValueT>>>(e){
                        final /* synthetic */ PropertyChangeEvent $e;

                        public void call(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> l) {
                            Intrinsics.checkNotNullParameter(l, (String)"l");
                            l.onEvent(this.$e);
                        }
                        {
                            this.$e = $captured_local_variable$0;
                        }
                    });
                }
            }

            @Override
            public void onItemRemoved(@NotNull CollectionItemEvent<? extends ValueT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Integer index = this.getIndex().get();
                if (index != null) {
                    if (event.getIndex() < index) {
                        this.getIndex().set(index - 1);
                    } else if (event.getIndex() == index.intValue()) {
                        this.invalidate();
                        PropertyChangeEvent<Object> e = new PropertyChangeEvent<Object>(event.getOldItem(), null);
                        myHandlers.fire(new ListenerCaller<EventHandler<? super PropertyChangeEvent<? extends ValueT>>>(e){
                            final /* synthetic */ PropertyChangeEvent $e;

                            public void call(@NotNull EventHandler<? super PropertyChangeEvent<? extends ValueT>> l) {
                                Intrinsics.checkNotNullParameter(l, (String)"l");
                                l.onEvent(this.$e);
                            }
                            {
                                this.$e = $captured_local_variable$0;
                            }
                        });
                    }
                }
            }
        });
    }
}

