/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime;

import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.DateTimeUtil;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.Time;
import jetbrains.datalore.base.datetime.WeekDay;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001/B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u0003J\u0013\u0010$\u001a\u00020%2\b\u0010 \u001a\u0004\u0018\u00010&H\u0096\u0002J\b\u0010'\u001a\u00020\u0003H\u0016J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020,H\u0016J\b\u0010.\u001a\u00020\u001aH\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u00060"}, d2={"Ljetbrains/datalore/base/datetime/Date;", "", "day", "", "month", "Ljetbrains/datalore/base/datetime/Month;", "year", "(ILjetbrains/datalore/base/datetime/Month;I)V", "dateEnd", "Ljetbrains/datalore/base/datetime/DateTime;", "getDateEnd", "()Ljetbrains/datalore/base/datetime/DateTime;", "dateStart", "getDateStart", "getDay", "()I", "getMonth", "()Ljetbrains/datalore/base/datetime/Month;", "weekDay", "Ljetbrains/datalore/base/datetime/WeekDay;", "getWeekDay", "()Ljetbrains/datalore/base/datetime/WeekDay;", "getYear", "addDays", "days", "appendDay", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendMonth", "compareTo", "other", "daysFrom", "date", "daysFromYearStart", "equals", "", "", "hashCode", "nextDate", "prevDate", "subtractDays", "toPrettyString", "", "toString", "validate", "Companion", "base-portable"})
public final class Date
implements Comparable<Date> {
    private final int day;
    @NotNull
    private final Month month;
    private final int year;
    @NotNull
    private static final Date EPOCH;
    private static final WeekDay EPOCH_WEEKDAY;
    private static final Date CACHE_STAMP;
    private static final int CACHE_DAYS;
    public static final Companion Companion;

    @NotNull
    public final WeekDay getWeekDay() {
        int daysFromOrigin = this.daysFrom(EPOCH);
        return WeekDay.values()[(daysFromOrigin + EPOCH_WEEKDAY.ordinal()) % WeekDay.values().length];
    }

    @NotNull
    public final DateTime getDateStart() {
        return new DateTime(this, null, 2, null);
    }

    @NotNull
    public final DateTime getDateEnd() {
        return new DateTime(this, Time.Companion.getDAY_END());
    }

    private final void validate() {
        int daysInMonth;
        boolean isValid;
        int n = this.day;
        boolean bl = isValid = 1 <= n && (daysInMonth = this.month.getDaysInYear(this.year)) >= n;
        if (!isValid) {
            throw (Throwable)new IllegalArgumentException();
        }
    }

    public final int daysFrom(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.compareTo(date) < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        int result = 0;
        if (this.year != date.year) {
            int fromYear = date.year;
            int toYear = this.year;
            int leapYears = DateTimeUtil.INSTANCE.leapYearsBetween$base_portable(fromYear, toYear);
            int years = toYear - fromYear;
            result += leapYears * DateTimeUtil.INSTANCE.getDAYS_IN_LEAP_YEAR$base_portable() + (years - leapYears) * DateTimeUtil.INSTANCE.getDAYS_IN_YEAR$base_portable();
        }
        return result + this.daysFromYearStart() - date.daysFromYearStart();
    }

    public final int daysFromYearStart() {
        int result = this.day;
        for (Month current = this.month.prev(); current != null; current = current.prev()) {
            result += current.getDaysInYear(this.year);
        }
        return result;
    }

    @NotNull
    public final Date addDays(int days) {
        int days2 = days;
        if (days2 < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (days2 == 0) {
            return this;
        }
        int day = this.day;
        Month month = this.month;
        int year = this.year;
        boolean lessThanYear = false;
        if (days2 >= CACHE_DAYS && year == Date.EPOCH.year) {
            year = Date.CACHE_STAMP.year;
            month = Date.CACHE_STAMP.month;
            day = Date.CACHE_STAMP.day;
            days2 -= CACHE_DAYS;
        }
        while (days2 > 0) {
            int daysToNextMonth = month.getDaysInYear(year) - day + 1;
            if (days2 < daysToNextMonth) {
                return new Date(day + days2, month, year);
            }
            if (lessThanYear) {
                Intrinsics.checkNotNull((Object)month.next());
                day = 1;
                days2 -= daysToNextMonth;
                continue;
            }
            int daysToNextYear = jetbrains.datalore.base.datetime.Date$Companion.lastDayOf$default(Companion, year, null, 2, null).daysFrom(new Date(day, month, year)) + 1;
            if (days2 >= daysToNextYear) {
                day = 1;
                month = Month.Companion.getJANUARY();
                ++year;
                days2 -= daysToNextYear;
                continue;
            }
            Intrinsics.checkNotNull((Object)month.next());
            day = 1;
            days2 -= daysToNextMonth;
            lessThanYear = true;
        }
        return new Date(day, month, year);
    }

    @NotNull
    public final Date nextDate() {
        return this.addDays(1);
    }

    @NotNull
    public final Date prevDate() {
        return this.subtractDays(1);
    }

    @NotNull
    public final Date subtractDays(int days) {
        Date date;
        if (days < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (days == 0) {
            return this;
        }
        if (days < this.day) {
            return new Date(this.day - days, this.month, this.year);
        }
        int daysToPrevYear = this.daysFrom(jetbrains.datalore.base.datetime.Date$Companion.firstDayOf$default(Companion, this.year, null, 2, null));
        if (days > daysToPrevYear) {
            date = jetbrains.datalore.base.datetime.Date$Companion.lastDayOf$default(Companion, this.year - 1, null, 2, null).subtractDays(days - daysToPrevYear - 1);
        } else {
            Month month = this.month.prev();
            Intrinsics.checkNotNull((Object)month);
            date = Companion.lastDayOf(this.year, month).subtractDays(days - this.day);
        }
        return date;
    }

    @Override
    public int compareTo(@NotNull Date other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.year != other.year) {
            return this.year - other.year;
        }
        return this.month.ordinal() != other.month.ordinal() ? this.month.ordinal() - other.month.ordinal() : this.day - other.day;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Date)) {
            return false;
        }
        Date date = (Date)other;
        return date.year == this.year && date.month == this.month && date.day == this.day;
    }

    public int hashCode() {
        return this.year * 239 + this.month.hashCode() * 31 + this.day;
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.year);
        this.appendMonth(result);
        this.appendDay(result);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final void appendDay(StringBuilder result) {
        if (this.day < 10) {
            result.append("0");
        }
        result.append(this.day);
    }

    private final void appendMonth(StringBuilder result) {
        int month = this.month.ordinal() + 1;
        if (month < 10) {
            result.append("0");
        }
        result.append(month);
    }

    @NotNull
    public final String toPrettyString() {
        StringBuilder result = new StringBuilder();
        this.appendDay(result);
        result.append(".");
        this.appendMonth(result);
        result.append(".");
        result.append(this.year);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public final int getDay() {
        return this.day;
    }

    @NotNull
    public final Month getMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.year;
    }

    public Date(int day, @NotNull Month month, int year) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.day = day;
        this.month = month;
        this.year = year;
        this.validate();
    }

    static {
        Companion = new Companion(null);
        EPOCH = new Date(1, Month.Companion.getJANUARY(), 1970);
        EPOCH_WEEKDAY = WeekDay.THURSDAY;
        CACHE_STAMP = new Date(1, Month.Companion.getJANUARY(), 2012);
        CACHE_DAYS = CACHE_STAMP.daysFrom(EPOCH);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/base/datetime/Date$Companion;", "", "()V", "CACHE_DAYS", "", "CACHE_STAMP", "Ljetbrains/datalore/base/datetime/Date;", "EPOCH", "getEPOCH", "()Ljetbrains/datalore/base/datetime/Date;", "EPOCH_WEEKDAY", "Ljetbrains/datalore/base/datetime/WeekDay;", "firstDayOf", "year", "month", "Ljetbrains/datalore/base/datetime/Month;", "lastDayOf", "parse", "str", "", "base-portable"})
    public static final class Companion {
        @NotNull
        public final Date getEPOCH() {
            return EPOCH;
        }

        @NotNull
        public final Date parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (str.length() != 8) {
                throw (Throwable)new RuntimeException();
            }
            String string = str;
            int n = 0;
            int n2 = 4;
            int n3 = 0;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string2;
            n = 0;
            int year = Integer.parseInt(string);
            String string3 = str;
            n2 = 4;
            n3 = 6;
            int n4 = 0;
            String string4 = string3.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string4;
            n2 = 0;
            int month = Integer.parseInt(string3);
            String string5 = str;
            n3 = 6;
            n4 = 8;
            boolean bl = false;
            String string6 = string5.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = string6;
            n3 = 0;
            int day = Integer.parseInt(string5);
            return new Date(day, Month.Companion.values()[month - 1], year);
        }

        @JvmOverloads
        @NotNull
        public final Date firstDayOf(int year, @NotNull Month month) {
            Intrinsics.checkNotNullParameter((Object)month, (String)"month");
            return new Date(1, month, year);
        }

        public static /* synthetic */ Date firstDayOf$default(Companion companion, int n, Month month, int n2, Object object) {
            if ((n2 & 2) != 0) {
                month = Month.Companion.getJANUARY();
            }
            return companion.firstDayOf(n, month);
        }

        @JvmOverloads
        @NotNull
        public final Date firstDayOf(int year) {
            return jetbrains.datalore.base.datetime.Date$Companion.firstDayOf$default(this, year, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final Date lastDayOf(int year, @NotNull Month month) {
            Intrinsics.checkNotNullParameter((Object)month, (String)"month");
            return new Date(month.getDays(), month, year);
        }

        public static /* synthetic */ Date lastDayOf$default(Companion companion, int n, Month month, int n2, Object object) {
            if ((n2 & 2) != 0) {
                month = Month.Companion.getDECEMBER();
            }
            return companion.lastDayOf(n, month);
        }

        @JvmOverloads
        @NotNull
        public final Date lastDayOf(int year) {
            return jetbrains.datalore.base.datetime.Date$Companion.lastDayOf$default(this, year, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

