/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt$calculateArea$1;
import jetbrains.datalore.base.algorithms.GeometryKt$calculateArea$2;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001aL\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u001a(\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001aB\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0006\u001a\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001a&\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0004\"\u0004\b\u0000\u0010\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a\u0016\u0010\u0013\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004\u001a,\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0016"}, d2={"calculateArea", "", "T", "ring", "", "x", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "y", "Ljetbrains/datalore/base/geometry/DoubleVector;", "findRingIntervals", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "path", "isClockwise", "", "makeClosed", "splitRings", "points", "isClosed", "sublist", "range", "base-portable"})
public final class GeometryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<List<T>> splitRings(@NotNull List<? extends T> points2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        Iterable $this$map$iv = GeometryKt.findRingIntervals(points2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClosedRange closedRange = (ClosedRange)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List<? extends T> list2 = GeometryKt.sublist(points2, (ClosedRange<Integer>)it);
            collection2.add(list2);
        }
        List rings = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Collection collection3 = rings;
        boolean bl = false;
        if (!collection3.isEmpty() && !GeometryKt.isClosed((List)CollectionsKt.last((List)rings))) {
            rings.set(CollectionsKt.getLastIndex((List)rings), GeometryKt.makeClosed((List)CollectionsKt.last((List)rings)));
        }
        return rings;
    }

    private static final <T> List<T> makeClosed(List<? extends T> path2) {
        return CollectionsKt.plus((Collection)CollectionsKt.toMutableList((Collection)path2), (Object)CollectionsKt.first(path2));
    }

    public static final <T> boolean isClosed(@NotNull List<? extends T> $this$isClosed) {
        Intrinsics.checkNotNullParameter($this$isClosed, (String)"$this$isClosed");
        return Intrinsics.areEqual((Object)CollectionsKt.first($this$isClosed), (Object)CollectionsKt.last($this$isClosed));
    }

    private static final <T> List<ClosedRange<Integer>> findRingIntervals(List<? extends T> path2) {
        ArrayList<ClosedRange<Comparable>> intervals = new ArrayList<ClosedRange<Comparable>>();
        int startIndex = 0;
        int n = path2.size();
        for (int i = 0; i < n; ++i) {
            if (startIndex == i || !Intrinsics.areEqual(path2.get(startIndex), path2.get(i))) continue;
            intervals.add(new ClosedRange<Comparable>(Integer.valueOf(startIndex), Integer.valueOf(i + 1)));
            startIndex = i + 1;
        }
        if (startIndex != path2.size()) {
            intervals.add(new ClosedRange<Comparable>(Integer.valueOf(startIndex), Integer.valueOf(path2.size())));
        }
        return intervals;
    }

    private static final <T> List<T> sublist(List<? extends T> $this$sublist, ClosedRange<Integer> range2) {
        return $this$sublist.subList(((Number)range2.getLowerEnd()).intValue(), ((Number)range2.getUpperEnd()).intValue());
    }

    public static final double calculateArea(@NotNull List<DoubleVector> ring) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        return GeometryKt.calculateArea(ring, (Function1)GeometryKt$calculateArea$1.INSTANCE, (Function1)GeometryKt$calculateArea$2.INSTANCE);
    }

    public static final <T> boolean isClockwise(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        Collection collection2 = ring;
        boolean bl = false;
        boolean bl2 = !collection2.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Ring shouldn't be empty to calculate clockwise";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        double sum = 0.0;
        T prev = ring.get(ring.size() - 1);
        for (T point2 : ring) {
            sum += ((Number)x2.invoke(prev)).doubleValue() * ((Number)y2.invoke(point2)).doubleValue() - ((Number)x2.invoke(point2)).doubleValue() * ((Number)y2.invoke(prev)).doubleValue();
            prev = point2;
        }
        return sum < 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> double calculateArea(@NotNull List<? extends T> ring, @NotNull Function1<? super T, Double> x2, @NotNull Function1<? super T, Double> y2) {
        Intrinsics.checkNotNullParameter(ring, (String)"ring");
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        double area2 = 0.0;
        int j = ring.size() - 1;
        int n = 0;
        int n2 = ((Collection)ring).size();
        while (n < n2) {
            void i;
            T p1 = ring.get((int)i);
            T p2 = ring.get(j);
            area2 += (((Number)x2.invoke(p2)).doubleValue() + ((Number)x2.invoke(p1)).doubleValue()) * (((Number)y2.invoke(p2)).doubleValue() - ((Number)y2.invoke(p1)).doubleValue());
            j = i++;
        }
        double d = area2 / (double)2;
        boolean bl = false;
        return Math.abs(d);
    }
}

