/*
 * Copyright (c) 2019 JetBrains s.r.o.
 * Use of this source code is governed by the MIT license that can be found in the LICENSE file.
 *
 * This file has been modified by JetBrains : Java code has been converted to Kotlin code.
 *
 * THE FOLLOWING IS THE COPYRIGHT OF THE ORIGINAL DOCUMENT:
 *
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package jetbrains.datalore.base.gcommon.collect


object Comparables {
    fun <T : Comparable<T>> min(a: T, b: T): T {
        return if (a < b) a else b
    }

    fun <T : Comparable<T>> max(a: T, b: T): T {
        return if (a >= b) a else b
    }

    fun <T : Comparable<T>> lse(a: T, b: T): Boolean {
        return a <= b
    }

    fun <T : Comparable<T>> gte(a: T, b: T): Boolean {
        return a >= b
    }

    fun <T : Comparable<T>> ls(a: T, b: T): Boolean {
        return a < b
    }

    fun <T : Comparable<T>> gt(a: T, b: T): Boolean {
        return a > b
    }
}
