/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.java-time.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaInstantColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Ljava/time/Instant;", "Companion", "exposed-java-time"})
public final class JavaInstantColumnType
extends ColumnType
implements IDateColumnType {
    private final boolean hasTimePart;
    @NotNull
    private static final JavaInstantColumnType INSTANCE;
    @NotNull
    public static final Companion Companion;

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof Instant) {
            instant = (Instant)value;
        } else if (object instanceof Timestamp) {
            instant = ((Timestamp)value).toInstant();
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant instant2 = instant;
        object = DefaultKt.getCurrentDialect();
        return object instanceof OracleDialect ? '\'' + JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'' : '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'';
    }

    @NotNull
    public Instant valueFromDB(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value).toInstant();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"value.toInstant()");
        } else if (object instanceof String) {
            Instant instant3 = Instant.parse((CharSequence)value);
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"Instant.parse(value)");
        } else {
            instant = this.valueFromDB(value.toString());
        }
        return instant;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getTimestamp(index);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof Instant && DefaultKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$p().format((TemporalAccessor)value);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SQLITE_AND_ORACLE_DATE_T\u2026G_FORMATTER.format(value)");
        } else if (value instanceof Instant) {
            Timestamp timestamp = Timestamp.from((Instant)value);
            object = timestamp;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"java.sql.Timestamp.from(value)");
        } else {
            object = value;
        }
        return object;
    }

    public JavaInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new JavaInstantColumnType();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaInstantColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/java-time/JavaInstantColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/java-time/JavaInstantColumnType;", "exposed-java-time"})
    public static final class Companion {
        @NotNull
        public final JavaInstantColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

