/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.IdeaImportTask;
import org.jetbrains.compose.internal.com.squareup.kotlinpoet.FileSpec;
import org.jetbrains.compose.internal.utils.StringUtilsKt;
import org.jetbrains.compose.resources.GenerateActualResourceCollectorsTask;
import org.jetbrains.compose.resources.GeneratedResClassSpecKt;
import org.jetbrains.compose.resources.ResourceType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/resources/GenerateActualResourceCollectorsTask;", "Lorg/jetbrains/compose/internal/IdeaImportTask;", "()V", "codeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getCodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "makeAccessorsPublic", "Lorg/gradle/api/provider/Property;", "", "getMakeAccessorsPublic", "()Lorg/gradle/api/provider/Property;", "packageName", "", "getPackageName", "resourceAccessorDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getResourceAccessorDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "useActualModifier", "getUseActualModifier", "safeAction", "", "compose"})
@SourceDebugExtension(value={"SMAP\nGenerateResourceCollectorsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateResourceCollectorsTask.kt\norg/jetbrains/compose/resources/GenerateActualResourceCollectorsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n1360#2:105\n1446#2,5:106\n1603#2,9:111\n1855#2:120\n1856#2:124\n1612#2:125\n1490#2:126\n1520#2,3:127\n1523#2,3:137\n1282#3,2:121\n1#4:123\n372#5,7:130\n*S KotlinDebug\n*F\n+ 1 GenerateResourceCollectorsTask.kt\norg/jetbrains/compose/resources/GenerateActualResourceCollectorsTask\n*L\n65#1:105\n65#1:106,5\n69#1:111,9\n69#1:120\n69#1:124\n69#1:125\n89#1:126\n89#1:127,3\n89#1:137,3\n72#1:121,2\n69#1:123\n89#1:130,7\n*E\n"})
public abstract class GenerateActualResourceCollectorsTask
extends IdeaImportTask {
    @Input
    @NotNull
    public abstract Property<String> getPackageName();

    @Input
    @NotNull
    public abstract Property<Boolean> getMakeAccessorsPublic();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseActualModifier();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getResourceAccessorDirs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCodeDir();

    /*
     * WARNING - void declaration
     */
    @Override
    public void safeAction() {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        File kotlinDir = ((Directory)this.getCodeDir().get()).getAsFile();
        Set inputDirs = this.getResourceAccessorDirs().getFiles();
        this.getLogger().info("Clean directory " + kotlinDir);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinDir, (String)"kotlinDir");
        FilesKt.deleteRecursively((File)kotlinDir);
        kotlinDir.mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)inputDirs, (String)"inputDirs");
        Iterable $this$flatMap$iv = inputDirs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File dir2 = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
            Iterable list$iv$iv = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir2)), (Function1)safeAction.inputFiles.1.1.INSTANCE));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inputFiles2 = (List)destination$iv$iv;
        this.getLogger().info("Generate actual ResourceCollectors for " + kotlinDir);
        Iterable $this$mapNotNull$iv = inputFiles2;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            File inputFile = (File)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.contains$default((CharSequence)FilesKt.getNameWithoutExtension((File)inputFile), (char)'.', (boolean)false, (int)2, null)) {
                ResourceType resourceType;
                String suffix;
                String fileName;
                block12: {
                    char[] cArray = new char[]{'.'};
                    List list = StringsKt.split$default((CharSequence)FilesKt.getNameWithoutExtension((File)inputFile), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    fileName = (String)list.get(0);
                    suffix = (String)list.get(1);
                    ResourceType[] $this$firstOrNull$iv = ResourceType.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        ResourceType element$iv;
                        ResourceType it = element$iv = $this$firstOrNull$iv[j];
                        boolean bl4 = false;
                        if (!StringsKt.startsWith((String)fileName, (String)it.getAccessorName(), (boolean)true)) continue;
                        resourceType = element$iv;
                        break block12;
                    }
                    resourceType = null;
                }
                ResourceType type = resourceType;
                String name = "_collect" + StringUtilsKt.uppercaseFirstChar(suffix) + fileName + "Resources";
                if (type == null) {
                    this.getLogger().warn("Unknown resources type: `" + inputFile + '`');
                    pair = null;
                } else if (!StringsKt.contains$default((CharSequence)FilesKt.readText$default((File)inputFile, null, (int)1, null), (CharSequence)name, (boolean)false, (int)2, null)) {
                    this.getLogger().warn("A function '" + name + "' is not found in the `" + inputFile + "` file!");
                    pair = null;
                } else {
                    this.getLogger().info("Found collector function: `" + name + '`');
                    pair = TuplesKt.to((Object)((Object)type), (Object)name);
                }
            } else {
                this.getLogger().warn("Unknown file name: `" + inputFile + '`');
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-GenerateActualResourceCollectorsTask$safeAction$funNames$42 = false;
            ResourceType key$iv$iv = (ResourceType)((Object)it2.getFirst());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-GenerateActualResourceCollectorsTask$safeAction$funNames$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl7 = false;
            list.add((String)it.getSecond());
        }
        Object funNames = destination$iv$iv2;
        String pkgName = (String)this.getPackageName().get();
        Boolean isPublic = (Boolean)this.getMakeAccessorsPublic().get();
        Boolean useActual = (Boolean)this.getUseActualModifier().get();
        Intrinsics.checkNotNullExpressionValue((Object)pkgName, (String)"pkgName");
        Intrinsics.checkNotNullExpressionValue((Object)isPublic, (String)"isPublic");
        boolean bl8 = isPublic;
        Intrinsics.checkNotNullExpressionValue((Object)useActual, (String)"useActual");
        FileSpec spec = GeneratedResClassSpecKt.getActualResourceCollectorsFileSpec(pkgName, "ActualResourceCollectors", bl8, useActual, (Map<ResourceType, ? extends List<String>>)funNames);
        spec.writeTo(kotlinDir);
    }
}

