/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileSystemOperations;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"isSkikoForCurrentOS", "", "lib", "Ljava/io/File;", "unpackSkikoForCurrentOS", "", "sourceJar", "skikoDir", "fileOperations", "Lorg/gradle/api/file/FileSystemOperations;", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractJPackageTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJPackageTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractJPackageTaskKt\n+ 2 fileUtils.kt\norg/jetbrains/compose/desktop/application/internal/files/FileUtilsKt\n*L\n1#1,795:1\n61#2,8:796\n*S KotlinDebug\n*F\n+ 1 AbstractJPackageTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractJPackageTaskKt\n*L\n783#1:796,8\n*E\n"})
public final class AbstractJPackageTaskKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSkikoForCurrentOS(File lib) {
        String string = lib.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lib.name");
        if (!StringsKt.startsWith$default((String)string, (String)("skiko-awt-runtime-" + OsUtilsKt.getCurrentOS().getId() + '-' + OsUtilsKt.getCurrentArch().getId()), (boolean)false, (int)2, null)) return false;
        String string2 = lib.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lib.name");
        if (!StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<File> unpackSkikoForCurrentOS(File sourceJar, File skikoDir, FileSystemOperations fileOperations) {
        Object[] objectArray;
        Set set;
        switch (WhenMappings.$EnumSwitchMapping$0[OsUtilsKt.getCurrentOS().ordinal()]) {
            case 1: {
                set = SetsKt.setOf((Object)("libskiko-macos-" + OsUtilsKt.getCurrentArch().getId() + ".dylib"));
                break;
            }
            case 2: {
                objectArray = new String[]{"skiko-windows-" + OsUtilsKt.getCurrentArch().getId() + ".dll", "icudtl.dat"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case 3: {
                set = SetsKt.setOf((Object)("libskiko-linux-" + OsUtilsKt.getCurrentArch().getId() + ".so"));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set entriesToUnpack = set;
        ArrayList<File> outputFiles = new ArrayList<File>(entriesToUnpack.size() * 2 + 1);
        String string = sourceJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceJar.name");
        File targetJar = FilesKt.resolve((File)skikoDir, (String)string);
        outputFiles.add(targetJar);
        objectArray = new File[]{skikoDir};
        org.jetbrains.compose.internal.utils.FileUtilsKt.clearDirs(fileOperations, (File[])objectArray);
        boolean $i$f$transformJar = false;
        Closeable closeable = new FileInputStream(sourceJar);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream zin$iv = (ZipInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(targetJar);
            int n2 = 8192;
            closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2));
            Throwable throwable2 = null;
            try {
                ZipOutputStream zout$iv = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                for (ZipEntry sourceEntry$iv : SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zin$iv){
                    final /* synthetic */ ZipInputStream $zin;
                    {
                        this.$zin = $zin;
                        super(0);
                    }

                    public final ZipEntry invoke() {
                        return this.$zin.getNextEntry();
                    }
                }))) {
                    void zout;
                    void zin;
                    ZipOutputStream zipOutputStream = zout$iv;
                    ZipInputStream zipInputStream = zin$iv;
                    ZipEntry entry = sourceEntry$iv;
                    boolean bl3 = false;
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                    if (entriesToUnpack.contains(StringsKt.removeSuffix((String)string2, (CharSequence)".sha256"))) {
                        String string3 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                        File unpackedFile = FilesKt.resolve((File)skikoDir, (String)StringsKt.substringAfterLast$default((String)string3, (String)"/", null, (int)2, null));
                        FileUtilsKt.copyTo((InputStream)zin, unpackedFile);
                        outputFiles.add(unpackedFile);
                        continue;
                    }
                    FileUtilsKt.copyZipEntry(entry, (InputStream)zin, (ZipOutputStream)zout);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return outputFiles;
    }

    public static final /* synthetic */ boolean access$isSkikoForCurrentOS(File lib) {
        return AbstractJPackageTaskKt.isSkikoForCurrentOS(lib);
    }

    public static final /* synthetic */ List access$unpackSkikoForCurrentOS(File sourceJar, File skikoDir, FileSystemOperations fileOperations) {
        return AbstractJPackageTaskKt.unpackSkikoForCurrentOS(sourceJar, skikoDir, fileOperations);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.MacOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

