/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c2\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "", "bundleID", "", "identity", "keychain", "Ljava/io/File;", "prefix", "appStore", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Z)V", "getBundleID", "()Ljava/lang/String;", "fullDeveloperID", "getFullDeveloperID", "getIdentity", "getKeychain", "()Ljava/io/File;", "getPrefix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "compose"})
public final class ValidatedMacOSSigningSettings {
    @NotNull
    private final String bundleID;
    @NotNull
    private final String identity;
    @Nullable
    private final File keychain;
    @NotNull
    private final String prefix;
    private final boolean appStore;

    public ValidatedMacOSSigningSettings(@NotNull String bundleID, @NotNull String identity, @Nullable File keychain, @NotNull String prefix, boolean appStore) {
        Intrinsics.checkNotNullParameter((Object)bundleID, (String)"bundleID");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.bundleID = bundleID;
        this.identity = identity;
        this.keychain = keychain;
        this.prefix = prefix;
        this.appStore = appStore;
    }

    @NotNull
    public final String getBundleID() {
        return this.bundleID;
    }

    @NotNull
    public final String getIdentity() {
        return this.identity;
    }

    @Nullable
    public final File getKeychain() {
        return this.keychain;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getFullDeveloperID() {
        String developerIdPrefix = "Developer ID Application: ";
        String thirdPartyMacDeveloperPrefix = "3rd Party Mac Developer Application: ";
        return StringsKt.startsWith$default((String)this.identity, (String)developerIdPrefix, (boolean)false, (int)2, null) ? this.identity : (StringsKt.startsWith$default((String)this.identity, (String)thirdPartyMacDeveloperPrefix, (boolean)false, (int)2, null) ? this.identity : (!this.appStore ? developerIdPrefix : thirdPartyMacDeveloperPrefix) + this.identity);
    }

    @NotNull
    public final String component1() {
        return this.bundleID;
    }

    @NotNull
    public final String component2() {
        return this.identity;
    }

    @Nullable
    public final File component3() {
        return this.keychain;
    }

    @NotNull
    public final String component4() {
        return this.prefix;
    }

    private final boolean component5() {
        return this.appStore;
    }

    @NotNull
    public final ValidatedMacOSSigningSettings copy(@NotNull String bundleID, @NotNull String identity, @Nullable File keychain, @NotNull String prefix, boolean appStore) {
        Intrinsics.checkNotNullParameter((Object)bundleID, (String)"bundleID");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return new ValidatedMacOSSigningSettings(bundleID, identity, keychain, prefix, appStore);
    }

    public static /* synthetic */ ValidatedMacOSSigningSettings copy$default(ValidatedMacOSSigningSettings validatedMacOSSigningSettings, String string, String string2, File file2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = validatedMacOSSigningSettings.bundleID;
        }
        if ((n & 2) != 0) {
            string2 = validatedMacOSSigningSettings.identity;
        }
        if ((n & 4) != 0) {
            file2 = validatedMacOSSigningSettings.keychain;
        }
        if ((n & 8) != 0) {
            string3 = validatedMacOSSigningSettings.prefix;
        }
        if ((n & 0x10) != 0) {
            bl = validatedMacOSSigningSettings.appStore;
        }
        return validatedMacOSSigningSettings.copy(string, string2, file2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "ValidatedMacOSSigningSettings(bundleID=" + this.bundleID + ", identity=" + this.identity + ", keychain=" + this.keychain + ", prefix=" + this.prefix + ", appStore=" + this.appStore + ')';
    }

    public int hashCode() {
        int result2 = this.bundleID.hashCode();
        result2 = result2 * 31 + this.identity.hashCode();
        result2 = result2 * 31 + (this.keychain == null ? 0 : this.keychain.hashCode());
        result2 = result2 * 31 + this.prefix.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.appStore);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidatedMacOSSigningSettings)) {
            return false;
        }
        ValidatedMacOSSigningSettings validatedMacOSSigningSettings = (ValidatedMacOSSigningSettings)other;
        if (!Intrinsics.areEqual((Object)this.bundleID, (Object)validatedMacOSSigningSettings.bundleID)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.identity, (Object)validatedMacOSSigningSettings.identity)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keychain, (Object)validatedMacOSSigningSettings.keychain)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prefix, (Object)validatedMacOSSigningSettings.prefix)) {
            return false;
        }
        return this.appStore == validatedMacOSSigningSettings.appStore;
    }
}

