/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xcode;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class XcodeInstallation
extends ToolInstallation
implements NodeSpecific<XcodeInstallation>,
EnvironmentSpecific<XcodeInstallation> {
    @DataBoundConstructor
    public XcodeInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public static XcodeInstallation[] allInstallations() {
        XcodeInstallation[] installations;
        DescriptorImpl descriptor;
        Jenkins instance = Jenkins.getInstance();
        if (instance != null && (descriptor = (DescriptorImpl)instance.getDescriptorByType(DescriptorImpl.class)) != null && (installations = (XcodeInstallation[])descriptor.getInstallations()) != null) {
            return installations;
        }
        return new XcodeInstallation[0];
    }

    public String getXcodebuild() {
        return this.getHome() + "/usr/bin/xcodebuild";
    }

    private static XcodeInstallation[] getInstallations(DescriptorImpl descriptor) {
        XcodeInstallation[] installations = null;
        try {
            installations = (XcodeInstallation[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new XcodeInstallation[]{};
        }
        return installations;
    }

    public XcodeInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new XcodeInstallation(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public XcodeInstallation forEnvironment(EnvVars environment) {
        return new XcodeInstallation(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance == null) {
            throw new AssertionError((Object)"No Jenkins instance");
        }
        return (DescriptorImpl)jenkinsInstance.getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    @Symbol(value={"xcode"})
    public static class DescriptorImpl
    extends ToolDescriptor<XcodeInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Xcode tools";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(this.clazz, json.get("tool")).toArray(new XcodeInstallation[0]));
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            String path = value.getPath() + "/usr/bin/xcodebuild";
            return FormValidation.validateExecutable((String)path);
        }

        public XcodeInstallation getInstallation(String name) {
            for (XcodeInstallation i : (XcodeInstallation[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

