/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh.report;

import au.com.rayh.report.TestCase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="testsuite")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TestSuite {
    @XmlAttribute
    int failures;
    @XmlAttribute
    int errors;
    @XmlAttribute
    String hostname;
    @XmlAttribute
    String name;
    @XmlAttribute
    int tests;
    @XmlAttribute
    float time;
    @XmlAttribute(name="timestamp")
    Date endTime;
    @XmlElement(name="testcase")
    List<TestCase> testcases = new ArrayList<TestCase>();
    @XmlTransient
    Date startTime;
    HashMap<String, TestCase> testCasesHash = new HashMap();

    public TestSuite() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "URF_UNREAD_FIELD"})
    public TestSuite(String hostname, String name, Date startTime) {
        this.hostname = hostname;
        this.name = name;
        this.startTime = startTime;
    }

    public void setDuration(Float duration) {
        this.time = duration.floatValue();
    }

    public HashMap<String, TestCase> getTestCasesHash() {
        return this.testCasesHash;
    }

    public void setTestCasesHash(HashMap<String, TestCase> testCasesHash) {
        this.testCasesHash = testCasesHash;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getTests() {
        return this.tests;
    }

    public void addFailure() {
        ++this.failures;
    }

    public void addError() {
        ++this.errors;
    }

    public void addTest() {
        ++this.tests;
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Date getStartTime() {
        return this.startTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "URF_UNREAD_FIELD"})
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.time = (float)(endTime.getTime() - this.startTime.getTime()) / 1000.0f;
    }

    public List<TestCase> getTestCases() {
        return this.testcases;
    }
}

