/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.BuildConfiguration;
import au.com.rayh.DSymFileFilter;
import au.com.rayh.GlobalConfigurationImpl;
import au.com.rayh.InfoPlist;
import au.com.rayh.JenkinsXCodeBuildOutputParser;
import au.com.rayh.Keychain;
import au.com.rayh.KeychainPasswordAndPath;
import au.com.rayh.Messages;
import au.com.rayh.ProjectScheme;
import au.com.rayh.ProjectTarget;
import au.com.rayh.ProvisioningProfile;
import au.com.rayh.Team;
import au.com.rayh.XCArchiveFileFilter;
import au.com.rayh.XCodeAction;
import au.com.rayh.XcodeBuildHelpParser;
import au.com.rayh.XcodeBuildListParser;
import au.com.rayh.XcodeProject;
import au.com.rayh.XcodeProjectFileFilter;
import au.com.rayh.XcodeProjectParser;
import au.com.rayh.XcodeTestSummariesParser;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.xcode.XcodeInstallation;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.QuotedStringTokenizer;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class XCodeBuilder
extends Builder
implements SimpleBuildStep {
    private static final int SIGTERM = 143;
    private static final String DEVELOPMENT_ENV = "Development";
    private static final String PRODUCTION_ENV = "Production";
    private static final String DEV_SIGNING_CERTIFICATE_SELECTOR = "iOS Developer";
    private static final String DIST_SIGNING_CERTIFICATE_SELECTOR = "iOS Distribution";
    private static final String[] VALID_IPA_EXPORT_METHODS = new String[]{"development", "ad-hoc", "enterprise", "app-store"};
    @CheckForNull
    private Boolean cleanBeforeBuild;
    @CheckForNull
    private Boolean cleanTestReports;
    @CheckForNull
    private String configuration;
    @CheckForNull
    private String target;
    @CheckForNull
    private String sdk;
    @CheckForNull
    private String symRoot;
    @CheckForNull
    private String buildDir;
    @CheckForNull
    private String xcodeProjectPath;
    @CheckForNull
    private String xcodeProjectFile;
    @CheckForNull
    private String xcodebuildArguments;
    @CheckForNull
    private String xcodeSchema;
    @CheckForNull
    private String xcodeWorkspaceFile;
    @CheckForNull
    private String cfBundleVersionValue;
    @CheckForNull
    private String cfBundleShortVersionStringValue;
    @CheckForNull
    private Boolean buildIpa;
    @CheckForNull
    private String ipaExportMethod;
    @CheckForNull
    private Boolean generateArchive;
    @CheckForNull
    private Boolean noConsoleLog;
    @CheckForNull
    private String logfileOutputDirectory;
    @CheckForNull
    private Boolean unlockKeychain;
    @Deprecated
    @CheckForNull
    private String keychainName;
    @CheckForNull
    private String keychainId;
    @CheckForNull
    private String keychainPath;
    @CheckForNull
    private Secret keychainPwd;
    @CheckForNull
    private String developmentTeamName;
    @CheckForNull
    private String developmentTeamID;
    @CheckForNull
    private Boolean allowFailingBuildResults;
    @CheckForNull
    private String ipaName;
    @CheckForNull
    private String ipaOutputDirectory;
    @CheckForNull
    private Boolean provideApplicationVersion;
    @CheckForNull
    private Boolean changeBundleID;
    @CheckForNull
    private String bundleID;
    @CheckForNull
    private String bundleIDInfoPlistPath;
    @CheckForNull
    private Boolean interpretTargetAsRegEx;
    @CheckForNull
    private String signingMethod;
    @CheckForNull
    private ArrayList<ProvisioningProfile> provisioningProfiles;
    @CheckForNull
    private String xcodeName;
    @CheckForNull
    private Boolean uploadBitcode;
    @CheckForNull
    private Boolean uploadSymbols;
    @CheckForNull
    private Boolean compileBitcode;
    @CheckForNull
    private String thinning;
    @CheckForNull
    private Boolean embedOnDemandResourcesAssetPacksInBundle;
    @CheckForNull
    private String onDemandResourcesAssetPacksBaseURL;
    @CheckForNull
    private String appURL;
    @CheckForNull
    private String displayImageURL;
    @CheckForNull
    private String fullSizeImageURL;
    @CheckForNull
    private String assetPackManifestURL;
    @CheckForNull
    private Boolean skipBuildStep = false;
    @CheckForNull
    private Boolean stripSwiftSymbols;
    @CheckForNull
    private Boolean copyProvisioningProfile;
    @CheckForNull
    private Boolean useLegacyBuildSystem;
    @CheckForNull
    private Boolean ignoreTestResults;
    @CheckForNull
    private String resultBundlePath;
    @CheckForNull
    private Boolean cleanResultBundlePath;

    public Boolean getCleanBeforeBuild() {
        return this.cleanBeforeBuild == null ? Boolean.valueOf(true) : this.cleanBeforeBuild;
    }

    @DataBoundSetter
    public void setCleanBeforeBuild(Boolean cleanBeforeBuild) {
        this.cleanBeforeBuild = cleanBeforeBuild;
    }

    public Boolean getCleanTestReports() {
        return this.cleanTestReports == null ? Boolean.valueOf(false) : this.cleanTestReports;
    }

    @DataBoundSetter
    public void setCleanTestReports(Boolean cleanTestReports) {
        this.cleanTestReports = cleanTestReports;
    }

    @CheckForNull
    public String getConfiguration() {
        return this.configuration;
    }

    @DataBoundSetter
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @CheckForNull
    public String getTarget() {
        return this.target;
    }

    @DataBoundSetter
    public void setTarget(String target) {
        this.target = target;
    }

    @CheckForNull
    public String getSdk() {
        return this.sdk;
    }

    @DataBoundSetter
    public void setSdk(String sdk) {
        this.sdk = sdk;
    }

    @CheckForNull
    public String getSymRoot() {
        return this.symRoot;
    }

    @DataBoundSetter
    public void setSymRoot(String symRoot) {
        this.symRoot = symRoot;
    }

    @CheckForNull
    public String getBuildDir() {
        return this.buildDir;
    }

    @DataBoundSetter
    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    @CheckForNull
    public String getXcodeProjectPath() {
        return this.xcodeProjectPath;
    }

    @DataBoundSetter
    public void setXcodeProjectPath(String xcodeProjectPath) {
        this.xcodeProjectPath = xcodeProjectPath;
    }

    @CheckForNull
    public String getXcodeProjectFile() {
        return this.xcodeProjectFile;
    }

    @DataBoundSetter
    public void setXcodeProjectFile(String xcodeProjectFile) {
        this.xcodeProjectFile = xcodeProjectFile;
    }

    @CheckForNull
    public String getXcodebuildArguments() {
        return this.xcodebuildArguments;
    }

    @DataBoundSetter
    public void setXcodebuildArguments(String xcodebuildArguments) {
        this.xcodebuildArguments = xcodebuildArguments;
    }

    @CheckForNull
    public String getXcodeSchema() {
        return this.xcodeSchema;
    }

    @DataBoundSetter
    public void setXcodeSchema(String xcodeSchema) {
        this.xcodeSchema = xcodeSchema;
    }

    @CheckForNull
    public String getXcodeWorkspaceFile() {
        return this.xcodeWorkspaceFile;
    }

    @DataBoundSetter
    public void setXcodeWorkspaceFile(String xcodeWorkspaceFile) {
        this.xcodeWorkspaceFile = xcodeWorkspaceFile;
    }

    @CheckForNull
    public String getCfBundleVersionValue() {
        return this.cfBundleVersionValue;
    }

    @DataBoundSetter
    public void setCfBundleVersionValue(String cfBundleVersionValue) {
        this.cfBundleVersionValue = cfBundleVersionValue;
    }

    @CheckForNull
    public String getCfBundleShortVersionStringValue() {
        return this.cfBundleShortVersionStringValue;
    }

    @DataBoundSetter
    public void setCfBundleShortVersionStringValue(String cfBundleShortVersionStringValue) {
        this.cfBundleShortVersionStringValue = cfBundleShortVersionStringValue;
    }

    public Boolean getBuildIpa() {
        return this.buildIpa == null ? Boolean.valueOf(false) : this.buildIpa;
    }

    @DataBoundSetter
    public void setBuildIpa(Boolean buildIpa) {
        this.buildIpa = buildIpa;
    }

    public String getIpaExportMethod() {
        return this.ipaExportMethod == null ? "app-store" : this.ipaExportMethod;
    }

    @DataBoundSetter
    public void setIpaExportMethod(String ipaExportMethod) {
        this.ipaExportMethod = ipaExportMethod;
    }

    public Boolean getGenerateArchive() {
        return this.generateArchive == null ? Boolean.valueOf(false) : this.generateArchive;
    }

    @DataBoundSetter
    public void setGenerateArchive(Boolean generateArchive) {
        this.generateArchive = generateArchive;
    }

    public Boolean getNoConsoleLog() {
        return this.noConsoleLog == null ? Boolean.valueOf(false) : this.noConsoleLog;
    }

    @DataBoundSetter
    public void setNoConsoleLog(Boolean noConsoleLog) {
        this.noConsoleLog = noConsoleLog;
    }

    @CheckForNull
    public String getLogfileOutputDirectory() {
        return this.logfileOutputDirectory;
    }

    @DataBoundSetter
    public void setLogfileOutputDirectory(String logfileOutputDirectory) {
        this.logfileOutputDirectory = logfileOutputDirectory;
    }

    public Boolean getUnlockKeychain() {
        return this.unlockKeychain == null ? Boolean.valueOf(false) : this.unlockKeychain;
    }

    @DataBoundSetter
    public void setUnlockKeychain(Boolean unlockKeychain) {
        this.unlockKeychain = unlockKeychain;
    }

    @Deprecated
    @CheckForNull
    public String getKeychainName() {
        return this.keychainName;
    }

    @CheckForNull
    public String getKeychainId() {
        return this.keychainId;
    }

    @Deprecated
    @DataBoundSetter
    public void setKeychainName(String keychainName) {
        this.keychainName = keychainName;
    }

    @DataBoundSetter
    public void setKeychainId(String keychainId) {
        this.keychainId = keychainId;
    }

    @CheckForNull
    public String getKeychainPath() {
        return this.keychainPath;
    }

    @DataBoundSetter
    public void setKeychainPath(String keychainPath) {
        this.keychainPath = keychainPath;
    }

    @CheckForNull
    public Secret getKeychainPwd() {
        return this.keychainPwd;
    }

    @DataBoundSetter
    public void setKeychainPwd(Secret keychainPwd) {
        this.keychainPwd = keychainPwd;
    }

    @CheckForNull
    public String getDevelopmentTeamName() {
        return this.developmentTeamName;
    }

    @DataBoundSetter
    public void setDevelopmentTeamName(String developmentTeamName) {
        this.developmentTeamName = developmentTeamName;
    }

    @CheckForNull
    public String getDevelopmentTeamID() {
        return this.developmentTeamID;
    }

    @DataBoundSetter
    public void setDevelopmentTeamID(String developmentTeamID) {
        this.developmentTeamID = developmentTeamID;
    }

    public Boolean getAllowFailingBuildResults() {
        return this.allowFailingBuildResults == null ? Boolean.valueOf(false) : this.allowFailingBuildResults;
    }

    @DataBoundSetter
    public void setAllowFailingBuildResults(Boolean allowFailingBuildResults) {
        this.allowFailingBuildResults = allowFailingBuildResults;
    }

    @CheckForNull
    public String getIpaName() {
        return this.ipaName;
    }

    @DataBoundSetter
    public void setIpaName(String ipaName) {
        this.ipaName = ipaName;
    }

    @CheckForNull
    public String getIpaOutputDirectory() {
        return this.ipaOutputDirectory;
    }

    @DataBoundSetter
    public void setIpaOutputDirectory(String ipaOutputDirectory) {
        this.ipaOutputDirectory = ipaOutputDirectory;
    }

    public Boolean getProvideApplicationVersion() {
        return this.provideApplicationVersion == null ? Boolean.valueOf(false) : this.provideApplicationVersion;
    }

    @DataBoundSetter
    public void setProvideApplicationVersion(Boolean provideApplicationVersion) {
        this.provideApplicationVersion = provideApplicationVersion;
    }

    public Boolean getChangeBundleID() {
        return this.changeBundleID == null ? Boolean.valueOf(false) : this.changeBundleID;
    }

    @DataBoundSetter
    public void setChangeBundleID(Boolean changeBundleID) {
        this.changeBundleID = changeBundleID;
    }

    @CheckForNull
    public String getBundleID() {
        return this.bundleID;
    }

    @DataBoundSetter
    public void setBundleID(String bundleID) {
        this.bundleID = bundleID;
    }

    @CheckForNull
    public String getBundleIDInfoPlistPath() {
        return this.bundleIDInfoPlistPath;
    }

    @DataBoundSetter
    public void setBundleIDInfoPlistPath(String bundleIDInfoPlistPath) {
        this.bundleIDInfoPlistPath = bundleIDInfoPlistPath;
    }

    public Boolean getInterpretTargetAsRegEx() {
        return this.interpretTargetAsRegEx == null ? Boolean.valueOf(false) : this.interpretTargetAsRegEx;
    }

    @DataBoundSetter
    public void setInterpretTargetAsRegEx(Boolean interpretTargetAsRegEx) {
        this.interpretTargetAsRegEx = interpretTargetAsRegEx;
    }

    @Deprecated
    public Boolean getManualSigning() {
        return this.signingMethod == null || this.signingMethod.equals("manual");
    }

    @Deprecated
    @DataBoundSetter
    public void setManualSigning(Boolean manualSigning) {
        this.signingMethod = BooleanUtils.isTrue((Boolean)manualSigning) ? "manual" : "automatic";
    }

    public String getSigningMethod() {
        return this.signingMethod == null ? "automatic" : this.signingMethod;
    }

    @DataBoundSetter
    public void setSigningMethod(String signingMethod) {
        this.signingMethod = signingMethod;
    }

    @CheckForNull
    public ArrayList<ProvisioningProfile> getProvisioningProfiles() {
        return this.provisioningProfiles;
    }

    @DataBoundSetter
    public void setProvisioningProfiles(ArrayList<ProvisioningProfile> provisioningProfiles) {
        this.provisioningProfiles = provisioningProfiles;
    }

    @CheckForNull
    public String getXcodeName() {
        return this.xcodeName;
    }

    @DataBoundSetter
    public void setXcodeName(String xcodeName) {
        this.xcodeName = xcodeName;
    }

    public Boolean getUploadBitcode() {
        return this.uploadBitcode == null ? Boolean.valueOf(true) : this.uploadBitcode;
    }

    @DataBoundSetter
    public void setUploadBitcode(Boolean uploadBitcode) {
        this.uploadBitcode = uploadBitcode;
    }

    public Boolean getUploadSymbols() {
        return this.uploadSymbols == null ? Boolean.valueOf(true) : this.uploadSymbols;
    }

    @DataBoundSetter
    public void setUploadSymbols(Boolean uploadSymbols) {
        this.uploadSymbols = uploadSymbols;
    }

    public Boolean getCompileBitcode() {
        return this.compileBitcode == null ? Boolean.valueOf(true) : this.compileBitcode;
    }

    @DataBoundSetter
    public void setCompileBitcode(Boolean compileBitcode) {
        this.compileBitcode = compileBitcode;
    }

    @CheckForNull
    public String getThinning() {
        return this.thinning;
    }

    @DataBoundSetter
    public void setThinning(String thinning) {
        this.thinning = thinning;
    }

    public Boolean getAssetPacksInBundle() {
        return this.embedOnDemandResourcesAssetPacksInBundle == null ? Boolean.valueOf(true) : this.embedOnDemandResourcesAssetPacksInBundle;
    }

    @DataBoundSetter
    public void setAssetPacksInBundle(Boolean assetPacksInBundle) {
        this.embedOnDemandResourcesAssetPacksInBundle = assetPacksInBundle;
    }

    @CheckForNull
    public String getAssetPacksBaseURL() {
        return this.onDemandResourcesAssetPacksBaseURL;
    }

    @DataBoundSetter
    public void setAssetPacksBaseURL(String assetPacksBaseURL) {
        this.onDemandResourcesAssetPacksBaseURL = assetPacksBaseURL;
    }

    @CheckForNull
    public String getAppURL() {
        return this.appURL;
    }

    @DataBoundSetter
    public void setAppURL(String appURL) {
        this.appURL = appURL;
    }

    @CheckForNull
    public String getDisplayImageURL() {
        return this.displayImageURL;
    }

    @DataBoundSetter
    public void setDisplayImageURL(String displayImageURL) {
        this.displayImageURL = displayImageURL;
    }

    @CheckForNull
    public String getFullSizeImageURL() {
        return this.fullSizeImageURL;
    }

    @DataBoundSetter
    public void setFullSizeImageURL(String fullSizeImageURL) {
        this.fullSizeImageURL = fullSizeImageURL;
    }

    @CheckForNull
    public String getAssetPackManifestURL() {
        return this.assetPackManifestURL;
    }

    @DataBoundSetter
    public void setAssetPackManifestURL(String assetPackManifestURL) {
        this.assetPackManifestURL = assetPackManifestURL;
    }

    public Boolean getStripSwiftSymbols() {
        return this.stripSwiftSymbols == null ? Boolean.valueOf(true) : this.stripSwiftSymbols;
    }

    @DataBoundSetter
    public void setStripSwiftSymbols(Boolean stripSwiftSymbols) {
        this.stripSwiftSymbols = stripSwiftSymbols;
    }

    public Boolean getCopyProvisioningProfile() {
        return this.copyProvisioningProfile == null ? Boolean.valueOf(true) : this.copyProvisioningProfile;
    }

    @DataBoundSetter
    public void setCopyProvisioningProfile(Boolean copyProvisioningProfile) {
        this.copyProvisioningProfile = copyProvisioningProfile;
    }

    public Boolean getUseLegacyBuildSystem() {
        return this.useLegacyBuildSystem == null ? Boolean.valueOf(false) : this.useLegacyBuildSystem;
    }

    @DataBoundSetter
    public void setUseLegacyBuildSystem(Boolean useLegacyBuildSystem) {
        this.useLegacyBuildSystem = useLegacyBuildSystem;
    }

    public Boolean getIgnoreTestResults() {
        return this.ignoreTestResults == null ? Boolean.valueOf(false) : this.ignoreTestResults;
    }

    @DataBoundSetter
    public void setIgnoreTestResults(Boolean ignoreTestResults) {
        this.ignoreTestResults = ignoreTestResults;
    }

    public String getResultBundlePath() {
        return this.resultBundlePath;
    }

    @DataBoundSetter
    public void setResultBundlePath(String resultBundlePath) {
        this.resultBundlePath = resultBundlePath;
    }

    @DataBoundSetter
    public void setCleanResultBundlePath(Boolean cleanResultBundlePath) {
        this.cleanResultBundlePath = cleanResultBundlePath;
    }

    public Boolean getCleanResultBundlePath() {
        return this.cleanResultBundlePath == null ? Boolean.valueOf(true) : this.cleanResultBundlePath;
    }

    public void setSkipBuildStep(Boolean skipBuildStep) {
        this.skipBuildStep = skipBuildStep;
    }

    @DataBoundConstructor
    public XCodeBuilder() {
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean noConsoleLog, String logfileOutputDirectory, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String buildDir, String developmentTeamName, String developmentTeamID, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, Boolean interpretTargetAsRegEx, String ipaExportMethod, String signingMethod, ArrayList<ProvisioningProfile> provisioningProfiles, String xcodeName, Boolean uploadBitcode, Boolean uploadSymbols, Boolean compileBitcode, String thinning, Boolean embedOnDemandResourcesAssetPacksInBundle, String onDemandResourcesAssetPacksBaseURL, String appURL, String displayImageURL, String fullSizeImageURL, String assetPackManifestURL) {
        this();
        this.buildIpa = buildIpa;
        this.generateArchive = generateArchive;
        this.noConsoleLog = noConsoleLog;
        this.logfileOutputDirectory = logfileOutputDirectory;
        this.sdk = sdk;
        this.target = target;
        this.cleanBeforeBuild = cleanBeforeBuild;
        this.cleanTestReports = cleanTestReports;
        this.configuration = configuration;
        this.xcodeProjectPath = xcodeProjectPath;
        this.xcodeProjectFile = xcodeProjectFile;
        this.xcodebuildArguments = xcodebuildArguments;
        this.keychainName = keychainName;
        this.xcodeWorkspaceFile = xcodeWorkspaceFile;
        this.xcodeSchema = xcodeSchema;
        this.developmentTeamName = developmentTeamName;
        this.developmentTeamID = developmentTeamID;
        this.cfBundleVersionValue = cfBundleVersionValue;
        this.cfBundleShortVersionStringValue = cfBundleShortVersionStringValue;
        this.unlockKeychain = unlockKeychain;
        this.keychainPath = keychainPath;
        this.keychainPwd = Secret.fromString((String)keychainPwd);
        this.symRoot = symRoot;
        this.buildDir = buildDir;
        this.allowFailingBuildResults = allowFailingBuildResults;
        this.ipaName = ipaName;
        this.ipaOutputDirectory = ipaOutputDirectory;
        this.provideApplicationVersion = provideApplicationVersion;
        this.changeBundleID = changeBundleID;
        this.bundleID = bundleID;
        this.bundleIDInfoPlistPath = bundleIDInfoPlistPath;
        this.interpretTargetAsRegEx = interpretTargetAsRegEx;
        this.ipaExportMethod = ipaExportMethod;
        this.signingMethod = signingMethod;
        this.provisioningProfiles = provisioningProfiles;
        this.xcodeName = xcodeName;
        this.uploadBitcode = uploadBitcode;
        this.uploadSymbols = uploadSymbols;
        this.compileBitcode = compileBitcode;
        this.thinning = thinning;
        this.embedOnDemandResourcesAssetPacksInBundle = embedOnDemandResourcesAssetPacksInBundle;
        this.onDemandResourcesAssetPacksBaseURL = onDemandResourcesAssetPacksBaseURL;
        this.appURL = appURL;
        this.displayImageURL = displayImageURL;
        this.fullSizeImageURL = fullSizeImageURL;
        this.assetPackManifestURL = assetPackManifestURL;
        this.stripSwiftSymbols = true;
        this.skipBuildStep = false;
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean noConsoleLog, String logfileOutputDirectory, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String buildDir, String developmentTeamName, String developmentTeamID, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, String ipaManifestPlistUrl, Boolean interpretTargetAsRegEx, String ipaExportMethod, String signingMethod, ArrayList<ProvisioningProfile> provisioningProfiles, String xcodeName) {
        this(buildIpa, generateArchive, noConsoleLog, logfileOutputDirectory, cleanBeforeBuild, cleanTestReports, configuration, target, sdk, xcodeProjectPath, xcodeProjectFile, xcodebuildArguments, cfBundleVersionValue, cfBundleShortVersionStringValue, unlockKeychain, keychainName, keychainPath, keychainPwd, symRoot, xcodeWorkspaceFile, xcodeSchema, buildDir, developmentTeamName, developmentTeamID, allowFailingBuildResults, ipaName, provideApplicationVersion, ipaOutputDirectory, changeBundleID, bundleID, bundleIDInfoPlistPath, interpretTargetAsRegEx, ipaExportMethod, signingMethod, provisioningProfiles, xcodeName, true, true, true, null, false, null, ipaManifestPlistUrl, null, null, null);
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean noConsoleLog, String logfileOutputDirectory, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String buildDir, String developmentTeamName, String developmentTeamID, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, String ipaManifestPlistUrl, Boolean interpretTargetAsRegEx, String ipaExportMethod, Boolean manualSigning, ArrayList<ProvisioningProfile> provisioningProfiles) {
        this(buildIpa, generateArchive, noConsoleLog, logfileOutputDirectory, cleanBeforeBuild, cleanTestReports, configuration, target, sdk, xcodeProjectPath, xcodeProjectFile, xcodebuildArguments, cfBundleVersionValue, cfBundleShortVersionStringValue, unlockKeychain, keychainName, keychainPath, keychainPwd, symRoot, xcodeWorkspaceFile, xcodeSchema, buildDir, developmentTeamName, developmentTeamID, allowFailingBuildResults, ipaName, provideApplicationVersion, ipaOutputDirectory, changeBundleID, bundleID, bundleIDInfoPlistPath, ipaManifestPlistUrl, interpretTargetAsRegEx, ipaExportMethod, manualSigning != false ? "manual" : "automatic", provisioningProfiles, null);
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean noConsoleLog, String logfileOutputDirectory, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String buildDir, String developmentTeamName, String developmentTeamID, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, String ipaManifestPlistUrl, Boolean interpretTargetAsRegEx, String ipaExportMethod) {
        this(buildIpa, generateArchive, noConsoleLog, logfileOutputDirectory, cleanBeforeBuild, cleanTestReports, configuration, target, sdk, xcodeProjectPath, xcodeProjectFile, xcodebuildArguments, cfBundleVersionValue, cfBundleShortVersionStringValue, unlockKeychain, keychainName, keychainPath, keychainPwd, symRoot, xcodeWorkspaceFile, xcodeSchema, buildDir, developmentTeamName, developmentTeamID, allowFailingBuildResults, ipaName, provideApplicationVersion, ipaOutputDirectory, changeBundleID, bundleID, bundleIDInfoPlistPath, ipaManifestPlistUrl, interpretTargetAsRegEx, ipaExportMethod, true, null);
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String buildDir, String developmentTeamName, String developmentTeamID, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, String ipaManifestPlistUrl, Boolean interpretTargetAsRegEx, String ipaExportMethod) {
        this(buildIpa, generateArchive, false, null, cleanBeforeBuild, cleanTestReports, configuration, target, sdk, xcodeProjectPath, xcodeProjectFile, xcodebuildArguments, cfBundleVersionValue, cfBundleShortVersionStringValue, unlockKeychain, keychainName, keychainPath, keychainPwd, symRoot, xcodeWorkspaceFile, xcodeSchema, buildDir, developmentTeamName, developmentTeamID, allowFailingBuildResults, ipaName, provideApplicationVersion, ipaOutputDirectory, changeBundleID, bundleID, bundleIDInfoPlistPath, ipaManifestPlistUrl, interpretTargetAsRegEx, ipaExportMethod);
    }

    @Deprecated
    public XCodeBuilder(Boolean buildIpa, Boolean generateArchive, Boolean cleanBeforeBuild, Boolean cleanTestReports, String configuration, String target, String sdk, String xcodeProjectPath, String xcodeProjectFile, String xcodebuildArguments, String embeddedProfileFile, String cfBundleVersionValue, String cfBundleShortVersionStringValue, Boolean unlockKeychain, String keychainName, String keychainPath, String keychainPwd, String symRoot, String xcodeWorkspaceFile, String xcodeSchema, String configurationBuildDir, String codeSigningIdentity, Boolean allowFailingBuildResults, String ipaName, Boolean provideApplicationVersion, String ipaOutputDirectory, Boolean changeBundleID, String bundleID, String bundleIDInfoPlistPath, String ipaManifestPlistUrl, Boolean interpretTargetAsRegEx, Boolean signIpaOnXcrun) {
        this(buildIpa, generateArchive, false, null, cleanBeforeBuild, cleanTestReports, configuration, target, sdk, xcodeProjectPath, xcodeProjectFile, xcodebuildArguments, cfBundleVersionValue, cfBundleShortVersionStringValue, unlockKeychain, keychainName, keychainPath, keychainPwd, symRoot, xcodeWorkspaceFile, xcodeSchema, configurationBuildDir, "", "", allowFailingBuildResults, ipaName, provideApplicationVersion, ipaOutputDirectory, changeBundleID, bundleID, bundleIDInfoPlistPath, ipaManifestPlistUrl, interpretTargetAsRegEx, "ad-hoc");
    }

    private Object readResolve() throws ObjectStreamException {
        if (!(this.provideApplicationVersion != null || StringUtils.isEmpty((String)this.cfBundleVersionValue) && StringUtils.isEmpty((String)this.cfBundleShortVersionStringValue))) {
            this.provideApplicationVersion = true;
        }
        return this;
    }

    public void perform(Run<?, ?> build, FilePath filePath, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean result = this._perform(build, filePath, launcher, build.getEnvironment(listener), listener);
        if (!result) {
            throw new AbortException(Messages.XCodeBuilder_AbortXcodeBuildFailed());
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this._perform((Run<?, ?>)build, build.getWorkspace(), launcher, build.getEnvironment((TaskListener)listener), (TaskListener)listener);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private boolean _perform(Run<?, ?> build, FilePath projectRoot, Launcher launcher, EnvVars envs, TaskListener listener) throws InterruptedException, IOException {
        FilePath profilesLibPath;
        FilePath provisioningProfilePath;
        FilePath homePath;
        String provisioningProfileName;
        String provisioningProfileUUID;
        void var44_58;
        boolean bl;
        boolean timedOut2;
        Jenkins jenkinsInstance;
        XcodeInstallation.DescriptorImpl descriptor;
        XcodeInstallation[] installations;
        if (!new FilePath(projectRoot.getChannel(), this.getGlobalConfiguration().getXcodebuildPath()).exists()) {
            listener.fatalError(Messages.XCodeBuilder_xcodebuildNotFound(this.getGlobalConfiguration().getXcodebuildPath()));
            return false;
        }
        if (!new FilePath(projectRoot.getChannel(), this.getGlobalConfiguration().getAgvtoolPath()).exists()) {
            listener.fatalError(Messages.XCodeBuilder_avgtoolNotFound(this.getGlobalConfiguration().getAgvtoolPath()));
            return false;
        }
        String configuration = envs.expand(this.configuration);
        String target = envs.expand(this.target);
        String sdk = envs.expand(this.sdk);
        String symRoot = envs.expand(this.symRoot);
        String buildDir = envs.expand(this.buildDir);
        String xcodeProjectPath = envs.expand(this.xcodeProjectPath);
        String xcodeProjectFile = envs.expand(this.xcodeProjectFile);
        String xcodebuildArguments = envs.expand(this.xcodebuildArguments);
        String xcodeSchema = envs.expand(this.xcodeSchema);
        String xcodeWorkspaceFile = envs.expand(this.xcodeWorkspaceFile);
        String cfBundleVersionValue = envs.expand(this.cfBundleVersionValue);
        String cfBundleShortVersionStringValue = envs.expand(this.cfBundleShortVersionStringValue);
        String ipaName = envs.expand(this.ipaName);
        String ipaOutputDirectory = envs.expand(this.ipaOutputDirectory);
        String bundleID = envs.expand(this.bundleID);
        String bundleIDInfoPlistPath = envs.expand(this.bundleIDInfoPlistPath);
        String ipaExportMethod = envs.expand(this.ipaExportMethod);
        String thinning = envs.expand(this.thinning);
        String onDemandResourcesAssetPacksBaseURL = envs.expand(this.onDemandResourcesAssetPacksBaseURL);
        String appURL = envs.expand(this.appURL);
        String displayImageURL = envs.expand(this.displayImageURL);
        String fullSizeImageURL = envs.expand(this.fullSizeImageURL);
        String assetPackManifestURL = envs.expand(this.assetPackManifestURL);
        if (!StringUtils.isEmpty((String)xcodeProjectPath)) {
            projectRoot = projectRoot.child(xcodeProjectPath);
        }
        listener.getLogger().println(Messages.XCodeBuilder_workingDir(projectRoot));
        if (!StringUtils.isEmpty((String)this.xcodeName) && (installations = (XcodeInstallation[])(descriptor = (XcodeInstallation.DescriptorImpl)(jenkinsInstance = Jenkins.getInstance()).getDescriptor(XcodeInstallation.class)).getInstallations()) != null) {
            for (XcodeInstallation installation : installations) {
                if (!installation.getName().equals(this.xcodeName)) continue;
                envs.put("DEVELOPER_DIR", installation.getHome());
                listener.getLogger().println(Messages.XCodeBuilder_XcodeToolsDir(installation.getHome()));
                break;
            }
        }
        String buildPlatform = "iphoneos";
        if (!StringUtils.isEmpty((String)sdk) && StringUtils.contains((String)sdk.toLowerCase(), (String)"iphonesimulator")) {
            buildPlatform = "iphonesimulator";
        }
        String symRootValue = null;
        if (!StringUtils.isEmpty((String)symRoot)) {
            try {
                symRootValue = TokenMacro.expandAll(build, (FilePath)projectRoot, (TaskListener)listener, (String)symRoot).trim();
            }
            catch (MacroEvaluationException e) {
                listener.error(Messages.XCodeBuilder_symRootMacroError(e.getMessage()));
                return false;
            }
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        listener.getLogger().println(Messages.XCodeBuilder_fetchingCFBundleShortVersionString());
        String cfBundleShortVersionString = "";
        int returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getAgvtoolPath(), "mvers", "-terse1"}).stdout((OutputStream)output).pwd(projectRoot).join();
        if (returnCode == 0) {
            cfBundleShortVersionString = output.toString().trim();
        }
        if (StringUtils.isEmpty((String)cfBundleShortVersionString)) {
            listener.getLogger().println(Messages.XCodeBuilder_CFBundleShortVersionStringNotFound());
        } else {
            listener.getLogger().println(Messages.XCodeBuilder_CFBundleShortVersionStringFound(cfBundleShortVersionString));
        }
        listener.getLogger().println(Messages.XCodeBuilder_CFBundleShortVersionStringValue(cfBundleShortVersionString));
        output.reset();
        listener.getLogger().println(Messages.XCodeBuilder_fetchingCFBundleVersion());
        String cfBundleVersion = "";
        returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getAgvtoolPath(), "vers", "-terse"}).stdout((OutputStream)output).pwd(projectRoot).join();
        if (returnCode == 0) {
            cfBundleVersion = output.toString().trim();
        }
        if (StringUtils.isEmpty((String)cfBundleVersion)) {
            listener.getLogger().println(Messages.XCodeBuilder_CFBundleVersionNotFound());
        } else {
            listener.getLogger().println(Messages.XCodeBuilder_CFBundleVersionFound(cfBundleVersion));
        }
        listener.getLogger().println(Messages.XCodeBuilder_CFBundleVersionValue(cfBundleVersion));
        String buildDescription = cfBundleShortVersionString + " (" + cfBundleVersion + ")";
        XCodeAction a = new XCodeAction(buildDescription);
        build.addAction((Action)a);
        if (BooleanUtils.isTrue((Boolean)this.changeBundleID)) {
            listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdentifierChanged(bundleIDInfoPlistPath, bundleID));
            returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/libexec/PlistBuddy", "-c", "Set :CFBundleIdentifier " + bundleID, bundleIDInfoPlistPath}).stdout(listener).pwd(projectRoot).join();
            if (returnCode > 0) {
                listener.fatalError(Messages.XCodeBuilder_CFBundleIdentifierInfoPlistNotFound(bundleIDInfoPlistPath));
                return false;
            }
        }
        if (BooleanUtils.isTrue((Boolean)this.provideApplicationVersion) && !StringUtils.isEmpty((String)cfBundleShortVersionStringValue)) {
            try {
                cfBundleShortVersionString = TokenMacro.expandAll(build, (FilePath)projectRoot, (TaskListener)listener, (String)cfBundleShortVersionStringValue);
                listener.getLogger().println(Messages.XCodeBuilder_CFBundleShortVersionStringUpdate(cfBundleShortVersionString));
                returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getAgvtoolPath(), "new-marketing-version", cfBundleShortVersionString}).stdout(listener).pwd(projectRoot).join();
                if (returnCode > 0) {
                    listener.fatalError(Messages.XCodeBuilder_CFBundleShortVersionStringUpdateError(cfBundleShortVersionString));
                    return false;
                }
            }
            catch (MacroEvaluationException e) {
                listener.fatalError(Messages.XCodeBuilder_CFBundleShortVersionStringMacroError(e.getMessage()));
                return false;
            }
        }
        if (BooleanUtils.isTrue((Boolean)this.provideApplicationVersion) && !StringUtils.isEmpty((String)cfBundleVersionValue)) {
            try {
                cfBundleVersion = TokenMacro.expandAll(build, (FilePath)projectRoot, (TaskListener)listener, (String)cfBundleVersionValue);
                listener.getLogger().println(Messages.XCodeBuilder_CFBundleVersionUpdate(cfBundleVersion));
                returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getAgvtoolPath(), "new-version", "-all", cfBundleVersion}).stdout(listener).pwd(projectRoot).join();
                if (returnCode > 0) {
                    listener.fatalError(Messages.XCodeBuilder_CFBundleVersionUpdateError(cfBundleVersion));
                    return false;
                }
            }
            catch (MacroEvaluationException e) {
                listener.fatalError(Messages.XCodeBuilder_CFBundleVersionMacroError(e.getMessage()));
                return false;
            }
        }
        listener.getLogger().println(Messages.XCodeBuilder_CFBundleShortVersionStringUsed(cfBundleShortVersionString));
        listener.getLogger().println(Messages.XCodeBuilder_CFBundleVersionUsed(cfBundleVersion));
        String developmentTeamID = null;
        boolean archiveAutomaticSigning = false;
        if (this.signingMethod != null && this.signingMethod.equals("readFromProject")) {
            this.provisioningProfiles = new ArrayList();
            listener.getLogger().println(Messages.XCodeBuilder_ReadSigningInfoFromProject());
            XcodeProject xcodeProject = null;
            ArrayList<FilePath> projectLocations = new ArrayList<FilePath>();
            FilePath projectLocation = null;
            if (!(StringUtils.isEmpty((String)xcodeProjectFile) || (projectLocation = projectRoot.child(xcodeProjectFile)).exists() && projectLocation.isDirectory())) {
                listener.getLogger().println(Messages.XCodeBuilder_CouldNotReadInfoFrom(projectLocation.absolutize().getRemote()));
                projectLocation = null;
            }
            if (!StringUtils.isEmpty((String)xcodeWorkspaceFile)) {
                listener.getLogger().println(Messages.XCodeBuilder_ReadInfoFromWorkspace(xcodeWorkspaceFile));
                List<String> projectList = XcodeProjectParser.parseXcodeWorkspace(projectRoot.child(xcodeWorkspaceFile + ".xcworkspace"));
                if (projectList == null) {
                    listener.getLogger().println("Empty or Invalid workspacefile: " + projectRoot.child(xcodeWorkspaceFile + ".xcworkspace").absolutize().getRemote());
                } else if (projectList.size() > 0 && xcodeSchema != null && !StringUtils.isEmpty((String)xcodeSchema)) {
                    for (String string : projectList) {
                        HashMap<String, ProjectScheme> xcodeSchemes = XcodeProjectParser.listXcodeSchemes(projectRoot.child(string));
                        if (xcodeSchemes == null) {
                            listener.getLogger().println("Skipping empty or invalid scheme file: " + string);
                            continue;
                        }
                        ProjectScheme projectScheme = xcodeSchemes.get(xcodeSchema);
                        if (projectScheme == null) {
                            listener.getLogger().println("Skipping undefined schema: " + xcodeSchema);
                            continue;
                        }
                        String referencedContainerLocation = projectScheme.referencedContainer.replaceAll("^container:", "");
                        projectLocation = projectRoot.child(referencedContainerLocation);
                        target = projectScheme.blueprintName;
                        break;
                    }
                } else {
                    if (projectList.size() > 1) {
                        listener.fatalError(Messages.XCodeBuilder_MultipleProjectInWorkSpace());
                        return false;
                    }
                    projectLocation = projectRoot.child(projectList.get(0));
                }
            }
            if (projectLocation == null) {
                List xcodeProjects = projectRoot.list((FileFilter)new XcodeProjectFileFilter());
                if (xcodeProjects == null) {
                    listener.fatalError(Messages.XCodeBuilder_NoArchivesInBuildDirectory(projectRoot.absolutize().getRemote()));
                    return false;
                }
                if (xcodeProjects.size() > 1) {
                    listener.fatalError(Messages.XCodeBuilder_MultipleProjectInWorkSpace());
                    return false;
                }
                projectLocation = (FilePath)xcodeProjects.get(0);
            }
            projectLocations.add(projectLocation);
            for (FilePath examineLocation : projectLocations) {
                xcodeProject = XcodeProjectParser.parseXcodeProject(examineLocation);
                if (xcodeProject == null) {
                    listener.getLogger().println(Messages.XCodeBuilder_CouldNotReadProjectInfoFrom(examineLocation.absolutize().getRemote()));
                    return false;
                }
                for (String key : xcodeProject.projectTarget.keySet()) {
                    Object buildConfiguration;
                    ProjectTarget projectTarget = xcodeProject.projectTarget.get(key);
                    String exportConfiguration = null;
                    if (!StringUtils.isEmpty((String)ipaExportMethod)) {
                        exportConfiguration = ipaExportMethod.equals("app-store") ? "Release" : (ipaExportMethod.equals("enterprise") ? "Enterprise" : (ipaExportMethod.equals("ad-hoc") ? "AdHoc" : "Debug"));
                    } else if (StringUtils.isEmpty((String)configuration)) {
                        exportConfiguration = projectTarget.defaultConfigurationName;
                    }
                    boolean automaticSigning = projectTarget.provisioningStyle.equals("Automatic");
                    if (projectTarget.testTargetID == null) {
                        archiveAutomaticSigning = automaticSigning;
                    }
                    if ((buildConfiguration = projectTarget.buildConfiguration.get(exportConfiguration)) == null) {
                        listener.getLogger().println(Messages.XCodeBuilder_CouldNotGetBuildConfig(exportConfiguration, examineLocation.absolutize().getRemote()));
                        exportConfiguration = "Release";
                        buildConfiguration = projectTarget.buildConfiguration.get(exportConfiguration);
                        if (buildConfiguration == null) {
                            return false;
                        }
                        listener.getLogger().println(Messages.XCodeBuilder_UseingReleaseConfigFor());
                    }
                    if (((BuildConfiguration)buildConfiguration).developmentTeamId != null) {
                        developmentTeamID = ((BuildConfiguration)buildConfiguration).developmentTeamId;
                        listener.getLogger().println(Messages.XCodeBuilder_FoundDevelopmentTeamID(developmentTeamID, examineLocation.absolutize().getRemote()));
                    }
                    if (!automaticSigning) {
                        String provisioningProfileUUID2 = ((BuildConfiguration)buildConfiguration).provisioningProfileUUID;
                        String provisioningProfileSpecifier = ((BuildConfiguration)buildConfiguration).provisioningProfileSpecifier;
                        String bundleIdentifier = null;
                        if (((BuildConfiguration)buildConfiguration).bundleIdentifier != null) {
                            bundleIdentifier = ((BuildConfiguration)buildConfiguration).bundleIdentifier;
                        } else {
                            String productName = ((BuildConfiguration)buildConfiguration).productName;
                            productName = productName.replaceAll(Pattern.quote("${TARGET_NAME}"), key);
                            productName = productName.replaceAll(Pattern.quote("$(TARGET_NAME)"), key);
                            InfoPlist infoPlist = XcodeProjectParser.parseInfoPlist(projectRoot.child(((BuildConfiguration)buildConfiguration).infoPlistFile));
                            if (infoPlist == null) {
                                listener.getLogger().println(Messages.XCodeBuilder_CouldNotReadInfoFrom(projectRoot.child(((BuildConfiguration)buildConfiguration).infoPlistFile).absolutize().getRemote()));
                                return false;
                            }
                            bundleIdentifier = infoPlist.getCfBundleIdentifier();
                            productName = productName.replaceAll(" ", "-");
                            bundleIdentifier = bundleIdentifier.replaceAll(Pattern.quote("$(PRODUCT_NAME:rfc1034identifier)"), productName);
                        }
                        String provisioningProfileIdentifier = null;
                        provisioningProfileIdentifier = provisioningProfileSpecifier != null ? provisioningProfileSpecifier : provisioningProfileUUID2;
                        if (provisioningProfileIdentifier != null) {
                            this.provisioningProfiles.add(new ProvisioningProfile(bundleIdentifier, provisioningProfileIdentifier));
                        }
                    }
                    if (!StringUtils.isEmpty((String)configuration) || !projectTarget.productType.equals("com.apple.product-type.application")) continue;
                    configuration = exportConfiguration;
                }
            }
            for (ProvisioningProfile rp : this.provisioningProfiles) {
                listener.getLogger().println("UUID/SPECIFIER                       CFbundleIdentifier");
                listener.getLogger().println(rp.getProvisioningProfileUUID() + " " + rp.getProvisioningProfileAppId());
            }
        } else {
            if (StringUtils.isEmpty((String)this.developmentTeamName)) {
                developmentTeamID = envs.expand(this.developmentTeamID);
            }
            if (StringUtils.isEmpty(developmentTeamID)) {
                Team team = this.getDevelopmentTeam();
                if (team == null) {
                    listener.getLogger().println(Messages.XCodeBuilder_teamNotConfigured());
                } else {
                    developmentTeamID = envs.expand(team.getTeamID());
                    if (!StringUtils.isEmpty((String)developmentTeamID)) {
                        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoCanFindCertificates());
                        launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "find-certificate", "-a", "-c", developmentTeamID, "-Z", "|", "grep", "^SHA-1"}).stdout(listener).pwd(projectRoot).join();
                    }
                }
            }
        }
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoAvailableSDKs());
        launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getXcodebuildPath(), "-showsdks"}).stdout(listener).pwd(projectRoot).join();
        ArrayList commandLine = Lists.newArrayList((Object[])new String[]{this.getGlobalConfiguration().getXcodebuildPath()});
        commandLine.add("-list");
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoAvailableSchemes());
        if (!StringUtils.isEmpty((String)xcodeWorkspaceFile)) {
            commandLine.add("-workspace");
            commandLine.add(xcodeWorkspaceFile + ".xcworkspace");
        } else if (!StringUtils.isEmpty((String)xcodeProjectFile)) {
            commandLine.add("-project");
            commandLine.add(xcodeProjectFile);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        returnCode = launcher.launch().envs((Map)envs).cmds((List)commandLine).stdout((OutputStream)baos).pwd(projectRoot).start().joinWithTimeout(10L, TimeUnit.SECONDS, listener);
        String xcodeBuildListOutput = baos.toString("UTF-8");
        listener.getLogger().println(xcodeBuildListOutput);
        boolean bl2 = timedOut2 = returnCode == 143;
        if (returnCode > 0 && !timedOut2) {
            return false;
        }
        XcodeBuildListParser xcodebuildListParser = new XcodeBuildListParser(xcodeBuildListOutput);
        ArrayList commandLine2 = Lists.newArrayList((Object[])new String[]{this.getGlobalConfiguration().getXcodebuildPath()});
        commandLine2.add("-help");
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoAvailableParameters());
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        returnCode = launcher.launch().envs((Map)envs).cmds((List)commandLine2).stdout((OutputStream)baos2).pwd(projectRoot).start().joinWithTimeout(10L, TimeUnit.SECONDS, listener);
        String xcodeBuildHelpOutput = baos2.toString("UTF-8");
        boolean bl3 = bl = returnCode == 143;
        if (returnCode > 0 && !bl) {
            return false;
        }
        XcodeBuildHelpParser xcodebuildHelpParser = new XcodeBuildHelpParser(xcodeBuildHelpOutput);
        boolean haveAllowProvisioningUpdates = false;
        List<String> availableParameters = xcodebuildHelpParser.getParameters();
        if (availableParameters.isEmpty()) {
            listener.getLogger().println(Messages.XCodeBuilder_NoAvailableParameters());
            haveAllowProvisioningUpdates = false;
        } else {
            listener.getLogger().println(StringUtils.join(availableParameters, (String)"\n"));
            if (availableParameters.contains("-allowProvisioningUpdates")) {
                haveAllowProvisioningUpdates = true;
            }
        }
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoLineDelimiter());
        String buildDirValue = null;
        if (!StringUtils.isEmpty((String)buildDir)) {
            try {
                buildDirValue = TokenMacro.expandAll(build, (FilePath)projectRoot, (TaskListener)listener, (String)buildDir).trim();
            }
            catch (MacroEvaluationException e) {
                listener.error(Messages.XCodeBuilder_buildDirMacroError(e.getMessage()));
                return false;
            }
        }
        if (buildDirValue != null) {
            FilePath filePath = new FilePath(projectRoot.getChannel(), buildDirValue);
        } else if (symRootValue != null) {
            FilePath filePath = new FilePath(projectRoot.getChannel(), symRootValue).child(configuration + "-" + buildPlatform);
        } else {
            FilePath filePath = projectRoot.child("build").child(configuration + "-" + buildPlatform);
        }
        listener.getLogger().println(Messages.XCodeBuilder_BuildDirectory(var44_58.absolutize()));
        returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{this.getGlobalConfiguration().getXcodebuildPath(), "-version"}).stdout(listener).pwd(projectRoot).join();
        if (returnCode > 0) {
            listener.fatalError(Messages.XCodeBuilder_xcodeVersionNotFound());
            return false;
        }
        if (BooleanUtils.isNotFalse((Boolean)this.cleanBeforeBuild)) {
            listener.getLogger().println(Messages.XCodeBuilder_cleaningBuildDir(var44_58.absolutize().getRemote()));
            var44_58.deleteRecursive();
        }
        if (BooleanUtils.isTrue((Boolean)this.cleanTestReports)) {
            listener.getLogger().println(Messages.XCodeBuilder_cleaningTestReportsDir(projectRoot.child("test-reports").absolutize().getRemote()));
            projectRoot.child("test-reports").deleteRecursive();
        }
        if (BooleanUtils.isNotFalse((Boolean)this.cleanResultBundlePath) && StringUtils.isNotEmpty((String)this.resultBundlePath)) {
            listener.getLogger().println(Messages.XCodeBuilder_CleaningResultBundlePath(projectRoot.child(this.resultBundlePath).absolutize().getRemote()));
            projectRoot.child(this.resultBundlePath).deleteRecursive();
        }
        if (BooleanUtils.isTrue((Boolean)this.unlockKeychain)) {
            String keychainPwd;
            String keychainPath;
            Object keychain;
            if (StringUtils.isNotEmpty((String)this.keychainName)) {
                listener.getLogger().println(Messages.XCodeBuilder_UseDeprecatedKeychainInfo());
                keychain = this.getKeychain(this.keychainName);
                if (keychain == null) {
                    listener.fatalError(Messages.XCodeBuilder_keychainNotConfigured());
                    return false;
                }
                keychainPath = envs.expand(((Keychain)keychain).getKeychainPath());
                keychainPwd = envs.expand(Secret.toString((Secret)((Keychain)keychain).getKeychainPassword()));
            } else if (StringUtils.isNotEmpty((String)this.keychainId)) {
                keychain = this.getKeychainPasswordAndPath((Item)build.getParent(), this.keychainId);
                if (keychain == null) {
                    listener.fatalError(Messages.XCodeBuilder_keychainNotConfigured());
                    return false;
                }
                keychainPath = envs.expand(keychain.getKeychainPath());
                keychainPwd = envs.expand(keychain.getPassword().getPlainText());
            } else {
                keychainPath = this.keychainPath;
                keychainPwd = Secret.toString((Secret)this.keychainPwd);
            }
            launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "list-keychains", "-s", keychainPath}).stdout(listener).pwd(projectRoot).join();
            launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "default-keychain", "-d", "user", "-s", keychainPath}).stdout(listener).pwd(projectRoot).join();
            returnCode = StringUtils.isEmpty((String)keychainPwd) ? launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "unlock-keychain", keychainPath}).stdout(listener).pwd(projectRoot).join() : launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "unlock-keychain", "-p", keychainPwd, keychainPath}).masks(new boolean[]{false, false, false, true, false}).stdout(listener).pwd(projectRoot).join();
            if (returnCode > 0) {
                listener.fatalError(Messages.XCodeBuilder_unlockKeychainFailed());
                return false;
            }
            launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "show-keychain-info", keychainPath}).stdout(listener).pwd(projectRoot).join();
        }
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoLineDelimiter());
        listener.getLogger().println(Messages.XCodeBuilder_DebugInfoAvailableCertificates());
        launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/bin/security", "find-identity", "-p", "codesigning", "-v"}).stdout(listener).pwd(projectRoot).join();
        if (BooleanUtils.isNotTrue((Boolean)this.skipBuildStep)) {
            boolean manualSigning;
            StringBuilder xcodeReport = new StringBuilder(Messages.XCodeBuilder_invokeXcodebuild());
            FilePath[] reportGenerator = new JenkinsXCodeBuildOutputParser(projectRoot, listener);
            ArrayList commandLine3 = Lists.newArrayList((Object[])new String[]{this.getGlobalConfiguration().getXcodebuildPath()});
            if (!StringUtils.isEmpty((String)xcodeWorkspaceFile) && StringUtils.isEmpty((String)xcodeSchema)) {
                listener.getLogger().println(Messages.XCodeBuilder_SpecifyWorkspaceAlsoSetScheme());
                return false;
            }
            if (!StringUtils.isEmpty((String)xcodeSchema)) {
                commandLine3.add("-scheme");
                commandLine3.add(xcodeSchema);
                xcodeReport.append(", scheme: ").append(xcodeSchema);
            } else if (StringUtils.isEmpty((String)target)) {
                commandLine3.add("-alltargets");
                xcodeReport.append("target: ALL");
            } else if (BooleanUtils.isTrue((Boolean)this.interpretTargetAsRegEx)) {
                if (xcodebuildListParser.getTargets().isEmpty()) {
                    listener.getLogger().println(Messages.XCodeBuilder_NoTargetsFoundInConfig());
                    return false;
                }
                Collection matchedTargets = Collections2.filter(xcodebuildListParser.getTargets(), (Predicate)Predicates.containsPattern((String)target));
                if (matchedTargets.isEmpty()) {
                    listener.getLogger().println(Messages.XCodeBuilder_NoMatchingTargetsFound());
                    return false;
                }
                for (Object matchedTarget : matchedTargets) {
                    commandLine3.add("-target");
                    commandLine3.add(matchedTarget);
                    xcodeReport.append("target: ").append((String)matchedTarget);
                }
            } else {
                commandLine3.add("-target");
                commandLine3.add(target);
                xcodeReport.append("target: ").append(target);
            }
            if (!StringUtils.isEmpty((String)sdk)) {
                commandLine3.add("-sdk");
                commandLine3.add(sdk);
                xcodeReport.append(", sdk: ").append(sdk);
            } else {
                xcodeReport.append(", sdk: DEFAULT");
            }
            if (!StringUtils.isEmpty((String)xcodeWorkspaceFile)) {
                commandLine3.add("-workspace");
                commandLine3.add(xcodeWorkspaceFile + ".xcworkspace");
                xcodeReport.append(", workspace: ").append(xcodeWorkspaceFile);
            } else if (!StringUtils.isEmpty((String)xcodeProjectFile)) {
                commandLine3.add("-project");
                commandLine3.add(xcodeProjectFile);
                xcodeReport.append(", project: ").append(xcodeProjectFile);
            } else {
                xcodeReport.append(", project: DEFAULT");
            }
            if (!StringUtils.isEmpty((String)configuration)) {
                commandLine3.add("-configuration");
                commandLine3.add(configuration);
                xcodeReport.append(", configuration: ").append(configuration);
            }
            if (BooleanUtils.isNotFalse((Boolean)this.cleanBeforeBuild)) {
                commandLine3.add("clean");
                xcodeReport.append(", clean: YES");
            } else {
                xcodeReport.append(", clean: NO");
            }
            FilePath archiveLocation = var44_58.absolutize().child(xcodeSchema + ".xcarchive");
            if (BooleanUtils.isTrue((Boolean)this.buildIpa) || BooleanUtils.isTrue((Boolean)this.generateArchive)) {
                commandLine3.add("archive");
                commandLine3.add("-archivePath");
                commandLine3.add(archiveLocation.getRemote());
                xcodeReport.append(", archive:YES");
            } else {
                xcodeReport.append(", archive:NO");
                commandLine3.add("build");
            }
            if (BooleanUtils.isTrue((Boolean)this.noConsoleLog)) {
                xcodeReport.append(", consolelog:NO");
                reportGenerator.setConsoleLog(false);
            } else {
                xcodeReport.append(", consolelog:YES");
            }
            if (!StringUtils.isEmpty((String)this.logfileOutputDirectory)) {
                xcodeReport.append(", logfileOutputDirectory: ").append(this.logfileOutputDirectory);
                reportGenerator.setLogfilePath((FilePath)var44_58, this.logfileOutputDirectory);
            }
            if (!StringUtils.isEmpty((String)this.resultBundlePath) || BooleanUtils.isTrue((Boolean)this.ignoreTestResults)) {
                reportGenerator.setIgnoreTestResults(true);
            }
            if (!StringUtils.isEmpty((String)this.resultBundlePath)) {
                commandLine3.add("-resultBundlePath");
                commandLine3.add(this.resultBundlePath);
                xcodeReport.append(", resultBundlePath: ").append(this.resultBundlePath);
            }
            if (!StringUtils.isEmpty((String)symRootValue)) {
                commandLine3.add("SYMROOT=" + symRootValue);
                xcodeReport.append(", symRoot: ").append(symRootValue);
            } else {
                xcodeReport.append(", symRoot: DEFAULT");
            }
            if (!StringUtils.isEmpty((String)buildDirValue)) {
                commandLine3.add("BUILD_DIR=" + buildDirValue);
                xcodeReport.append(", buildDir: ").append(buildDirValue);
            } else {
                xcodeReport.append(", buildDir: DEFAULT");
            }
            if (!StringUtils.isEmpty((String)developmentTeamID)) {
                commandLine3.add("DEVELOPMENT_TEAM=" + developmentTeamID);
                xcodeReport.append(", developmentTeamID: ").append(developmentTeamID);
            } else {
                xcodeReport.append(", developmentTeamID: AUTOMATIC");
            }
            if (haveAllowProvisioningUpdates && (archiveAutomaticSigning || this.signingMethod == null || this.signingMethod.equals("automatic"))) {
                commandLine3.add("-allowProvisioningUpdates");
                xcodeReport.append(", allowProvisioningUpdates: YES");
            }
            if (!StringUtils.isEmpty((String)xcodebuildArguments)) {
                commandLine3.addAll(XCodeBuilder.splitXcodeBuildArguments(xcodebuildArguments));
            }
            boolean bl4 = manualSigning = !archiveAutomaticSigning && this.signingMethod != null && (this.signingMethod.equals("manual") || this.signingMethod.equals("readFromProject"));
            if (manualSigning && this.provisioningProfiles != null && this.provisioningProfiles.size() > 0) {
                for (ProvisioningProfile pp : this.provisioningProfiles) {
                    provisioningProfileUUID = envs.expand(pp.getProvisioningProfileUUID());
                    if (StringUtils.isEmpty((String)provisioningProfileUUID) || !provisioningProfileUUID.endsWith(".mobileprovision")) continue;
                    provisioningProfileName = provisioningProfileUUID;
                    try {
                        output.reset();
                        returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/bin/sh", "-c", "/usr/libexec/PlistBuddy -c \"Print :UUID\" /dev/stdin <<< $(/usr/bin/security cms -D -i \"" + projectRoot.absolutize().child(provisioningProfileUUID).getRemote() + "\")"}).stdout((OutputStream)output).stderr((OutputStream)System.err).pwd(projectRoot).join();
                        if (returnCode == 0) {
                            homePath = FilePath.getHomeDirectory((VirtualChannel)projectRoot.getChannel());
                            provisioningProfilePath = projectRoot.child(provisioningProfileUUID);
                            provisioningProfileUUID = output.toString().trim();
                            listener.getLogger().println(Messages.XCodeBuilder_ProfileUUIDReplaceWith(provisioningProfileUUID));
                            if (!BooleanUtils.isNotFalse((Boolean)this.copyProvisioningProfile)) continue;
                            profilesLibPath = homePath.child("Library/MobileDevice/Provisioning Profiles");
                            profilesLibPath.mkdirs();
                            try {
                                provisioningProfilePath.copyTo(profilesLibPath.child(provisioningProfileUUID + ".mobileprovision"));
                                listener.getLogger().println(Messages.XCodeBuilder_CopiedProvisioningProfile(provisioningProfilePath.getRemote(), profilesLibPath.child(provisioningProfileUUID + ".mobileprovision").getRemote()));
                                continue;
                            }
                            catch (Exception ex) {
                                listener.getLogger().println(Messages.XCodeBuilder_FailedToCopyMobileProvision(ex.toString()));
                                return false;
                            }
                        }
                        listener.getLogger().println(Messages.XCodeBuilder_CouldNotGetInfoFromMobileProvision(projectRoot.absolutize().child(provisioningProfileUUID).getRemote()));
                        return false;
                    }
                    catch (Exception ex) {
                        listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdFailedGetInMobileProvision(projectRoot.absolutize().child(provisioningProfileName).getRemote(), ex.toString()));
                        return false;
                    }
                }
            }
            if (BooleanUtils.isTrue((Boolean)this.useLegacyBuildSystem)) {
                commandLine3.add("-UseModernBuildSystem=NO");
                xcodeReport.append(", useLegacyBuildSystem: YES");
            }
            listener.getLogger().println(xcodeReport.toString());
            returnCode = launcher.launch().envs((Map)envs).cmds((List)commandLine3).stdout(reportGenerator.getOutputStream()).pwd(projectRoot).join();
            reportGenerator.closeLogfile();
            if (!StringUtils.isEmpty((String)this.resultBundlePath)) {
                XcodeTestSummariesParser testSummariesParser = new XcodeTestSummariesParser(projectRoot);
                FilePath testSummariesPath = projectRoot.child(this.resultBundlePath + "/TestSummaries.plist");
                if (testSummariesPath.exists()) {
                    listener.getLogger().println(Messages.XCodeBuilder_ParseingTestSummariesPlist(testSummariesPath.absolutize().getRemote()));
                    testSummariesParser.parseTestSummariesPlist(testSummariesPath);
                } else {
                    listener.getLogger().println(Messages.XCodeBuilder_TestSummariesPlistNotExists(testSummariesPath.absolutize().getRemote()));
                }
            }
            if (BooleanUtils.isNotTrue((Boolean)this.allowFailingBuildResults)) {
                if (reportGenerator.getExitCode() != 0) {
                    return false;
                }
                if (returnCode > 0) {
                    return false;
                }
            }
        }
        if (BooleanUtils.isTrue((Boolean)this.buildIpa)) {
            if (!var44_58.exists() || !var44_58.isDirectory()) {
                listener.fatalError(Messages.XCodeBuilder_NotExistingBuildDirectory(var44_58.absolutize().getRemote()));
                return false;
            }
            if (!ArrayUtils.contains((Object[])VALID_IPA_EXPORT_METHODS, (Object)ipaExportMethod)) {
                String validMethodsMsg = StringUtils.join((Object[])VALID_IPA_EXPORT_METHODS, (String)", ");
                listener.fatalError(Messages.XCodeBuilder_IpaExportMethodMuestBeOneOfTheFollowing(validMethodsMsg));
                return false;
            }
            FilePath ipaOutputPath = null;
            if (ipaOutputDirectory != null && !StringUtils.isEmpty((String)ipaOutputDirectory) && !(ipaOutputPath = var44_58.child(ipaOutputDirectory)).exists()) {
                ipaOutputPath.mkdirs();
            }
            if (ipaOutputPath == null) {
                ipaOutputPath = var44_58;
            }
            listener.getLogger().println(Messages.XCodeBuilder_cleaningIPA());
            for (FilePath path : ipaOutputPath.list("*.ipa")) {
                path.delete();
            }
            listener.getLogger().println(Messages.XCodeBuilder_cleaningDSYM());
            for (FilePath path : ipaOutputPath.list("*-dSYM.zip")) {
                path.delete();
            }
            listener.getLogger().println(Messages.XCodeBuilder_packagingIPA());
            boolean manualSigning = !archiveAutomaticSigning && this.signingMethod != null && (this.signingMethod.equals("manual") || this.signingMethod.equals("readFromProject"));
            NSDictionary exportOptionsPlist = new NSDictionary();
            exportOptionsPlist.put("signingStyle", (Object)(manualSigning ? "manual" : "automatic"));
            exportOptionsPlist.put("method", (Object)ipaExportMethod);
            if (!StringUtils.isEmpty((String)developmentTeamID)) {
                exportOptionsPlist.put("teamID", (Object)developmentTeamID);
            }
            if (manualSigning) {
                exportOptionsPlist.put("signingCertificate", (Object)(ipaExportMethod.equals("development") ? DEV_SIGNING_CERTIFICATE_SELECTOR : DIST_SIGNING_CERTIFICATE_SELECTOR));
                if (this.provisioningProfiles != null && this.provisioningProfiles.size() > 0) {
                    NSDictionary provisioningProfileDict = new NSDictionary();
                    for (ProvisioningProfile pp : this.provisioningProfiles) {
                        String provisioningProfileAppId;
                        block185: {
                            provisioningProfileAppId = envs.expand(pp.getProvisioningProfileAppId());
                            if (!StringUtils.isEmpty((String)provisioningProfileAppId) && provisioningProfileAppId.endsWith(".plist")) {
                                try {
                                    output.reset();
                                    returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/libexec/PlistBuddy", "-c", "Print :CFBundleIdentifier", projectRoot.absolutize().child(provisioningProfileAppId).getRemote()}).stdout((OutputStream)output).pwd(projectRoot).join();
                                    if (returnCode == 0) {
                                        provisioningProfileAppId = output.toString().trim();
                                        listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdReplaceWith(provisioningProfileAppId));
                                    } else {
                                        output.reset();
                                        returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/libexec/PlistBuddy", "-c", "Print :ApplicationProperties:CFBundleIdentifier", projectRoot.absolutize().child(provisioningProfileAppId).getRemote()}).stdout((OutputStream)output).pwd(projectRoot).join();
                                        if (returnCode == 0) {
                                            provisioningProfileAppId = output.toString().trim();
                                            listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdReplaceWith(provisioningProfileAppId));
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdFailedGetInInfoPlist(projectRoot.absolutize().child(provisioningProfileAppId).getRemote(), ex.toString()));
                                }
                            }
                            if (!StringUtils.isEmpty((String)(provisioningProfileUUID = envs.expand(pp.getProvisioningProfileUUID()))) && provisioningProfileUUID.endsWith(".mobileprovision")) {
                                provisioningProfileName = provisioningProfileUUID;
                                try {
                                    output.reset();
                                    returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/bin/sh", "-c", "/usr/libexec/PlistBuddy -c \"Print :UUID\" /dev/stdin <<< $(/usr/bin/security cms -D -i \"" + projectRoot.absolutize().child(provisioningProfileUUID).getRemote() + "\")"}).stdout((OutputStream)output).stderr((OutputStream)System.err).pwd(projectRoot).join();
                                    if (returnCode == 0) {
                                        homePath = FilePath.getHomeDirectory((VirtualChannel)projectRoot.getChannel());
                                        provisioningProfilePath = projectRoot.child(provisioningProfileUUID);
                                        provisioningProfileUUID = output.toString().trim();
                                        listener.getLogger().println(Messages.XCodeBuilder_ProfileUUIDReplaceWith(provisioningProfileUUID));
                                        if (!BooleanUtils.isNotFalse((Boolean)this.copyProvisioningProfile) || !BooleanUtils.isTrue((Boolean)this.skipBuildStep)) break block185;
                                        profilesLibPath = homePath.child("Library/MobileDevice/Provisioning Profiles");
                                        profilesLibPath.mkdirs();
                                        try {
                                            provisioningProfilePath.copyTo(profilesLibPath.child(provisioningProfileUUID + ".mobileprovision"));
                                            listener.getLogger().println(Messages.XCodeBuilder_CopiedProvisioningProfile(provisioningProfilePath.getRemote(), profilesLibPath.child(provisioningProfileUUID + ".mobileprovision").getRemote()));
                                            break block185;
                                        }
                                        catch (Exception ex) {
                                            listener.getLogger().println(Messages.XCodeBuilder_FailedToCopyMobileProvision(ex.toString()));
                                            return false;
                                        }
                                    }
                                    listener.getLogger().println(Messages.XCodeBuilder_CouldNotGetInfoFromMobileProvision(projectRoot.absolutize().child(provisioningProfileName).getRemote()));
                                    return false;
                                }
                                catch (Exception ex) {
                                    listener.getLogger().println(Messages.XCodeBuilder_CFBundleIdFailedGetInMobileProvision(projectRoot.absolutize().child(provisioningProfileAppId).getRemote(), ex.toString()));
                                    return false;
                                }
                            }
                        }
                        provisioningProfileDict.put(provisioningProfileAppId, (Object)provisioningProfileUUID);
                    }
                    exportOptionsPlist.put("provisioningProfiles", (NSObject)provisioningProfileDict);
                }
            }
            exportOptionsPlist.put("iCloudContainerEnvironment", (Object)(ipaExportMethod.equals("app-store") ? PRODUCTION_ENV : DEVELOPMENT_ENV));
            exportOptionsPlist.put("stripSwiftSymbols", (Object)this.stripSwiftSymbols);
            if (ipaExportMethod.equals("app-store")) {
                exportOptionsPlist.put("uploadBitcode", (Object)this.uploadBitcode);
                exportOptionsPlist.put("uploadSymbols", (Object)this.uploadSymbols);
            } else {
                if (!StringUtils.isEmpty((String)thinning)) {
                    exportOptionsPlist.put("thinning", (Object)thinning);
                }
                exportOptionsPlist.put("compileBitcode", (Object)this.compileBitcode);
                if (BooleanUtils.isNotFalse((Boolean)this.embedOnDemandResourcesAssetPacksInBundle) && !StringUtils.isEmpty((String)onDemandResourcesAssetPacksBaseURL)) {
                    exportOptionsPlist.put("embedOnDemandResourcesAssetPacksInBundle", (Object)false);
                    exportOptionsPlist.put("onDemandResourcesAssetPacksBaseURL", (Object)onDemandResourcesAssetPacksBaseURL);
                }
                if (!StringUtils.isEmpty((String)appURL)) {
                    NSDictionary manifestPlistOprions = new NSDictionary();
                    manifestPlistOprions.put("appURL", (Object)appURL);
                    if (!StringUtils.isEmpty((String)displayImageURL)) {
                        manifestPlistOprions.put("displayImageURL", (Object)displayImageURL);
                    }
                    if (!StringUtils.isEmpty((String)fullSizeImageURL)) {
                        manifestPlistOprions.put("fullSizeImageURL", (Object)fullSizeImageURL);
                    }
                    if (!StringUtils.isEmpty((String)assetPackManifestURL)) {
                        manifestPlistOprions.put("assetPackManifestURL", (Object)assetPackManifestURL);
                    }
                    exportOptionsPlist.put("manifest", (NSObject)manifestPlistOprions);
                }
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PropertyListParser.saveAsXML((NSObject)exportOptionsPlist, (OutputStream)stream);
            FilePath exportOptionsPlistLocation = ipaOutputPath.child(ipaExportMethod + (developmentTeamID == null || StringUtils.isEmpty((String)developmentTeamID) ? "AUTOMATIC" : developmentTeamID) + "ExportOptions.plist");
            exportOptionsPlistLocation.write(stream.toString(), "UTF-8");
            List archives = var44_58.list((FileFilter)new XCArchiveFileFilter());
            if (archives == null || archives.size() < 1) {
                listener.fatalError(Messages.XCodeBuilder_NoArchivesInBuildDirectory(var44_58.absolutize().getRemote()));
                return false;
            }
            for (FilePath archive : archives) {
                String version = "";
                String shortVersion = "";
                try {
                    output.reset();
                    returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/libexec/PlistBuddy", "-c", "Print :ApplicationProperties:CFBundleVersion", archive.absolutize().child("Info.plist").getRemote()}).stdout((OutputStream)output).pwd(projectRoot).join();
                    if (returnCode == 0) {
                        version = output.toString().trim();
                    }
                    output.reset();
                    returnCode = launcher.launch().envs((Map)envs).cmds(new String[]{"/usr/libexec/PlistBuddy", "-c", "Print :ApplicationProperties:CFBundleShortVersionString", archive.absolutize().child("Info.plist").getRemote()}).stdout((OutputStream)output).pwd(projectRoot).join();
                    if (returnCode == 0) {
                        shortVersion = output.toString().trim();
                    }
                }
                catch (Exception ex) {
                    listener.getLogger().println(Messages.XCodeBuilder_FailedToGetVersionFromInfoPlist(ex.toString()));
                    return false;
                }
                if (StringUtils.isEmpty((String)version) && StringUtils.isEmpty((String)shortVersion)) {
                    listener.getLogger().println(Messages.XCodeBuilder_MarketingAndTechnicalVersionNotFound());
                    return false;
                }
                String lastModified = new SimpleDateFormat("yyyy.MM.dd").format(new Date(archive.lastModified()));
                String baseName = archive.getBaseName().replaceAll(" ", "_") + (shortVersion.isEmpty() ? "" : "-" + shortVersion) + (version.isEmpty() ? "" : "-" + version);
                if (!StringUtils.isEmpty((String)ipaName)) {
                    EnvVars customVars = new EnvVars(new String[]{"BASE_NAME", archive.getBaseName().replaceAll(" ", "_"), "VERSION", version, "SHORT_VERSION", shortVersion, "BUILD_DATE", lastModified});
                    baseName = customVars.expand(ipaName);
                }
                String ipaFileName = baseName + ".ipa";
                FilePath ipaLocation = ipaOutputPath.child(ipaFileName);
                FilePath payload = ipaOutputPath.child("Payload");
                payload.deleteRecursive();
                payload.mkdirs();
                listener.getLogger().println(Messages.XCodeBuilder_PackagingArchiveToIpa(archive.getBaseName(), ipaLocation.absolutize().getRemote()));
                if (buildPlatform.contains("simulator")) {
                    listener.getLogger().println(Messages.XCodeBuilder_warningPackagingIPAForSimulatorSDK(sdk));
                }
                ArrayList<String> packageCommandLine = new ArrayList<String>();
                packageCommandLine.add(this.getGlobalConfiguration().getXcodebuildPath());
                packageCommandLine.addAll(Lists.newArrayList((Object[])new String[]{"-exportArchive", "-archivePath", archive.absolutize().getRemote(), "-exportPath", ipaOutputPath.absolutize().getRemote(), "-exportOptionsPlist", exportOptionsPlistLocation.absolutize().getRemote()}));
                if ((archiveAutomaticSigning || this.signingMethod == null || !this.signingMethod.equals("manual") && !this.signingMethod.equals("readFromProject")) && haveAllowProvisioningUpdates) {
                    packageCommandLine.add("-allowProvisioningUpdates");
                }
                if ((returnCode = launcher.launch().envs((Map)envs).stdout(listener).pwd(projectRoot).cmds(packageCommandLine).join()) > 0) {
                    listener.getLogger().println(Messages.XCodeBuilder_FailedToBuildIpa(ipaLocation.absolutize().getRemote()));
                    return false;
                }
                FilePath exportedIpa = ipaOutputPath.child(archive.getBaseName() + ".ipa");
                if (exportedIpa.exists()) {
                    exportedIpa.renameTo(ipaLocation);
                }
                listener.getLogger().println(Messages.XCodeBuilder_ArchivingDSYM());
                List dSYMs = archive.absolutize().child("dSYMs").list((FileFilter)new DSymFileFilter());
                if (dSYMs == null || dSYMs.isEmpty()) {
                    listener.getLogger().println(Messages.XCodeBuilder_NoDSYMFileFound(archive.absolutize().child("dSYMs")));
                }
                if (dSYMs == null || dSYMs.isEmpty()) {
                    listener.getLogger().println(Messages.XCodeBuilder_NoDSYMFileFound(archive.absolutize().child("dSYMs")));
                } else {
                    for (FilePath dSYM : dSYMs) {
                        returnCode = launcher.launch().envs((Map)envs).stdout(listener).pwd((FilePath)var44_58).cmds(new String[]{"ditto", "-c", "-k", "--keepParent", "-rsrc", dSYM.absolutize().getRemote(), ipaOutputPath.child(baseName + "-dSYM.zip").absolutize().getRemote()}).join();
                        if (returnCode <= 0) continue;
                        listener.getLogger().println(Messages.XCodeBuilder_zipFailed(baseName));
                        return false;
                    }
                }
                payload.deleteRecursive();
            }
        }
        return true;
    }

    @Deprecated
    public Keychain getKeychain(String keychainName) {
        if (!StringUtils.isEmpty((String)keychainName)) {
            for (Keychain keychain : this.getGlobalConfiguration().getKeychains()) {
                if (!keychain.getKeychainName().equals(keychainName)) continue;
                return keychain;
            }
        }
        return null;
    }

    public KeychainPasswordAndPath getKeychainPasswordAndPath(Item context, String keychainId) {
        if (!StringUtils.isEmpty((String)keychainId)) {
            return (KeychainPasswordAndPath)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KeychainPasswordAndPath.class, (Item)context, (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)keychainId));
        }
        return null;
    }

    public Team getDevelopmentTeam() {
        if (!StringUtils.isEmpty((String)this.developmentTeamName)) {
            for (Team team : this.getGlobalConfiguration().getTeams()) {
                if (!team.getTeamName().equals(this.developmentTeamName)) continue;
                return team;
            }
        }
        if (!StringUtils.isEmpty((String)this.developmentTeamID)) {
            return new Team("", this.developmentTeamID);
        }
        return null;
    }

    static List<String> splitXcodeBuildArguments(String xcodebuildArguments) {
        if (xcodebuildArguments == null || xcodebuildArguments.length() == 0) {
            return new ArrayList<String>(0);
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(xcodebuildArguments);
        ArrayList<String> result = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken());
        }
        return result;
    }

    public GlobalConfigurationImpl getGlobalConfiguration() {
        return this.getDescriptor().getGlobalConfiguration();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"xcodeBuild"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        GlobalConfigurationImpl globalConfiguration;
        @Deprecated
        private transient String xcodebuildPath;
        private transient String agvtoolPath;
        private transient String xcrunPath;
        private transient CopyOnWriteList<Keychain> keychains;
        private transient CopyOnWriteList<Team> teams;

        public DescriptorImpl() {
            this.load();
        }

        @Inject
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        void setGlobalConfiguration(GlobalConfigurationImpl c) {
            this.globalConfiguration = c;
            boolean modified = false;
            if (this.xcodebuildPath != null) {
                c.setXcodebuildPath(this.xcodebuildPath);
                modified = true;
            }
            if (this.agvtoolPath != null) {
                c.setAgvtoolPath(this.agvtoolPath);
                modified = true;
            }
            if (this.xcrunPath != null) {
                c.setXcrunPath(this.xcrunPath);
                modified = true;
            }
            if (this.keychains != null) {
                c.setKeychains(new ArrayList<Keychain>(this.keychains.getView()));
                modified = true;
            }
            if (this.teams != null) {
                c.setTeams(new ArrayList<Team>(this.teams.getView()));
                modified = true;
            }
            if (modified) {
                c.save();
                this.save();
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.XCodeBuilder_xcode();
        }

        public GlobalConfigurationImpl getGlobalConfiguration() {
            return this.globalConfiguration;
        }

        public String getUUID() {
            return "" + UUID.randomUUID().getMostSignificantBits();
        }

        public FormValidation doCheckOnDemandResourcesAssetPacksBaseURL(@QueryParameter String value, @QueryParameter Boolean embedOnDemandResourcesAssetPacksInBundle) {
            if (StringUtils.isEmpty((String)value) && BooleanUtils.isFalse((Boolean)embedOnDemandResourcesAssetPacksInBundle)) {
                return FormValidation.error((String)Messages.XCodeBuilder_NeedOnDemandResourcesURL());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIpaExportMethod(@QueryParameter String value, @QueryParameter Boolean buildIpa) {
            if (BooleanUtils.isTrue((Boolean)buildIpa) && !ArrayUtils.contains((Object[])VALID_IPA_EXPORT_METHODS, (Object)value)) {
                String validMethodsMsg = StringUtils.join((Object[])VALID_IPA_EXPORT_METHODS, (String)", ");
                return FormValidation.error((String)Messages.XCodeBuilder_IpaExportMethodMuestBeOneOfTheFollowing(validMethodsMsg));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXcodeWorkspaceFile(@QueryParameter String value, @QueryParameter String xcodeSchema, @QueryParameter String target) {
            if (!StringUtils.isEmpty((String)value)) {
                if (!StringUtils.isEmpty((String)target)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_WorkspaceAndTargetCantSpecifySameTime());
                }
                if (StringUtils.isEmpty((String)xcodeSchema)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_SpecifyWorkspaceAlsoSetScheme());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXcodeSchema(@QueryParameter String value, @QueryParameter Boolean generateArchive, @QueryParameter Boolean buildIpa, @QueryParameter String xcodeWorkspaceFile, @QueryParameter String target) {
            if (!StringUtils.isEmpty((String)value)) {
                if (!StringUtils.isEmpty((String)target)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_SchemeAndTargetCantSpecifySameTime());
                }
            } else {
                if (!StringUtils.isEmpty((String)xcodeWorkspaceFile)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_SpecifyWorkspaceAlsoSetScheme());
                }
                if (BooleanUtils.isTrue((Boolean)generateArchive) || BooleanUtils.isTrue((Boolean)buildIpa)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_NeedSchema());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTarget(@QueryParameter String value, @QueryParameter String xcodeWorkspaceFile, @QueryParameter String xcodeSchema) {
            if (!StringUtils.isEmpty((String)value)) {
                if (!StringUtils.isEmpty((String)xcodeWorkspaceFile)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_WorkspaceAndTargetCantSpecifySameTime());
                }
                if (!StringUtils.isEmpty((String)xcodeSchema)) {
                    return FormValidation.error((String)Messages.XCodeBuilder_SchemeAndTargetCantSpecifySameTime());
                }
            }
            return FormValidation.ok();
        }
    }
}

