/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jenkinsci.plugins.deploy.weblogic.ArtifactSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeStyleJobArtifactSelectorImpl
implements ArtifactSelector {
    @Override
    public FilePath selectArtifactRecorded(AbstractBuild<?, ?> build, BuildListener listener, String filteredResource, String baseDirectory) throws IOException, XmlPullParserException, InterruptedException {
        FilePath selectedArtifact = null;
        listener.getLogger().println("[WeblogicDeploymentPlugin] - Retrieving artifacts recorded [filtered resources on " + filteredResource + "]...");
        ArrayList<FilePath> artifactsRecorded = new ArrayList<FilePath>();
        if (StringUtils.isBlank((String)baseDirectory)) {
            FilePath workspace = build.getWorkspace();
            List filesInWorkspace = workspace.list(this.recursiveFileFilter());
            listener.getLogger().println("[WeblogicDeploymentPlugin] - " + filesInWorkspace.size() + " files found under " + workspace.getName());
            for (FilePath file : filesInWorkspace) {
                if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource recorded " + file.getName() + " is eligible.");
                    artifactsRecorded.add(file);
                    continue;
                }
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following resource " + file.getName() + " doesn't match " + filteredResource);
            }
        } else {
            File baseDir = new File(baseDirectory);
            if (!(baseDir.exists() && baseDir.isDirectory() && baseDir.canRead())) {
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the base directory specified [" + baseDirectory + "] is invalid (doesn't exists or is not a directory or has insufficient privilege). Please check the job configuration");
                throw new RuntimeException("The base directory specified [" + baseDirectory + "] is invalid (doesn't exists or is not a directory or has insufficient privilege)");
            }
            Collection files = FileUtils.listFiles((File)baseDir, null, (boolean)true);
            listener.getLogger().println("[WeblogicDeploymentPlugin] - " + files.size() + " files found under " + baseDir);
            for (File file : files) {
                if (!file.isDirectory() && Pattern.matches(filteredResource, file.getName())) {
                    listener.getLogger().println("[WeblogicDeploymentPlugin] - the following file recorded " + file.getName() + " is eligible.");
                    artifactsRecorded.add(new FilePath(file));
                    continue;
                }
                listener.getLogger().println("[WeblogicDeploymentPlugin] - the following file " + file.getName() + " doesn't match " + filteredResource);
            }
        }
        if (artifactsRecorded.size() < 1) {
            throw new RuntimeException("[WeblogicDeploymentPlugin] - No artifact to deploy [" + filteredResource + "] found.");
        }
        if (artifactsRecorded.size() > 1) {
            listener.getLogger().println("[WeblogicDeploymentPlugin] - More than 1 artifact found : The first one " + artifactsRecorded.get(0) + " will be deployed!!!");
        }
        if ((selectedArtifact = (FilePath)artifactsRecorded.get(0)) == null) {
            throw new RuntimeException("No artifact to deploy found.");
        }
        return selectedArtifact;
    }

    @Override
    public String getName() {
        return "FreeStyleProject";
    }

    private FileFilter recursiveFileFilter() {
        IOFileFilter effFileFilter = FileFilterUtils.andFileFilter((IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)DirectoryFileFilter.INSTANCE));
        IOFileFilter effDirFilter = FileFilterUtils.andFileFilter((IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.INSTANCE);
        return FileFilterUtils.orFileFilter((IOFileFilter)effFileFilter, (IOFileFilter)effDirFilter);
    }
}

