/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.Description;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualE1000;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconfigureNetworkAdapters
extends ReconfigureStep {
    private final ReconfigureStep.DeviceAction deviceAction;
    private final String deviceLabel;
    private final String macAddress;
    private final String portGroup;

    @DataBoundConstructor
    public ReconfigureNetworkAdapters(ReconfigureStep.DeviceAction deviceAction, String deviceLabel, String macAddress, String portGroup) throws VSphereException {
        this.deviceAction = deviceAction;
        this.deviceLabel = deviceLabel;
        this.macAddress = macAddress;
        this.portGroup = portGroup;
    }

    public ReconfigureStep.DeviceAction getDeviceAction() {
        return this.deviceAction;
    }

    public String getDeviceLabel() {
        return this.deviceLabel;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getPortGroup() {
        return this.portGroup;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedDeviceLabel = env.expand(this.deviceLabel);
        String expandedMacAddress = env.expand(this.macAddress);
        String expandedPortGroup = env.expand(this.portGroup);
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: " + this.deviceAction.getLabel() + " Network Adapter \"" + expandedDeviceLabel + "\"");
        VirtualE1000 vEth = null;
        if (this.deviceAction == ReconfigureStep.DeviceAction.ADD) {
            vEth = new VirtualE1000();
            vEth.setBacking((VirtualDeviceBackingInfo)new VirtualEthernetCardNetworkBackingInfo());
            Description description = vEth.getDeviceInfo();
            if (description == null) {
                description = new Description();
            }
            description.setLabel(expandedDeviceLabel);
            vEth.setDeviceInfo(description);
        } else {
            vEth = this.findNetworkDeviceByLabel(this.vm.getConfig().getHardware().getDevice(), expandedDeviceLabel);
        }
        if (vEth == null) {
            throw new VSphereException("Could not find network device named " + expandedDeviceLabel);
        }
        if (!expandedMacAddress.isEmpty()) {
            VSphereLogger.vsLogger(jLogger, "Reconfiguring MAC Address -> " + expandedMacAddress);
            vEth.setMacAddress(expandedMacAddress);
        }
        if (!expandedPortGroup.isEmpty()) {
            VSphereLogger.vsLogger(jLogger, "Reconfiguring Network Port Group -> " + expandedPortGroup);
            VirtualEthernetCardNetworkBackingInfo backing = (VirtualEthernetCardNetworkBackingInfo)vEth.getBacking();
            backing.deviceName = expandedPortGroup;
        }
        VirtualDeviceConfigSpec vdspec = new VirtualDeviceConfigSpec();
        vdspec.setDevice((VirtualDevice)vEth);
        if (this.deviceAction == ReconfigureStep.DeviceAction.EDIT) {
            vdspec.setOperation(VirtualDeviceConfigSpecOperation.edit);
        } else if (this.deviceAction == ReconfigureStep.DeviceAction.REMOVE) {
            vdspec.setOperation(VirtualDeviceConfigSpecOperation.remove);
        }
        VirtualDeviceConfigSpec[] deviceConfigSpecs = this.spec.getDeviceChange();
        deviceConfigSpecs = deviceConfigSpecs == null ? new VirtualDeviceConfigSpec[1] : Arrays.copyOf(deviceConfigSpecs, deviceConfigSpecs.length + 1);
        deviceConfigSpecs[deviceConfigSpecs.length - 1] = vdspec;
        this.spec.setDeviceChange(deviceConfigSpecs);
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    private VirtualEthernetCard findNetworkDeviceByLabel(VirtualDevice[] devices, String label) {
        for (VirtualDevice vd : devices) {
            if (!(vd instanceof VirtualEthernetCard) || !label.isEmpty() && !vd.getDeviceInfo().getLabel().contentEquals(label)) continue;
            return (VirtualEthernetCard)vd;
        }
        return null;
    }

    @Extension
    public static final class ReconfigureNetworkAdaptersDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureNetworkAdaptersDescriptor() {
            this.load();
        }

        public FormValidation doCheckMacAddress(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the MAC Address"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureNetworkAdapter();
        }

        public FormValidation doTestData(@QueryParameter ReconfigureStep.DeviceAction deviceAction, @QueryParameter String deviceLabel, @QueryParameter String macAddress, @QueryParameter String portGroup) {
            try {
                return this.doCheckMacAddress(macAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

