/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerOff
extends VSphereBuildStep {
    private final String vm;
    private final boolean evenIfSuspended;
    private final boolean shutdownGracefully;

    @DataBoundConstructor
    public PowerOff(String vm, boolean evenIfSuspended, boolean shutdownGracefully) throws VSphereException {
        this.vm = vm;
        this.evenIfSuspended = evenIfSuspended;
        this.shutdownGracefully = shutdownGracefully;
    }

    public boolean isEvenIfSuspended() {
        return this.evenIfSuspended;
    }

    public boolean isShutdownGracefully() {
        return this.shutdownGracefully;
    }

    public String getVm() {
        return this.vm;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        return this.powerOff(build, launcher, listener);
    }

    private boolean powerOff(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        VSphereLogger.vsLogger(jLogger, "Shutting Down VM...");
        this.vsphere.powerOffVm(this.vsphere.getVmByName(expandedVm), this.evenIfSuspended, this.shutdownGracefully);
        VSphereLogger.vsLogger(jLogger, "Successfully shutdown \"" + expandedVm + "\"");
        return true;
    }

    @Extension
    public static class PowerOffDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_PowerOff();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VSphere vsphere = PowerOffDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

