/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clone
extends VSphereBuildStep {
    private final String sourceName;
    private final String clone;
    private final boolean linkedClone;
    private final String resourcePool;
    private final String cluster;
    private final String datastore;

    @DataBoundConstructor
    public Clone(String sourceName, String clone, boolean linkedClone, String resourcePool, String cluster, String datastore) throws VSphereException {
        this.sourceName = sourceName;
        this.clone = clone;
        this.linkedClone = linkedClone;
        this.resourcePool = resourcePool;
        this.cluster = cluster;
        this.datastore = datastore;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getClone() {
        return this.clone;
    }

    public boolean isLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        return this.cloneFromSource(build, launcher, listener);
    }

    private boolean cloneFromSource(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedClone = env.expand(this.clone);
        String expandedSource = env.expand(this.sourceName);
        String expandedCluster = env.expand(this.cluster);
        String expandedDatastore = env.expand(this.datastore);
        String expandedResourcePool = env.expand(this.resourcePool);
        this.vsphere.cloneVm(expandedClone, expandedSource, this.linkedClone, expandedResourcePool, expandedCluster, expandedDatastore, jLogger);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedClone + "\" successfully cloned!");
        return true;
    }

    @Extension
    public static final class CloneDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public CloneDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_Clone();
        }

        public FormValidation doCheckSource(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the sourceName name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClone(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the clone name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResourcePool(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the resource pool"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCluster(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the cluster"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String sourceName, @QueryParameter String clone, @QueryParameter String resourcePool, @QueryParameter String cluster) {
            try {
                if (sourceName.length() == 0 || clone.length() == 0 || serverName.length() == 0 || resourcePool.length() == 0 || cluster.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = CloneDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine cloneVM = vsphere.getVmByName(clone);
                if (cloneVM != null) {
                    return FormValidation.error((String)Messages.validation_exists("clone"));
                }
                if (sourceName.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("sourceName"));
                }
                VirtualMachine vm = vsphere.getVmByName(sourceName);
                if (vm == null) {
                    return FormValidation.error((String)Messages.validation_notFound("sourceName"));
                }
                VirtualMachineSnapshot snap = vm.getCurrentSnapShot();
                if (snap == null) {
                    return FormValidation.error((String)Messages.validation_noSnapshots());
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

