/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReconfigureAnnotation
extends ReconfigureStep {
    private String annotation;
    private boolean append;

    @DataBoundConstructor
    public ReconfigureAnnotation() {
    }

    @DataBoundSetter
    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation == null ? "" : this.annotation;
    }

    @DataBoundSetter
    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean getAppend() {
        return this.append;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.reconfigureAnnotation(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.reconfigureAnnotation((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public boolean reconfigureAnnotation(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        String currentTextOrNullIfEmpty;
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedText = this.getAnnotation();
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedText = env.expand(expandedText);
        }
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: Annotation");
        if (this.getAppend() && (currentTextOrNullIfEmpty = this.spec.getAnnotation()) != null) {
            expandedText = currentTextOrNullIfEmpty + expandedText;
        }
        this.spec.setAnnotation(expandedText);
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Extension
    public static final class ReconfigureAnnotationDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureAnnotationDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureAnnotation();
        }
    }
}

