/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconfigureMemory
extends ReconfigureStep {
    private final String memorySize;

    @DataBoundConstructor
    public ReconfigureMemory(String memorySize) throws VSphereException {
        this.memorySize = memorySize;
    }

    public String getMemorySize() {
        return this.memorySize;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedMemorySize = env.expand(this.memorySize);
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: Memory");
        this.spec.setMemoryMB(Long.valueOf(expandedMemorySize));
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Extension
    public static final class ReconfigureMemoryDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureMemoryDescriptor() {
            this.load();
        }

        public FormValidation doCheckMemorySize(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Memory Size"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureMemory();
        }

        public FormValidation doTestData(@QueryParameter String memorySize) {
            try {
                return this.doCheckMemorySize(memorySize);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

