/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSphereBuildStepContainer
extends Builder {
    private final VSphereBuildStep buildStep;
    private final String serverName;
    private final int serverHash;

    @DataBoundConstructor
    public VSphereBuildStepContainer(VSphereBuildStep buildStep, String serverName) throws VSphereException {
        this.buildStep = buildStep;
        this.serverName = serverName;
        this.serverHash = VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByName(serverName).getHash();
    }

    public String getServerName() {
        return this.serverName;
    }

    public VSphereBuildStep getBuildStep() {
        return this.buildStep;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            this.startLogs(listener.getLogger());
            VSphere vsphere = VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByHash(this.serverHash).vSphereInstance();
            this.buildStep.setVsphere(vsphere);
            return this.buildStep.perform(build, launcher, listener);
        }
        catch (Exception e) {
            VSphereLogger.vsLogger(listener.getLogger(), e.getMessage());
            return false;
        }
    }

    private void startLogs(PrintStream logger) {
        VSphereLogger.vsLogger(logger, "");
        VSphereLogger.vsLogger(logger, Messages.console_buildStepStart(this.buildStep.getDescriptor().getDisplayName()));
        VSphereLogger.vsLogger(logger, Messages.console_usingServerConfig(this.serverName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class VSphereBuildStepContainerDescriptor
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.vsphere.builders.VSphereBuildStepContainer", VSphereBuildStepContainer.class);
        }

        public String getDisplayName() {
            return Messages.plugin_title_BuildStep();
        }

        public DescriptorExtensionList<VSphereBuildStep, VSphereBuildStep.VSphereBuildStepDescriptor> getBuildSteps() {
            return VSphereBuildStep.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillServerNameItems() {
            ListBoxModel select = new ListBoxModel();
            try {
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof vSphereCloud)) continue;
                    select.add(((vSphereCloud)cloud).getVsDescription());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return select;
        }
    }
}

