/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class ReportConverter {
    private boolean initFlg = false;
    private Transformer metricsTransformer;

    public void initialize() throws TransformerConfigurationException, TransformerFactoryConfigurationError, ParserConfigurationException {
        if (this.initFlg) {
            return;
        }
        this.metricsTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(this.getClass().getResourceAsStream("metrics-convert.xsl")));
        this.initFlg = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convertFile(InputStream metricsFileStream, File outputPath) {
        FileOutputStream os = null;
        try {
            if (!this.initFlg) {
                this.initialize();
            }
            os = new FileOutputStream(outputPath);
            this.metricsTransformer.transform(new StreamSource(metricsFileStream), new StreamResult(os));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {}
            try {
                if (metricsFileStream != null) {
                    metricsFileStream.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

