/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jenkinsci.plugins.vs_code_metrics.Messages;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsInstallation;
import org.jenkinsci.plugins.vs_code_metrics.util.StringUtil;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsCodeMetricsBuilder
extends Builder {
    private final String toolName;
    private final String files;
    private final String outputXML;
    private final String directory;
    private final boolean searchGac;
    private final String platform;
    private final String reference;
    private final boolean ignoreInvalidTargets;
    private final boolean ignoreGeneratedCode;
    private final String cmdLineArgs;
    private final boolean failBuild;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VsCodeMetricsBuilder(String toolName, String files, String outputXML, String directory, boolean searchGac, String platform, String reference, boolean ignoreInvalidTargets, boolean ignoreGeneratedCode, String cmdLineArgs, boolean failBuild) {
        this.toolName = toolName;
        this.files = files;
        this.outputXML = outputXML;
        this.directory = directory;
        this.searchGac = searchGac;
        this.platform = platform;
        this.reference = reference;
        this.ignoreInvalidTargets = ignoreInvalidTargets;
        this.ignoreGeneratedCode = ignoreGeneratedCode;
        this.cmdLineArgs = cmdLineArgs;
        this.failBuild = failBuild;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getFiles() {
        return this.files;
    }

    public String getOutputXML() {
        return this.outputXML;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isSearchGac() {
        return this.searchGac;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getReference() {
        return this.reference;
    }

    public boolean isIgnoreInvalidTargets() {
        return this.ignoreInvalidTargets;
    }

    public boolean isIgnoreGeneratedCode() {
        return this.ignoreGeneratedCode;
    }

    public String getCmdLineArgs() {
        return this.cmdLineArgs;
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public VsCodeMetricsInstallation getInstallation() {
        if (this.toolName == null) {
            return null;
        }
        for (VsCodeMetricsInstallation i : DESCRIPTOR.getInstallations()) {
            if (!this.toolName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<String> args = new ArrayList<String>();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String toolPath = this.getToolPath(launcher, listener, env);
        if (StringUtil.isNullOrSpace(toolPath)) {
            return false;
        }
        args.add(toolPath);
        if (!StringUtil.isNullOrSpace(this.files)) {
            args.addAll(this.getArguments(build, env, "file", this.files));
        }
        if (!StringUtil.isNullOrSpace(this.outputXML)) {
            args.add(StringUtil.convertArgumentWithQuote("out", this.outputXML));
            FilePath outputXMLPath = build.getWorkspace().child(this.outputXML);
            if (outputXMLPath.exists()) {
                outputXMLPath.delete();
            } else {
                outputXMLPath.getParent().mkdirs();
            }
        }
        if (!StringUtil.isNullOrSpace(this.directory)) {
            args.addAll(this.getArguments(build, env, "directory", this.directory));
        }
        if (this.searchGac) {
            args.add("/searchgac");
        }
        if (!StringUtil.isNullOrSpace(this.platform)) {
            args.add(StringUtil.convertArgumentWithQuote("platform", this.platform));
        }
        if (!StringUtil.isNullOrSpace(this.reference)) {
            args.addAll(this.getArguments(build, env, "reference", this.reference));
        }
        if (this.ignoreInvalidTargets) {
            args.add("/ignoreinvalidtargets");
        }
        if (this.ignoreGeneratedCode) {
            args.add("/ignoregeneratedcode");
        }
        if (!StringUtil.isNullOrSpace(this.cmdLineArgs)) {
            args.add(this.cmdLineArgs);
        }
        boolean r = this.execTool(args, build, launcher, listener, env);
        return r;
    }

    private String getToolPath(Launcher launcher, BuildListener listener, EnvVars env) throws InterruptedException, IOException {
        String execName = "Metrics.exe";
        VsCodeMetricsInstallation installation = this.getInstallation();
        if (installation == null) {
            listener.getLogger().println("Path To Metrics.exe: " + execName);
            return execName;
        }
        installation = installation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
        installation = installation.forEnvironment(env);
        String pathToMetrics = installation.getHome();
        FilePath exec = new FilePath(launcher.getChannel(), pathToMetrics);
        try {
            if (!exec.exists()) {
                listener.fatalError(pathToMetrics + " doesn't exist");
                return null;
            }
        }
        catch (IOException e) {
            listener.fatalError("Failed checking for existence of " + pathToMetrics);
            return null;
        }
        listener.getLogger().println("Path To Metrics.exe: " + pathToMetrics);
        return StringUtil.appendQuote(pathToMetrics);
    }

    private List<String> getArguments(AbstractBuild<?, ?> build, EnvVars env, String option, String values) throws InterruptedException, IOException {
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer valuesToknzr = new StringTokenizer(values, " \t\r\n");
        while (valuesToknzr.hasMoreTokens()) {
            String value = valuesToknzr.nextToken();
            value = Util.replaceMacro((String)value, (Map)env);
            if (StringUtil.isNullOrSpace(value = Util.replaceMacro((String)value, (Map)build.getBuildVariables()))) continue;
            args.add(StringUtil.convertArgumentWithQuote(option, value));
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execTool(List<String> args, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, EnvVars env) throws InterruptedException, IOException {
        ArgumentListBuilder cmdExecArgs = new ArgumentListBuilder();
        FilePath tmpDir = null;
        FilePath pwd = build.getWorkspace();
        if (!launcher.isUnix()) {
            tmpDir = pwd.createTextTempFile("vs_code_metrics", ".bat", StringUtil.concatString(args), false);
            cmdExecArgs.add(new String[]{"cmd.exe", "/C", tmpDir.getRemote(), "&&", "exit", "%ERRORLEVEL%"});
        } else {
            for (String arg : args) {
                cmdExecArgs.add(arg);
            }
        }
        listener.getLogger().println("Executing Metrics: " + cmdExecArgs.toStringWithQuote());
        try {
            int r = launcher.launch().cmds(cmdExecArgs).envs((Map)env).stdout((TaskListener)listener).pwd(pwd).join();
            if (this.failBuild) {
                boolean bl = r == 0;
                return bl;
            }
            if (r != 0) {
                build.setResult(Result.UNSTABLE);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Metrics execution failed"));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (tmpDir != null) {
                    tmpDir.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("temporary file delete failed"));
            }
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private volatile VsCodeMetricsInstallation[] installations = new VsCodeMetricsInstallation[0];

        DescriptorImpl() {
            super(VsCodeMetricsBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.VsCodeMetricsBuilder_DisplayName();
        }

        public VsCodeMetricsInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(VsCodeMetricsInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public VsCodeMetricsInstallation.DescriptorImpl getToolDescriptor() {
            return (VsCodeMetricsInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(VsCodeMetricsInstallation.DescriptorImpl.class));
        }
    }
}

