/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.vmanager.BuildStatusMap;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vmanager.PostActionBase;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.jenkinsci.plugins.vmanager.dsl.post.DSLProjectAction;

public class DSLBuildAction
extends PostActionBase
implements Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private String message;
    private transient Run<?, ?> build;
    private final List projectActions;

    public String getIconFileName() {
        return "/plugin/vmanager-plugin/img/weblinks.png";
    }

    public String getDisplayName() {
        return "vManager Session Links";
    }

    public String getUrlName() {
        return "vManagerSessionsView";
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getJobSessions() {
        Job job = this.build.getParent();
        String string = job.getBuildDir() + File.separator + this.build.getNumber();
        this.vmgrRun = new VMGRRun(this.build, string, job.getBuildDir().getAbsolutePath());
        String string2 = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir() + "", "id", true);
        List<String> list = Arrays.asList(string2.split("\\s*,\\s*"));
        return list;
    }

    public String getvManagerLink(boolean bl) {
        String string = "#";
        if (this.build != null) {
            Job job = this.build.getParent();
            String string2 = job.getBuildDir() + File.separator + this.build.getNumber();
            VMGRRun vMGRRun = new VMGRRun(this.build, string2, job.getBuildDir().getAbsolutePath());
            String string3 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "id", true);
            if (string3.indexOf(",") > 0) {
                string = bl ? "vManagerSessionsView" : this.build.getNumber() + "/vManagerSessionsView";
            } else {
                String string4 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "url", false);
                string = Utils.getRegressionURLFromVAPIURL(string4) + "?sessionid=" + string3;
            }
        }
        return string;
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public DSLBuildAction(String string, Run<?, ?> run) {
        this.message = string;
        this.build = run;
        ArrayList<DSLProjectAction> arrayList = new ArrayList<DSLProjectAction>();
        arrayList.add(new DSLProjectAction(run.getParent()));
        this.projectActions = arrayList;
    }

    public Collection<? extends Action> getProjectActions() {
        return this.projectActions;
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }
}

