/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.plugins.vmanager.Utils;

public class VMGRBuildArchiver {
    private boolean vMGRBuildArchive = false;
    private String archiveUser;
    private String archivePassword;
    private boolean deleteAlsoSessionDirectory = false;
    private boolean genericCredentialForSessionDelete = false;
    private String famMode;
    private String famModeLocation;

    public VMGRBuildArchiver(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, String string4) {
        this.archiveUser = string;
        this.archivePassword = string2;
        this.vMGRBuildArchive = bl;
        this.deleteAlsoSessionDirectory = bl2;
        this.genericCredentialForSessionDelete = bl3;
        this.famMode = string3;
        this.famModeLocation = string4;
    }

    public VMGRBuildArchiver() {
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public void setVMGRBuildArchive(boolean bl) {
        this.vMGRBuildArchive = this.vMGRBuildArchive;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public void setArchiveUser(String string) {
        this.archiveUser = string;
    }

    public String getArchivePassword() {
        return this.archivePassword;
    }

    public void setArchivePassword(String string) {
        this.archivePassword = string;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public void setSeleteAlsoSessionDirectory(boolean bl) {
        this.deleteAlsoSessionDirectory = bl;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public void setGenericCredentialForSessionDelete(boolean bl) {
        this.genericCredentialForSessionDelete = bl;
    }

    public void markBuildForArchive(List<String> list, String string, boolean bl, String string2, String string3, String string4, TaskListener taskListener) {
        String string5 = null;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string5 == null) {
                string5 = iterator.next();
                continue;
            }
            string5 = string5 + "," + iterator.next();
        }
        String string6 = string4 + File.separator + "sdi.properties";
        try {
            FileWriter fileWriter = new FileWriter(string6);
            String string7 = string.trim();
            string7 = string7.substring(0, string7.length() - 6);
            fileWriter.append("url=" + string7 + "\n");
            fileWriter.append("deleteAlsoSessionDirectory=" + this.deleteAlsoSessionDirectory + "\n");
            fileWriter.append("genericCredentialForSessionDelete=" + this.genericCredentialForSessionDelete + "\n");
            fileWriter.append("requireAuth=" + bl + "\n");
            fileWriter.append("famMode=" + this.famMode + "\n");
            if ("true".equals(this.famMode)) {
                fileWriter.append("famModeLocation=" + this.famModeLocation + "\n");
            }
            if (this.genericCredentialForSessionDelete) {
                fileWriter.append("archiveUser=" + this.archiveUser + "\n");
                fileWriter.append("archivePassword=" + this.archivePassword + "\n");
            } else {
                fileWriter.append("archiveUser=" + string2 + "\n");
                fileWriter.append("archivePassword=" + string3 + "\n");
            }
            fileWriter.append("sessions=" + string5 + "\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            taskListener.getLogger().print("ERROR - Failed to create sdi.properties file on " + string6);
            taskListener.getLogger().print(iOException.getMessage());
        }
    }

    public void deleteSessions(Run run, Logger logger) throws Exception {
        File file = new File(run.getRootDir().getPath() + File.separator + "sdi.properties");
        if (!file.exists()) {
            return;
        }
        Properties properties = this.loadProperties(run.getRootDir().getPath(), logger);
        if ("true".equals(properties.getProperty("famMode"))) {
            long l = System.currentTimeMillis();
            File file2 = new File(properties.getProperty("famModeLocation").trim() + File.separator + run.getNumber() + "-" + l + "-sdi.properties");
            Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
        } else {
            String string;
            Object object;
            Object object2;
            Object object3;
            String string2 = null;
            String string3 = properties.getProperty("archiveUser").trim() + ":" + properties.getProperty("archivePassword").trim();
            boolean bl = true;
            if ("false".equals(properties.getProperty("requireAuth").trim())) {
                bl = false;
            }
            if ("true".equals(properties.getProperty("genericCredentialForSessionDelete").trim())) {
                object3 = "{\"update\":{\"owner\":\"" + properties.getProperty("archiveUser").trim() + "\"},\"rs\":{\"filter\":{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[" + properties.getProperty("sessions") + "]}}}";
                string2 = properties.getProperty("url").trim();
                string2 = string2 + "update";
                object2 = this.getVAPIConnection(string2, bl, string3);
                object = ((URLConnection)object2).getOutputStream();
                ((OutputStream)object).write(((String)object3).getBytes());
                ((OutputStream)object).flush();
                if (((HttpURLConnection)object2).getResponseCode() != 200 && ((HttpURLConnection)object2).getResponseCode() != 204 && ((HttpURLConnection)object2).getResponseCode() != 202 && ((HttpURLConnection)object2).getResponseCode() != 201 && ((HttpURLConnection)object2).getResponseCode() != 206 && ((HttpURLConnection)object2).getResponseCode() != 205) {
                    string = "";
                    if (((HttpURLConnection)object2).getResponseCode() == 503) {
                        string = "Failed to delete sessions.  vAPI process failed to connect to remote vManager server.";
                    }
                    if (((HttpURLConnection)object2).getResponseCode() == 401) {
                        string = "Failed to delete sessions.  Authentication Error";
                    }
                    if (((HttpURLConnection)object2).getResponseCode() == 408) {
                        string = "Failed to delete sessions.  No more licences are available for vAPI";
                    }
                    logger.log(Level.SEVERE, string);
                    this.processErrorFromRespone((HttpURLConnection)object2, logger);
                }
                ((HttpURLConnection)object2).disconnect();
            }
            string2 = properties.getProperty("url").trim();
            string2 = string2 + "delete";
            object3 = this.getVAPIConnection(string2, bl, string3);
            object2 = ((URLConnection)object3).getOutputStream();
            object = "{\"rs\":{\"filter\":{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[" + properties.getProperty("sessions") + "]}},\"with-session-dir\":" + properties.getProperty("deleteAlsoSessionDirectory").trim() + "}";
            ((OutputStream)object2).write(((String)object).getBytes());
            ((OutputStream)object2).flush();
            if (((HttpURLConnection)object3).getResponseCode() != 200 && ((HttpURLConnection)object3).getResponseCode() != 204 && ((HttpURLConnection)object3).getResponseCode() != 202 && ((HttpURLConnection)object3).getResponseCode() != 201 && ((HttpURLConnection)object3).getResponseCode() != 206 && ((HttpURLConnection)object3).getResponseCode() != 205) {
                string = "";
                if (((HttpURLConnection)object3).getResponseCode() == 503) {
                    string = "Failed to delete sessions.  vAPI process failed to connect to remote vManager server.";
                }
                if (((HttpURLConnection)object3).getResponseCode() == 401) {
                    string = "Failed to delete sessions.  Authentication Error";
                }
                if (((HttpURLConnection)object3).getResponseCode() == 408) {
                    string = "Failed to delete sessions.  No more licences are available for vAPI";
                }
                logger.log(Level.SEVERE, string);
                this.processErrorFromRespone((HttpURLConnection)object3, logger);
            } else {
                logger.log(Level.INFO, "Sessions " + properties.getProperty("sessions") + "were deleted from vManager DB");
            }
            ((HttpURLConnection)object3).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processErrorFromRespone(HttpURLConnection httpURLConnection, Logger logger) {
        String string = "";
        StringBuilder stringBuilder = null;
        int n = 0;
        try {
            String string2;
            stringBuilder = new StringBuilder(httpURLConnection.getResponseMessage());
            n = httpURLConnection.getResponseCode();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            string = "Failed : HTTP error code : " + n + " (" + stringBuilder + ")\n";
            logger.log(Level.SEVERE, string);
        }
    }

    private Properties loadProperties(String string, Logger logger) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(string + File.separator + "sdi.properties");
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Failed to read " + string + File.separator + "sdi.properties during delete of session operation", iOException);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return properties;
    }

    public HttpURLConnection getVAPIConnection(String string, boolean bl, String string2) throws Exception {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (string.indexOf("https://") > -1) {
            Utils.configureAllowAll((HttpsURLConnection)httpURLConnection);
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setReadTimeout(1800000);
        if (bl) {
            byte[] byArray = Base64.encodeBase64((byte[])string2.getBytes());
            String string3 = new String(byArray);
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string3);
        }
        return httpURLConnection;
    }
}

