/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;

public class UnitTestFormatter {
    List runs = null;
    String sessionId = null;
    JUnitRequestHolder jUnitRequestHolder = null;
    Map<String, String> extraAttrLabels = null;

    public UnitTestFormatter(List list, String string, JUnitRequestHolder jUnitRequestHolder, Map<String, String> map) {
        this.runs = list;
        this.sessionId = string;
        this.jUnitRequestHolder = jUnitRequestHolder;
        this.extraAttrLabels = map;
    }

    public List getRuns() {
        return this.runs;
    }

    public void setRuns(JSONArray jSONArray) {
        this.runs = jSONArray;
    }

    public void dumpXMLFile(String string, int n, String string2) throws IOException {
        if (this.runs.size() > 0) {
            String string3 = string + File.separator + "session_runs.xml";
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.append("<testsuite tests=\"vManager\">\n");
            Iterator iterator = this.runs.iterator();
            JSONObject jSONObject = null;
            String string4 = "NA";
            String string5 = "NA";
            String string6 = "NA";
            String string7 = "NA";
            int n2 = 0;
            String string8 = "NA";
            String string9 = "NA";
            while (iterator.hasNext()) {
                jSONObject = (JSONObject)iterator.next();
                string4 = jSONObject.has("status") ? jSONObject.getString("status") : "NA";
                string5 = jSONObject.has("test_group") ? UnitTestFormatter.stripNonValidXMLCharacters(jSONObject.getString("test_group")) : "NA";
                string6 = jSONObject.has("test_name") ? UnitTestFormatter.stripNonValidXMLCharacters(jSONObject.getString("test_name")) : "NA";
                string7 = jSONObject.has("computed_seed") ? UnitTestFormatter.stripNonValidXMLCharacters(jSONObject.getString("computed_seed")) : "NA";
                if (jSONObject.has("duration")) {
                    try {
                        n2 = new Integer(jSONObject.getString("duration"));
                    }
                    catch (Exception exception) {}
                } else {
                    n2 = 0;
                }
                String string10 = "";
                if (!this.jUnitRequestHolder.isNoAppendSeed()) {
                    string10 = " : Seed-" + string7;
                }
                if ("failed".equals(string4)) {
                    string8 = jSONObject.has("first_failure_name") ? UnitTestFormatter.stripNonValidXMLCharacters(jSONObject.getString("first_failure_name")) : "RUN_STILL_IN_PROGRESS";
                    string9 = jSONObject.has("first_failure_description") ? UnitTestFormatter.stripNonValidXMLCharacters(jSONObject.getString("first_failure_description")) : "    Run is in state running,other or waiting.\n     Reason for run to mark as failed is because session change status to such that build was marked as failed.";
                    fileWriter.append("\t\t<testcase classname=\"" + string5 + "\" name=\"" + string6 + string10 + "\" time=\"" + n2 + "\">\n");
                    fileWriter.append("\t\t\t<failure message=\"" + string8 + "\" type=\"" + string8 + "\">First Error Description: \n" + string9 + "\nComputed Seed: \n" + string7 + "\n" + UnitTestFormatter.stripNonValidXMLCharacters(this.addExtraAttrValues(jSONObject)) + "</failure>\n");
                    fileWriter.append("\t\t</testcase>\n");
                    continue;
                }
                if ("stopped".equals(string4) || "running".equals(string4) || "other".equals(string4) || "waiting".equals(string4)) {
                    fileWriter.append("\t\t<testcase classname=\"" + string5 + "\" name=\"" + string6 + string10 + "\" time=\"" + n2 + "\">\n");
                    fileWriter.append("\t\t <skipped />\n");
                    fileWriter.append("\t\t</testcase>\n");
                    continue;
                }
                fileWriter.append("\t\t<testcase classname=\"" + string5 + "\" name=\"" + string6 + string10 + "\" time=\"" + n2 + "\"/>\n");
            }
            fileWriter.append("</testsuite>\n");
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private String addExtraAttrValues(JSONObject jSONObject) {
        List<String> list = Arrays.asList(this.jUnitRequestHolder.getStaticAttributeList().split("\\s*,\\s*"));
        Iterator<String> iterator = list.iterator();
        String string = "";
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            string2 = iterator.next();
            if (string2.indexOf(" ") > 0 || string2.equals("first_failure_name") || string2.equals("first_failure_description") || string2.equals("computed_seed") || string2.equals("test_group") || string2.equals("test_name")) continue;
            if (jSONObject.has(string2)) {
                string3 = jSONObject.getString(string2);
                string3 = string3.replaceAll("<__SEPARATOR__>", "\n    ");
                string = string + this.extraAttrLabels.get(string2) + ":\n    " + string3 + "\n";
                continue;
            }
            string3 = "NA";
        }
        return string;
    }

    public static String stripNonValidXMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        stringBuilder.append("&#" + c + ";");
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

